/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public final class FileSearchParams {
    private final ExecutionEnvironment execEnv;
    private final List<String> searchPaths;
    private final String filename;
    private final boolean searchInUserPaths;

    public FileSearchParams(ExecutionEnvironment execEnv, List<String> searchPaths, String filename, boolean searchInUserPaths) {
        if (execEnv == null || searchPaths == null || filename == null) {
            throw new NullPointerException("FileSearchParams cannot be null");
        }
        this.execEnv = execEnv;
        this.searchPaths = Collections.unmodifiableList(new ArrayList<String>(searchPaths));
        this.filename = filename;
        this.searchInUserPaths = searchInUserPaths;
    }

    public ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getSearchPaths() {
        return this.searchPaths;
    }

    public boolean isSearchInUserPaths() {
        return this.searchInUserPaths;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileSearchParams)) {
            return false;
        }
        FileSearchParams that = (FileSearchParams)obj;
        return this.searchInUserPaths == that.searchInUserPaths && this.execEnv.equals(that.execEnv) && this.filename.equals(that.filename) && this.searchPaths.equals(that.searchPaths);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.execEnv != null ? this.execEnv.hashCode() : 0);
        hash = 29 * hash + (this.searchPaths != null ? this.searchPaths.hashCode() : 0);
        hash = 29 * hash + (this.filename != null ? this.filename.hashCode() : 0);
        hash = 29 * hash + (this.searchInUserPaths ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File to search: " + this.filename + "; ");
        sb.append("Search env: " + this.execEnv.toString() + "; ");
        sb.append("Search paths: " + Arrays.toString(this.searchPaths.toArray(new String[0])) + "; ");
        sb.append("Search in PATH: " + (this.searchInUserPaths ? "yes" : "no"));
        return sb.toString();
    }
}

