/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.endpoint;

import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.jca.endpoint.AbstractMessageEndpointFactory;
import org.springframework.util.ReflectionUtils;

public class GenericMessageEndpointFactory
extends AbstractMessageEndpointFactory {
    private Object messageListener;

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        GenericMessageEndpoint endpoint = (GenericMessageEndpoint)super.createEndpoint(xaResource);
        ProxyFactory proxyFactory = new ProxyFactory(this.messageListener);
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor((Object)endpoint);
        introduction.suppressInterface(MethodInterceptor.class);
        proxyFactory.addAdvice((Advice)introduction);
        return (MessageEndpoint)proxyFactory.getProxy();
    }

    protected AbstractMessageEndpointFactory.AbstractMessageEndpoint createEndpointInternal() throws UnavailableException {
        return new GenericMessageEndpoint();
    }

    public static class InternalResourceException
    extends RuntimeException {
        protected InternalResourceException(ResourceException cause) {
            super(cause);
        }
    }

    private class GenericMessageEndpoint
    extends AbstractMessageEndpointFactory.AbstractMessageEndpoint
    implements MethodInterceptor {
        private GenericMessageEndpoint() {
            super(GenericMessageEndpointFactory.this);
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            boolean applyDeliveryCalls;
            boolean bl = applyDeliveryCalls = !this.hasBeforeDeliveryBeenCalled();
            if (applyDeliveryCalls) {
                try {
                    this.beforeDelivery(null);
                }
                catch (ResourceException ex) {
                    if (ReflectionUtils.declaresException((Method)methodInvocation.getMethod(), ((Object)((Object)ex)).getClass())) {
                        throw ex;
                    }
                    throw new InternalResourceException(ex);
                }
            }
            try {
                Object ex = methodInvocation.proceed();
                return ex;
            }
            catch (Throwable ex) {
                this.onEndpointException(ex);
                throw ex;
            }
            finally {
                if (applyDeliveryCalls) {
                    try {
                        this.afterDelivery();
                    }
                    catch (ResourceException ex) {
                        if (ReflectionUtils.declaresException((Method)methodInvocation.getMethod(), ((Object)((Object)ex)).getClass())) {
                            throw ex;
                        }
                        throw new InternalResourceException(ex);
                    }
                }
            }
        }

        protected ClassLoader getEndpointClassLoader() {
            return GenericMessageEndpointFactory.this.messageListener.getClass().getClassLoader();
        }
    }
}

