/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.WindowDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class WindowOperator
extends ContainerOperator
implements Outputable {
    TestOut output;
    WindowDriver driver = DriverManager.getWindowDriver(this.getClass());

    public WindowOperator(Window w) {
        super(w);
    }

    public WindowOperator(WindowOperator owner, ComponentChooser chooser, int index) {
        this(owner.waitSubWindow(chooser, index));
        this.copyEnvironment(owner);
    }

    public WindowOperator(WindowOperator owner, ComponentChooser chooser) {
        this(owner, chooser, 0);
    }

    public WindowOperator(WindowOperator owner, int index) {
        this(WindowOperator.waitWindow(owner, ComponentSearcher.getTrueChooser("Any Window"), index));
        this.copyEnvironment(owner);
    }

    public WindowOperator(WindowOperator owner) {
        this(owner, 0);
    }

    public WindowOperator(int index, Operator env) {
        this(WindowOperator.waitWindow(ComponentSearcher.getTrueChooser("Any Window"), index, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public WindowOperator(int index) {
        this(index, WindowOperator.getEnvironmentOperator());
    }

    public WindowOperator() {
        this(0);
    }

    public static Window findWindow(ComponentChooser chooser, int index) {
        return WindowWaiter.getWindow(chooser, index);
    }

    public static Window findWindow(ComponentChooser chooser) {
        return WindowOperator.findWindow(chooser, 0);
    }

    public static Window findWindow(Window owner, ComponentChooser chooser, int index) {
        return WindowWaiter.getWindow(owner, chooser, index);
    }

    public static Window findWindow(Window owner, ComponentChooser chooser) {
        return WindowOperator.findWindow(owner, chooser, 0);
    }

    public static Window waitWindow(ComponentChooser chooser, int index) {
        return WindowOperator.waitWindow(chooser, index, JemmyProperties.getCurrentTimeouts(), JemmyProperties.getCurrentOutput());
    }

    public static Window waitWindow(ComponentChooser chooser) {
        return WindowOperator.waitWindow(chooser, 0);
    }

    public static Window waitWindow(Window owner, ComponentChooser chooser, int index) {
        return WindowOperator.waitWindow(owner, chooser, index, JemmyProperties.getCurrentTimeouts(), JemmyProperties.getCurrentOutput());
    }

    public static Window waitWindow(Window owner, ComponentChooser chooser) {
        return WindowOperator.waitWindow(owner, chooser, 0);
    }

    @Override
    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (WindowDriver)DriverManager.getDriver("drivers.window", this.getClass(), anotherOperator.getProperties());
    }

    public void activate() {
        this.output.printLine("Activate window\n    " + this.getSource().toString());
        this.output.printGolden("Activate window");
        this.driver.activate(this);
    }

    public void requestClose() {
        this.output.printLine("Requesting close of window\n    " + this.getSource().toString());
        this.output.printGolden("Requesting close of window");
        this.driver.requestClose(this);
    }

    public void requestCloseAndThenHide() {
        this.output.printLine("Closing window\n    " + this.getSource().toString());
        this.output.printGolden("Closing window");
        this.driver.requestCloseAndThenHide(this);
        if (this.getVerification()) {
            this.waitClosed();
        }
    }

    public void close() {
        this.output.printLine("Closing window\n    " + this.getSource().toString());
        this.output.printGolden("Closing window");
        this.driver.close(this);
        if (this.getVerification()) {
            this.waitClosed();
        }
    }

    public void move(int x, int y) {
        this.output.printLine("Moving frame\n    " + this.getSource().toString());
        this.output.printGolden("Moving frame");
        this.driver.move(this, x, y);
    }

    public void resize(int width, int height) {
        this.output.printLine("Resizing frame\n    " + this.getSource().toString());
        this.output.printGolden("Resizing frame");
        this.driver.resize(this, width, height);
    }

    public Window findSubWindow(ComponentChooser chooser, int index) {
        this.getOutput().printLine("Looking for \"" + chooser.getDescription() + "\" subwindow");
        return WindowOperator.findWindow((Window)this.getSource(), chooser, index);
    }

    public Window findSubWindow(ComponentChooser chooser) {
        return this.findSubWindow(chooser, 0);
    }

    public Window waitSubWindow(ComponentChooser chooser, int index) {
        this.getOutput().printLine("Waiting for \"" + chooser.getDescription() + "\" subwindow");
        WindowWaiter ww = new WindowWaiter();
        ww.setOutput(this.getOutput());
        ww.setTimeouts(this.getTimeouts());
        try {
            return ww.waitWindow((Window)this.getSource(), chooser, index);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting for \"" + chooser.getDescription() + "\" window has been interrupted", e);
        }
    }

    public Window waitSubWindow(ComponentChooser chooser) {
        return this.waitSubWindow(chooser, 0);
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait window to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait window to be closed");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return !comp.isVisible();
            }

            @Override
            public String getDescription() {
                return "Closed window";
            }
        });
    }

    public void addWindowListener(final WindowListener windowListener) {
        this.runMapping(new Operator.MapVoidAction("addWindowListener"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).addWindowListener(windowListener);
            }
        });
    }

    public void applyResourceBundle(final String string) {
        this.runMapping(new Operator.MapVoidAction("applyResourceBundle"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).applyResourceBundle(string);
            }
        });
    }

    public void applyResourceBundle(final ResourceBundle resourceBundle) {
        this.runMapping(new Operator.MapVoidAction("applyResourceBundle"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).applyResourceBundle(resourceBundle);
            }
        });
    }

    public void dispose() {
        this.runMapping(new Operator.MapVoidAction("dispose"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).dispose();
            }
        });
    }

    public Component getFocusOwner() {
        return (Component)this.runMapping(new Operator.MapAction("getFocusOwner"){

            @Override
            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getFocusOwner();
            }
        });
    }

    public Window[] getOwnedWindows() {
        return (Window[])this.runMapping(new Operator.MapAction("getOwnedWindows"){

            @Override
            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getOwnedWindows();
            }
        });
    }

    public Window getOwner() {
        return (Window)this.runMapping(new Operator.MapAction("getOwner"){

            @Override
            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getOwner();
            }
        });
    }

    public String getWarningString() {
        return (String)this.runMapping(new Operator.MapAction("getWarningString"){

            @Override
            public Object map() {
                return ((Window)WindowOperator.this.getSource()).getWarningString();
            }
        });
    }

    public void pack() {
        this.runMapping(new Operator.MapVoidAction("pack"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).pack();
            }
        });
    }

    public void removeWindowListener(final WindowListener windowListener) {
        this.runMapping(new Operator.MapVoidAction("removeWindowListener"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).removeWindowListener(windowListener);
            }
        });
    }

    public void toBack() {
        this.runMapping(new Operator.MapVoidAction("toBack"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).toBack();
            }
        });
    }

    public void toFront() {
        this.runMapping(new Operator.MapVoidAction("toFront"){

            @Override
            public void map() {
                ((Window)WindowOperator.this.getSource()).toFront();
            }
        });
    }

    public boolean isFocused() {
        if (System.getProperty("java.specification.version").compareTo("1.3") > 0) {
            return this.runMapping(new Operator.MapBooleanAction("isFocused"){

                @Override
                public boolean map() {
                    try {
                        return (Boolean)new ClassReference(WindowOperator.this.getSource()).invokeMethod("isFocused", null, null);
                    }
                    catch (InvocationTargetException e) {
                        return false;
                    }
                    catch (NoSuchMethodException e) {
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        return false;
                    }
                }
            });
        }
        return this.getFocusOwner() != null;
    }

    public boolean isActive() {
        if (System.getProperty("java.specification.version").compareTo("1.3") > 0) {
            return this.runMapping(new Operator.MapBooleanAction("isActive"){

                @Override
                public boolean map() {
                    try {
                        return (Boolean)new ClassReference(WindowOperator.this.getSource()).invokeMethod("isActive", null, null);
                    }
                    catch (InvocationTargetException e) {
                        return false;
                    }
                    catch (NoSuchMethodException e) {
                        return false;
                    }
                    catch (IllegalAccessException e) {
                        return false;
                    }
                }
            });
        }
        return this.isShowing();
    }

    protected static Window waitWindow(ComponentChooser chooser, int index, Timeouts timeouts, TestOut output) {
        try {
            WindowWaiter waiter = new WindowWaiter();
            waiter.setTimeouts(timeouts);
            waiter.setOutput(output);
            return waiter.waitWindow(chooser, index);
        }
        catch (InterruptedException e) {
            output.printStackTrace(e);
            return null;
        }
    }

    protected static Window waitWindow(WindowOperator owner, ComponentChooser chooser, int index) {
        return WindowOperator.waitWindow((Window)owner.getSource(), chooser, index, owner.getTimeouts(), owner.getOutput());
    }

    protected static Window waitWindow(Window owner, ComponentChooser chooser, int index, Timeouts timeouts, TestOut output) {
        try {
            WindowWaiter waiter = new WindowWaiter();
            waiter.setTimeouts(timeouts);
            waiter.setOutput(output);
            return waiter.waitWindow(owner, chooser, index);
        }
        catch (InterruptedException e) {
            JemmyProperties.getCurrentOutput().printStackTrace(e);
            return null;
        }
    }
}

