/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.test;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestSkippedResult;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.TestSuccessResult;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.spi.GradleProgressListenerProvider;
import org.netbeans.modules.gradle.test.GradleTestSuite;
import org.netbeans.modules.gradle.test.GradleTestcase;
import org.netbeans.modules.gsf.testrunner.api.CoreManager;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.openide.util.Lookup;

public final class GradleTestProgressListener
implements ProgressListener,
GradleProgressListenerProvider {
    private final Project project;
    TestSession session;
    Map<String, Testcase> runningTests = new ConcurrentHashMap<String, Testcase>();

    public GradleTestProgressListener(Project project) {
        this.project = project;
    }

    public void statusChanged(ProgressEvent evt) {
        JvmTestOperationDescriptor jvmTest;
        TestOperationDescriptor desc = (TestOperationDescriptor)evt.getDescriptor();
        if (evt instanceof TestStartEvent) {
            TestStartEvent start = (TestStartEvent)evt;
            if (desc.getParent() == null) {
                this.sessionStart(start);
            } else if (desc instanceof JvmTestOperationDescriptor) {
                jvmTest = (JvmTestOperationDescriptor)desc;
                switch (jvmTest.getJvmTestKind()) {
                    case ATOMIC: {
                        this.caseStart(start, jvmTest);
                        break;
                    }
                    case SUITE: {
                        this.suiteStart(start, jvmTest);
                        break;
                    }
                }
            }
        }
        if (evt instanceof TestFinishEvent) {
            TestFinishEvent finish = (TestFinishEvent)evt;
            if (desc.getParent() == null) {
                this.sessionFinish(finish);
            } else if (desc instanceof JvmTestOperationDescriptor) {
                jvmTest = (JvmTestOperationDescriptor)desc;
                switch (jvmTest.getJvmTestKind()) {
                    case ATOMIC: {
                        this.caseFinish(finish, jvmTest);
                        break;
                    }
                    case SUITE: {
                        this.suiteFinish(finish, jvmTest);
                        break;
                    }
                }
            }
        }
    }

    private void sessionStart(TestStartEvent evt) {
        this.session = new TestSession(evt.getDisplayName(), this.project, TestSession.SessionType.TEST);
        this.runningTests.clear();
        CoreManager manager = GradleTestProgressListener.getManager();
        if (manager != null) {
            manager.registerNodeFactory();
            manager.testStarted(this.session);
        }
    }

    private void sessionFinish(TestFinishEvent evt) {
        this.runningTests.clear();
        CoreManager manager = GradleTestProgressListener.getManager();
        if (manager != null) {
            manager.sessionFinished(this.session);
        }
    }

    private void suiteStart(TestStartEvent evt, JvmTestOperationDescriptor op) {
    }

    private void suiteFinish(TestFinishEvent evt, JvmTestOperationDescriptor op) {
        TestOperationResult result = evt.getResult();
        TestSuite currentSuite = this.session.getCurrentSuite();
        String suiteName = GradleTestSuite.suiteName((OperationDescriptor)op);
        if (suiteName.equals(currentSuite.getName())) {
            Report report = this.session.getReport(result.getEndTime() - result.getStartTime());
            CoreManager manager = GradleTestProgressListener.getManager();
            if (manager != null) {
                manager.displayReport(this.session, report, true);
            }
        }
    }

    private void caseStart(TestStartEvent evt, JvmTestOperationDescriptor op) {
        assert (this.session != null);
        assert (op.getParent() != null);
        TestSuite currentSuite = this.session.getCurrentSuite();
        GradleTestSuite newSuite = new GradleTestSuite((JvmTestOperationDescriptor)op.getParent());
        if (currentSuite == null || !currentSuite.equals((Object)newSuite)) {
            this.session.addSuite((TestSuite)newSuite);
            CoreManager manager = GradleTestProgressListener.getManager();
            if (manager != null) {
                manager.displaySuiteRunning(this.session, (TestSuite)newSuite);
            }
        }
        GradleTestcase tc = new GradleTestcase(op, this.session);
        this.runningTests.put(GradleTestProgressListener.getTestOpKey(op), (Testcase)tc);
        this.session.addTestCase((Testcase)tc);
    }

    private void caseFinish(TestFinishEvent evt, JvmTestOperationDescriptor op) {
        Testcase tc = this.runningTests.get(GradleTestProgressListener.getTestOpKey(op));
        if (tc != null) {
            TestOperationResult result = evt.getResult();
            long time = result.getEndTime() - result.getStartTime();
            tc.setTimeMillis(time);
            tc.setLocation(this.searchLocation(op.getClassName(), op.getMethodName(), null));
            if (result instanceof TestSuccessResult) {
                tc.setStatus(Status.PASSED);
            }
            if (result instanceof TestSkippedResult) {
                tc.setStatus(Status.SKIPPED);
            }
            if (result instanceof TestFailureResult) {
                Failure failure;
                tc.setStatus(Status.ERROR);
                TestFailureResult fail = (TestFailureResult)result;
                Failure failure2 = failure = fail.getFailures().isEmpty() ? null : (Failure)fail.getFailures().iterator().next();
                if (failure != null) {
                    Trouble trouble = new Trouble(failure.getMessage() == null);
                    if (failure.getMessage() != null) {
                        tc.setStatus(Status.FAILED);
                        Matcher m = Pattern.compile("expected:(.+) but was:(.+)").matcher(failure.getMessage());
                        if (m.matches()) {
                            trouble.setComparisonFailure(new Trouble.ComparisonFailure(m.group(1), m.group(2)));
                        }
                    }
                    String desc = failure.getDescription();
                    String[] stackTrace = null;
                    if (desc != null) {
                        stackTrace = desc.split("\\n");
                        trouble.setStackTrace(stackTrace);
                    }
                    tc.setLocation(this.searchLocation(op.getClassName(), op.getMethodName(), stackTrace));
                    tc.setTrouble(trouble);
                }
            }
            this.runningTests.remove(GradleTestProgressListener.getTestOpKey(op));
        }
    }

    private static String getTestOpKey(JvmTestOperationDescriptor op) {
        return op.getClassName() + "." + op.getMethodName();
    }

    private static CoreManager getManager() {
        Collection providers = Lookup.getDefault().lookupResult(CoreManager.class).allItems();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals("org-netbeans-modules-gradle".concat("_").concat("junit"))) continue;
            return (CoreManager)provider.getInstance();
        }
        return null;
    }

    private String searchLocation(String className, String methodName, String[] stackTrace) {
        int lastDot;
        String pkg;
        StringBuilder ret = new StringBuilder(className.length() + methodName.length() + 10);
        String fileName = null;
        String line = null;
        if (stackTrace != null) {
            String fullMethodName = className + "." + methodName;
            String failedAt = null;
            for (String st : stackTrace) {
                int i = st.indexOf(fullMethodName);
                if (i <= 0) continue;
                failedAt = st.substring(i + fullMethodName.length() + 1, st.length() - 1);
                break;
            }
            if (failedAt != null && failedAt.contains(":")) {
                int sepa = failedAt.indexOf(58);
                fileName = failedAt.substring(0, sepa);
                line = failedAt.substring(sepa + 1);
                try {
                    Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    line = null;
                }
            }
        }
        String string = pkg = (lastDot = className.lastIndexOf(46)) > 0 ? className.substring(0, lastDot) : "";
        if (fileName != null) {
            ret.append(pkg.replace('.', '/')).append('/').append(fileName);
        } else {
            ret.append(className.replace('.', '/')).append(".java");
        }
        ret.append(':');
        ret.append(line != null ? line : methodName);
        return ret.toString();
    }

    public ProgressListener getProgressListener() {
        return this;
    }

    public Set<OperationType> getSupportedOperationTypes() {
        return EnumSet.of(OperationType.TEST);
    }
}

