/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.mylyn.util.AccessorImpl;
import org.netbeans.modules.mylyn.util.Bundle;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.NbTaskDataState;
import org.netbeans.modules.mylyn.util.RepositoryConnectorProvider;
import org.netbeans.modules.mylyn.util.TaskDataListener;
import org.netbeans.modules.mylyn.util.UnsubmittedTasksContainer;
import org.netbeans.modules.mylyn.util.commands.CommandFactory;
import org.netbeans.modules.mylyn.util.internal.CommandsAccessor;
import org.netbeans.modules.mylyn.util.internal.TaskListener;
import org.netbeans.modules.mylyn.util.localtasks.internal.LocalTaskDataHandler;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class MylynSupport {
    private static MylynSupport instance;
    private static final String BACKUP_SUFFIX = ".backup";
    private final TaskRepositoryManager taskRepositoryManager;
    private final TaskRepository localTaskRepository;
    private final TaskList taskList;
    private final RepositoryModel repositoryModel;
    private final SynchronizationManger synchronizationManager;
    private final TaskDataManager taskDataManager;
    private final TaskActivityManager taskActivityManager;
    private final TaskListExternalizer taskListWriter;
    private final File taskListStorageFile;
    private boolean taskListInitialized;
    private CommandFactory factory;
    private static final Logger LOG;
    private ITaskListChangeListener taskListListener;
    private static final String PROP_REPOSITORY_CREATION_TIME = "repository.creation.time_";
    private IRepositoryListener taskRepositoryManagerListener;
    private static final String ATTR_TASK_INCOMING_NEW = "NetBeans.task.unseen";
    private static final RequestProcessor RP;
    private final RequestProcessor.Task saveTask;
    private boolean dirty;
    private final Map<TaskRepository, UnsubmittedTasksContainer> unsubmittedTaskContainers;
    private ITaskDataManagerListener taskDataManagerListener;
    private final List<TaskDataListener> taskDataListeners;
    private final Map<ITask, List<TaskListener>> taskListeners;
    private final Map<ITask, Reference<NbTask>> tasks = new WeakHashMap<ITask, Reference<NbTask>>();
    private final Map<TaskListener, ITask> taskPerList = new HashMap<TaskListener, ITask>();
    private Lookup.Result<RepositoryConnectorProvider> result;

    public static synchronized MylynSupport getInstance() {
        if (instance == null) {
            instance = new MylynSupport();
        }
        return instance;
    }

    private MylynSupport() {
        this.taskRepositoryManager = new TaskRepositoryManager();
        this.taskRepositoryManager.addRepositoryConnector((AbstractRepositoryConnector)new LocalRepositoryConnector());
        this.localTaskRepository = new TaskRepository("local", "local");
        this.localTaskRepository.setRepositoryLabel(Bundle.LBL_LocalTaskRepository_displayName());
        this.taskRepositoryManager.addRepository(this.localTaskRepository);
        this.taskList = new TaskList();
        this.repositoryModel = new RepositoryModel(this.taskList, (IRepositoryManager)this.taskRepositoryManager);
        this.synchronizationManager = new SynchronizationManger(this.repositoryModel);
        this.taskActivityManager = new TaskActivityManager(this.taskRepositoryManager, this.taskList);
        TaskDataStore taskDataStore = new TaskDataStore((IRepositoryManager)this.taskRepositoryManager);
        this.taskDataManager = new TaskDataManager(taskDataStore, (IRepositoryManager)this.taskRepositoryManager, this.taskList, this.taskActivityManager, this.synchronizationManager);
        String storagePath = Places.getUserDirectory().getAbsolutePath() + "/var/tasks/mylyn".replace("/", File.separator);
        this.taskListStorageFile = new File(storagePath, "tasks.xml.zip");
        this.taskDataManager.setDataPath(storagePath);
        this.taskListWriter = new TaskListExternalizer(this.repositoryModel, (IRepositoryManager)this.taskRepositoryManager);
        AccessorImpl.getInstance();
        this.saveTask = RP.create(new Runnable(){

            @Override
            public void run() {
                try {
                    MylynSupport.this.persist(false);
                }
                catch (CoreException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
            }
        });
        this.unsubmittedTaskContainers = new WeakHashMap<TaskRepository, UnsubmittedTasksContainer>();
        this.taskDataListeners = new CopyOnWriteArrayList<TaskDataListener>();
        this.taskListeners = new WeakHashMap<ITask, List<TaskListener>>();
        this.attachListeners();
    }

    public Collection<NbTask> getTasks(TaskRepository taskRepository) throws CoreException {
        this.ensureTaskListLoaded();
        assert (this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
        return this.toNbTasks(this.taskList.getTasks(taskRepository.getUrl()), !"local".equals(taskRepository.getConnectorKind()));
    }

    public Collection<NbTask> getTasks(IRepositoryQuery query) throws CoreException {
        assert (query instanceof RepositoryQuery);
        if (query instanceof RepositoryQuery) {
            this.ensureTaskListLoaded();
            assert (this.taskRepositoryManager.getRepositoryConnector(query.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
            return this.toNbTasks(((RepositoryQuery)query).getChildren());
        }
        return Collections.emptyList();
    }

    public NbTask getTask(String repositoryUrl, String taskKeyOrId) throws CoreException {
        this.ensureTaskListLoaded();
        AbstractTask task = this.taskList.getTaskByKey(repositoryUrl, taskKeyOrId);
        if (task == null) {
            task = this.taskList.getTask(repositoryUrl, taskKeyOrId);
        }
        return this.toNbTask((ITask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnsubmittedTasksContainer getUnsubmittedTasksContainer(TaskRepository taskRepository) throws CoreException {
        UnsubmittedTasksContainer cont;
        Map<TaskRepository, UnsubmittedTasksContainer> map = this.unsubmittedTaskContainers;
        synchronized (map) {
            cont = this.unsubmittedTaskContainers.get(taskRepository);
            if (cont == null) {
                this.ensureTaskListLoaded();
                assert (this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
                cont = new UnsubmittedTasksContainer(taskRepository, this.taskList);
                this.unsubmittedTaskContainers.put(taskRepository, cont);
            }
        }
        return cont;
    }

    public TaskRepository getLocalTaskRepository() {
        return this.localTaskRepository;
    }

    public void save() throws CoreException {
        this.persist(false);
    }

    public void addTaskDataListener(TaskDataListener listener) {
        this.taskDataListeners.add(listener);
    }

    public void removeTaskDataListener(TaskDataListener listener) {
        this.taskDataListeners.remove(listener);
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.taskRepositoryManager.addListener(listener);
    }

    static synchronized void reset() {
        instance = null;
    }

    NbTaskDataState getTaskDataState(NbTask task) throws CoreException {
        TaskDataState taskDataState = this.taskDataManager.getTaskDataState(task.getDelegate());
        if (taskDataState == null) {
            return null;
        }
        if (taskDataState.getLastReadData() == null) {
            taskDataState.setLastReadData(taskDataState.getRepositoryData());
        }
        return new NbTaskDataState((ITaskDataWorkingCopy)taskDataState);
    }

    public Set<TaskAttribute> countDiff(TaskData newTaskData, TaskData oldTaskData) {
        LinkedHashSet<TaskAttribute> attributes = new LinkedHashSet<TaskAttribute>();
        TaskDataDiff diff = new TaskDataDiff(this.repositoryModel, newTaskData, oldTaskData);
        for (ITaskAttributeDiff diffAttr : diff.getChangedAttributes()) {
            attributes.add(newTaskData.getRoot().getAttribute(diffAttr.getAttributeId()));
        }
        return attributes;
    }

    public Set<IRepositoryQuery> getRepositoryQueries(TaskRepository taskRepository) throws CoreException {
        this.ensureTaskListLoaded();
        assert (this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
        return new HashSet<IRepositoryQuery>(this.taskList.getRepositoryQueries(taskRepository.getUrl()));
    }

    public void addQuery(TaskRepository taskRepository, IRepositoryQuery query) throws CoreException {
        if (!(query instanceof RepositoryQuery)) {
            throw new IllegalArgumentException("Query must be instance of RepositoryQuery: " + query);
        }
        this.ensureTaskListLoaded();
        assert (this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
        this.taskList.addQuery((RepositoryQuery)query);
    }

    void discardLocalEdits(ITask task) throws CoreException {
        this.taskDataManager.discardEdits(task);
    }

    public IRepositoryQuery getRepositoryQuery(TaskRepository taskRepository, String queryName) throws CoreException {
        for (IRepositoryQuery q : this.getRepositoryQueries(taskRepository)) {
            if (!queryName.equals(q.getSummary())) continue;
            return q;
        }
        return null;
    }

    void deleteTask(ITask task) {
        assert (this.taskListInitialized);
        this.taskList.deleteTask(task);
        this.tasks.remove(task);
    }

    public void deleteQuery(IRepositoryQuery query) {
        assert (this.taskListInitialized);
        if (query instanceof RepositoryQuery) {
            this.taskList.deleteQuery((RepositoryQuery)query);
        }
    }

    public NbTask createTask(TaskRepository taskRepository, ITaskMapping initializingData) throws CoreException {
        this.ensureTaskListLoaded();
        AbstractTask task = this.createNewTask(taskRepository);
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        LocalTaskDataHandler taskDataHandler = taskRepository == this.localTaskRepository ? new LocalTaskDataHandler(taskRepository) : repositoryConnector.getTaskDataHandler();
        TaskAttributeMapper attributeMapper = taskDataHandler.getAttributeMapper(taskRepository);
        TaskData taskData = new TaskData(attributeMapper, repositoryConnector.getConnectorKind(), taskRepository.getRepositoryUrl(), "");
        taskDataHandler.initializeTaskData(taskRepository, taskData, initializingData, (IProgressMonitor)new NullProgressMonitor());
        this.initializeTask(repositoryConnector, taskData, task, taskRepository);
        return MylynSupport.getInstance().toNbTask((ITask)task);
    }

    public NbTask createSubtask(NbTask parentTask) throws CoreException {
        this.ensureTaskListLoaded();
        TaskRepository taskRepository = this.taskRepositoryManager.getRepository(parentTask.getDelegate().getRepositoryUrl());
        if (taskRepository == null || parentTask.isUnsubmittedRepositoryTask()) {
            throw new IllegalStateException("Task repository: " + parentTask.getDelegate().getRepositoryUrl() + " - parent: " + parentTask.isUnsubmittedRepositoryTask());
        }
        AbstractTask task = this.createNewTask(taskRepository);
        AbstractRepositoryConnector repositoryConnector = this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind());
        AbstractTaskDataHandler taskDataHandler = repositoryConnector.getTaskDataHandler();
        TaskAttributeMapper attributeMapper = repositoryConnector.getTaskDataHandler().getAttributeMapper(taskRepository);
        TaskData taskData = new TaskData(attributeMapper, repositoryConnector.getConnectorKind(), taskRepository.getRepositoryUrl(), "");
        taskDataHandler.initializeSubTaskData(taskRepository, taskData, parentTask.getTaskDataState().getRepositoryData(), (IProgressMonitor)new NullProgressMonitor());
        this.initializeTask(repositoryConnector, taskData, task, taskRepository);
        return MylynSupport.getInstance().toNbTask((ITask)task);
    }

    private void initializeTask(AbstractRepositoryConnector repositoryConnector, TaskData taskData, AbstractTask task, TaskRepository taskRepository) throws CoreException {
        ITaskMapping mapping = repositoryConnector.getTaskMapping(taskData);
        String taskKind = mapping.getTaskKind();
        if (taskKind != null && taskKind.length() > 0) {
            task.setTaskKind(taskKind);
        }
        ITaskDataWorkingCopy workingCopy = this.taskDataManager.createWorkingCopy((ITask)task, taskData);
        workingCopy.save(null, null);
        repositoryConnector.updateNewTaskFromTaskData(taskRepository, (ITask)task, taskData);
        String summary = mapping.getSummary();
        if (summary != null && summary.length() > 0) {
            task.setSummary(summary);
        }
        if (taskRepository == this.localTaskRepository) {
            this.taskList.addTask((ITask)task);
        } else {
            this.taskList.addTask((ITask)task, (AbstractTaskContainer)this.taskList.getUnsubmittedContainer(task.getAttribute("outgoingNewRepositoryUrl")));
        }
        task.setAttribute("NetBeans.task.markedNewUnread", Boolean.TRUE.toString());
    }

    private AbstractTask createNewTask(TaskRepository taskRepository) {
        LocalTask task = new LocalTask(String.valueOf(this.taskList.getNextLocalTaskId()), Bundle.MSG_NewTaskSummary());
        if (taskRepository != this.localTaskRepository) {
            task.setSynchronizationState(ITask.SynchronizationState.OUTGOING_NEW);
            task.setAttribute("outgoingNewConnectorKind", taskRepository.getConnectorKind());
            task.setAttribute("outgoingNewRepositoryUrl", taskRepository.getUrl());
        }
        return task;
    }

    public IRepositoryQuery createNewQuery(TaskRepository taskRepository, String queryName) throws CoreException {
        this.ensureTaskListLoaded();
        assert (this.taskRepositoryManager.getRepositoryConnector(taskRepository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
        IRepositoryQuery query = this.repositoryModel.createRepositoryQuery(taskRepository);
        assert (query instanceof RepositoryQuery);
        query.setSummary(queryName);
        return query;
    }

    public CommandFactory getCommandFactory() throws CoreException {
        if (this.factory == null) {
            this.ensureTaskListLoaded();
            this.factory = CommandsAccessor.INSTANCE.getCommandFactory(this.taskList, this.taskDataManager, this.taskRepositoryManager, this.repositoryModel);
        }
        return this.factory;
    }

    void markTaskSeen(final ITask task, boolean seen) {
        ITask.SynchronizationState syncState = task.getSynchronizationState();
        this.taskDataManager.setTaskRead(task, seen);
        if (!seen && syncState == task.getSynchronizationState() && syncState == ITask.SynchronizationState.OUTGOING && task instanceof AbstractTask) {
            try {
                this.taskList.run(new ITaskListRunnable(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        ((AbstractTask)task).setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                    }
                });
                this.taskList.notifyElementChanged((IRepositoryElement)task);
            }
            catch (CoreException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        task.setAttribute(ATTR_TASK_INCOMING_NEW, null);
    }

    public TaskRepository getTaskRepository(AbstractRepositoryConnector repositoryConnector, String repositoryUrl) {
        this.taskRepositoryManager.addRepositoryConnector(repositoryConnector);
        TaskRepository repository = this.taskRepositoryManager.getRepository(repositoryConnector.getConnectorKind(), repositoryUrl);
        if (repository == null) {
            repository = new TaskRepository(repositoryConnector.getConnectorKind(), repositoryUrl);
            this.addTaskRepository(repositoryConnector, repository);
        }
        return repository;
    }

    public void setRepositoryUrl(TaskRepository repository, String url) throws CoreException {
        String oldUrl = repository.getRepositoryUrl();
        if (!url.equals(oldUrl)) {
            this.ensureTaskListLoaded();
            assert (this.taskRepositoryManager.getRepositoryConnector(repository.getConnectorKind()) != null) : "Did you forget to implement RepositoryConnectorProvider?";
            try {
                for (ITask task : this.taskList.getAllTasks()) {
                    if (url.equals(task.getAttribute("outgoingNewRepositoryUrl"))) {
                        this.taskDataManager.refactorRepositoryUrl(task, task.getRepositoryUrl(), url);
                        continue;
                    }
                    if (!oldUrl.equals(task.getRepositoryUrl())) continue;
                    this.taskDataManager.refactorRepositoryUrl(task, url, url);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, null, t);
            }
            this.taskList.refactorRepositoryUrl(oldUrl, url);
            repository.setRepositoryUrl(url);
            this.taskRepositoryManager.notifyRepositoryUrlChanged(repository, oldUrl);
        }
    }

    NbTask getOrCreateTask(TaskRepository taskRepository, String taskId, boolean addToTaskList) throws CoreException {
        this.ensureTaskListLoaded();
        ITask task = this.taskList.getTask(taskRepository.getUrl(), taskId);
        if (task == null) {
            task = this.repositoryModel.createTask(taskRepository, taskId);
            ((AbstractTask)task).setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
            if (addToTaskList) {
                this.taskList.addTask(task);
            }
        }
        return this.toNbTask(task);
    }

    TaskRepository getTaskRepositoryFor(ITask task) {
        if (this.isUnsubmittedRepositoryTask(task)) {
            return this.taskRepositoryManager.getRepository(task.getAttribute("outgoingNewConnectorKind"), task.getAttribute("outgoingNewRepositoryUrl"));
        }
        return this.taskRepositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() throws CoreException {
        this.taskList.removeChangeListener(this.taskListListener);
        TaskList taskList = this.taskList;
        synchronized (taskList) {
            this.dirty = true;
        }
        this.persist(true);
    }

    private void addTaskRepository(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository) {
        if (!taskRepository.getConnectorKind().equals(repositoryConnector.getConnectorKind())) {
            throw new IllegalArgumentException("The given task repository is not managed by the given repository connector");
        }
        this.taskRepositoryManager.addRepositoryConnector(repositoryConnector);
        this.taskRepositoryManager.addRepository(taskRepository);
        assert (taskRepository == this.taskRepositoryManager.getRepository(repositoryConnector.getConnectorKind(), taskRepository.getUrl()));
    }

    private synchronized void ensureTaskListLoaded() throws CoreException {
        if (!this.taskListInitialized) {
            if (this.result == null) {
                LookupListener lookupListener = new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        MylynSupport.this.registerConnectors();
                    }
                };
                this.result = Lookup.getDefault().lookupResult(RepositoryConnectorProvider.class);
                this.result.addLookupListener(lookupListener);
            }
            this.registerConnectors();
            try {
                if (this.taskListStorageFile.length() > 0L) {
                    this.taskListWriter.readTaskList((ITransferList)this.taskList, this.taskListStorageFile);
                }
            }
            catch (CoreException ex) {
                LOG.log(Level.INFO, null, ex);
                throw new CoreException((IStatus)new Status(ex.getStatus().getSeverity(), ex.getStatus().getPlugin(), "Cannot deserialize tasklist"));
            }
            finally {
                this.taskListInitialized = true;
            }
        }
    }

    void persist(final boolean removeUnseenOrphanedTasks) throws CoreException {
        if (this.taskListInitialized) {
            this.taskList.run(new ITaskListRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(IProgressMonitor monitor) throws CoreException {
                    boolean save;
                    TaskList taskList = MylynSupport.this.taskList;
                    synchronized (taskList) {
                        save = MylynSupport.this.dirty;
                        MylynSupport.this.dirty = false;
                    }
                    if (!save) {
                        return;
                    }
                    try {
                        if (removeUnseenOrphanedTasks) {
                            LinkedHashSet<ITask> orphanedUnseenTasks = new LinkedHashSet<ITask>();
                            for (UnmatchedTaskContainer cont : MylynSupport.this.taskList.getUnmatchedContainers()) {
                                for (ITask task : cont.getChildren()) {
                                    if (task.getSynchronizationState() != ITask.SynchronizationState.INCOMING_NEW && !Boolean.TRUE.toString().equals(task.getAttribute(MylynSupport.ATTR_TASK_INCOMING_NEW))) continue;
                                    orphanedUnseenTasks.add(task);
                                }
                            }
                            for (ITask taskToDelete : orphanedUnseenTasks) {
                                MylynSupport.this.deleteTask(taskToDelete);
                            }
                        }
                        MylynSupport.this.taskListStorageFile.getParentFile().mkdirs();
                        MylynSupport.this.backupTaskList(MylynSupport.this.taskListStorageFile);
                        MylynSupport.this.taskListWriter.writeTaskList((ITransferList)MylynSupport.this.taskList, MylynSupport.this.taskListStorageFile);
                    }
                    catch (CoreException ex) {
                        LOG.log(Level.INFO, null, ex);
                        throw new CoreException((IStatus)new Status(ex.getStatus().getSeverity(), ex.getStatus().getPlugin(), "Cannot persist tasklist"));
                    }
                }
            });
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MylynSupport.class);
    }

    private void attachListeners() {
        this.taskRepositoryManagerListener = new IRepositoryListener(){

            public void repositoryAdded(TaskRepository repository) {
                MylynSupport.this.getRepositoryCreationTime(repository.getRepositoryUrl());
            }

            public void repositoryRemoved(TaskRepository repository) {
                MylynSupport.this.setRepositoryCreationTime(repository.getRepositoryUrl(), -1L);
            }

            public void repositorySettingsChanged(TaskRepository repository) {
            }

            public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
                MylynSupport.this.setRepositoryCreationTime(repository.getRepositoryUrl(), MylynSupport.this.getRepositoryCreationTime(oldUrl));
                MylynSupport.this.setRepositoryCreationTime(oldUrl, -1L);
            }
        };
        this.taskRepositoryManager.addListener(this.taskRepositoryManagerListener);
        this.taskListListener = new ITaskListChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void containersChanged(Set<TaskContainerDelta> deltas) {
                for (TaskContainerDelta delta : deltas) {
                    TaskRepository repository;
                    if (MylynSupport.this.taskListInitialized && !delta.isTransient()) {
                        TaskList taskList = MylynSupport.this.taskList;
                        synchronized (taskList) {
                            MylynSupport.this.dirty = true;
                        }
                        MylynSupport.this.scheduleSave();
                    }
                    if (!(delta.getElement() instanceof ITask)) continue;
                    ITask task = (ITask)delta.getElement();
                    if ((task.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW || task.getSynchronizationState() == ITask.SynchronizationState.INCOMING) && task.getCreationDate() != null && task.getModificationDate() != null && (repository = MylynSupport.this.taskRepositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl())) != null) {
                        long time = MylynSupport.this.getRepositoryCreationTime(repository.getRepositoryUrl());
                        if (task.getModificationDate().getTime() < time) {
                            MylynSupport.this.markTaskSeen(task, true);
                            task.setAttribute(MylynSupport.ATTR_TASK_INCOMING_NEW, Boolean.TRUE.toString());
                        }
                    }
                    this.notifyListeners(task, delta);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notifyListeners(ITask task, TaskContainerDelta delta) {
                List lists;
                TaskListener[] taskListenerArray = MylynSupport.this.taskListeners;
                synchronized (taskListenerArray) {
                    lists = (List)MylynSupport.this.taskListeners.get(task);
                }
                if (lists != null) {
                    for (TaskListener list : lists.toArray(new TaskListener[0])) {
                        list.taskModified(task, delta);
                    }
                }
            }
        };
        this.taskList.addChangeListener(this.taskListListener);
        this.taskDataManagerListener = new ITaskDataManagerListener(){

            public void taskDataUpdated(TaskDataManagerEvent event) {
                TaskDataListener.TaskDataEvent e = new TaskDataListener.TaskDataEvent(event);
                for (TaskDataListener l : MylynSupport.this.taskDataListeners.toArray(new TaskDataListener[0])) {
                    l.taskDataUpdated(e);
                }
            }

            public void editsDiscarded(TaskDataManagerEvent event) {
                this.taskDataUpdated(event);
            }
        };
        this.taskDataManager.addListener(this.taskDataManagerListener);
    }

    private void setRepositoryCreationTime(String repositoryUrl, long time) {
        if (time == -1L) {
            this.getPreferences().remove(PROP_REPOSITORY_CREATION_TIME + repositoryUrl);
        } else {
            this.getPreferences().putLong(PROP_REPOSITORY_CREATION_TIME + repositoryUrl, time);
        }
    }

    private long getRepositoryCreationTime(String repositoryUrl) {
        long time = this.getPreferences().getLong(PROP_REPOSITORY_CREATION_TIME + repositoryUrl, -1L);
        if (time == -1L) {
            time = System.currentTimeMillis();
            this.setRepositoryCreationTime(repositoryUrl, time);
        }
        return time;
    }

    private void scheduleSave() {
        this.saveTask.schedule(5000);
    }

    private void backupTaskList(File taskListStorageFile) {
        if (taskListStorageFile.canWrite()) {
            File backup = new File(taskListStorageFile.getParentFile(), taskListStorageFile.getName() + BACKUP_SUFFIX);
            backup.delete();
            taskListStorageFile.renameTo(backup);
        }
    }

    Collection<NbTask> toNbTasks(Collection<ITask> tasks) {
        return this.toNbTasks(tasks, true);
    }

    Collection<NbTask> toNbTasks(Collection<ITask> tasks, boolean includeUnsubmittedNewTasks) {
        LinkedHashSet<NbTask> nbTasks = new LinkedHashSet<NbTask>(tasks.size());
        for (ITask task : tasks) {
            if (!includeUnsubmittedNewTasks && task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) continue;
            nbTasks.add(this.toNbTask(task));
        }
        return Collections.unmodifiableSet(nbTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NbTask toNbTask(ITask task) {
        NbTask nbTask = null;
        if (task != null) {
            Map<ITask, Reference<NbTask>> map = this.tasks;
            synchronized (map) {
                Reference<NbTask> nbTaskRef = this.tasks.get(task);
                if (nbTaskRef != null) {
                    nbTask = nbTaskRef.get();
                }
                if (nbTask == null) {
                    nbTask = new NbTask(task);
                    this.tasks.put(task, new SoftReference<NbTask>(nbTask));
                }
            }
        }
        return nbTask;
    }

    static Set<ITask> toMylynTasks(Set<NbTask> tasks) {
        LinkedHashSet<ITask> mylynTasks = new LinkedHashSet<ITask>(tasks.size());
        for (NbTask task : tasks) {
            mylynTasks.add(task.getDelegate());
        }
        return mylynTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTaskListener(ITask task, TaskListener listener) {
        List<TaskListener> list;
        Map<ITask, List<TaskListener>> map = this.taskListeners;
        synchronized (map) {
            list = this.taskListeners.get(task);
            if (list == null) {
                list = new CopyOnWriteArrayList<TaskListener>();
                this.taskListeners.put(task, list);
            }
        }
        list.add(listener);
        assert (!this.taskPerList.containsKey(listener)) : "One task per one listener";
        this.taskPerList.put(listener, task);
    }

    void removeTaskListener(TaskListener listener) {
        ITask task = this.taskPerList.get(listener);
        if (task != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTaskListener(ITask task, TaskListener listener) {
        Map<ITask, List<TaskListener>> map = this.taskListeners;
        synchronized (map) {
            List<TaskListener> list = this.taskListeners.get(task);
            if (list != null) {
                list.remove(listener);
            }
        }
        this.taskPerList.remove(listener);
    }

    NbTaskDataModel getTaskDataModel(NbTask task) {
        assert (this.taskListInitialized);
        ITask mylynTask = task.getDelegate();
        mylynTask.setAttribute(ATTR_TASK_INCOMING_NEW, null);
        TaskRepository taskRepository = this.getTaskRepositoryFor(mylynTask);
        try {
            ITaskDataWorkingCopy workingCopy = this.taskDataManager.getWorkingCopy(mylynTask);
            if (workingCopy instanceof TaskDataState && workingCopy.getLastReadData() == null) {
                ((TaskDataState)workingCopy).setLastReadData(workingCopy.getRepositoryData());
            }
            return new NbTaskDataModel(taskRepository, task, workingCopy);
        }
        catch (CoreException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    private void registerConnectors() {
        for (RepositoryConnectorProvider provider : this.result.allInstances()) {
            AbstractRepositoryConnector connector = provider.getConnector();
            if (connector == null) continue;
            this.taskRepositoryManager.addRepositoryConnector(connector);
        }
    }

    void editorOpened(final ITask task) throws CoreException {
        if (task instanceof AbstractTask) {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setMarkReadPending(false);
                }
            }, null, true);
        }
    }

    void editorClosing(final ITask task, final TaskData td) throws CoreException {
        if (task instanceof AbstractTask) {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setMarkReadPending(true);
                    MylynSupport.this.taskDataManager.putUpdatedTaskData(task, td, true);
                }
            }, null, true);
        }
    }

    boolean isUnsubmittedRepositoryTask(ITask task) {
        return task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW && task.getAttribute("outgoingNewConnectorKind") != null;
    }

    void taskModified(ITask task) {
        this.taskList.notifyElementChanged((IRepositoryElement)task);
    }

    public void notifyCredentialsChanged(TaskRepository repository) {
        this.taskRepositoryManager.notifyRepositorySettingsChanged(repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.CREDENTIALS));
    }

    static {
        LOG = Logger.getLogger(MylynSupport.class.getName());
        RP = new RequestProcessor("MylynSupport", 1, true);
    }
}

