/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class Windows8VectorTabControlIcon
extends VectorIcon {
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = Windows8VectorTabControlIcon.populateInstances();
    private final int buttonId;
    private final int buttonState;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> toMap, int buttonId, int buttonState) {
        toMap.put(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState), (Icon)((Object)new Windows8VectorTabControlIcon(buttonId, buttonState)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> buttonIDs = new LinkedHashMap<String, Integer>();
        buttonIDs.put("close", 1);
        buttonIDs.put("pin", 2);
        buttonIDs.put("restore_group", 11);
        buttonIDs.put("slide_group", 12);
        buttonIDs.put("scroll_left", 9);
        buttonIDs.put("scroll_right", 10);
        buttonIDs.put("drop_down", 8);
        buttonIDs.put("maximize", 3);
        buttonIDs.put("restore", 4);
        LinkedHashMap<String, Integer> buttonStates = new LinkedHashMap<String, Integer>();
        buttonStates.put("default", 0);
        buttonStates.put("pressed", 1);
        buttonStates.put("disabled", 2);
        buttonStates.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> ret = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry buttonID : buttonIDs.entrySet()) {
            for (Map.Entry buttonState : buttonStates.entrySet()) {
                Windows8VectorTabControlIcon.populateOne(ret, (Integer)buttonID.getValue(), (Integer)buttonState.getValue());
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    private Windows8VectorTabControlIcon(int buttonId, int buttonState) {
        super(14, 14);
        this.buttonId = buttonId;
        this.buttonState = buttonState;
    }

    public static Icon get(int buttonId, int buttonState) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(buttonId, buttonState));
    }

    protected void paintIcon(Component c, Graphics2D g, int width, int height, double scaling) {
        Color closeColor;
        Color bgColor = new Color(0, 0, 0, 0);
        Color fgColor = new Color(86, 86, 86, 255);
        Color color = closeColor = this.buttonId == 1 ? new Color(199, 79, 80, 255) : null;
        if (this.buttonState == 2) {
            fgColor = new Color(0, 0, 0, 45);
        } else if (this.buttonState == 1) {
            bgColor = closeColor != null ? closeColor : new Color(57, 100, 178, 255);
            fgColor = Color.WHITE;
        } else if (this.buttonState == 3) {
            bgColor = closeColor != null ? closeColor : new Color(0, 0, 0, 70);
            fgColor = Color.WHITE;
        }
        if (bgColor.getAlpha() > 0) {
            g.setColor(bgColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(fgColor);
        if (this.buttonId == 1) {
            if (this.getIconWidth() == width && this.getIconHeight() == height) {
                Windows8VectorTabControlIcon.setAntiAliasing((Graphics2D)g, (boolean)false);
            }
            double strokeWidth = (bgColor.getAlpha() > 0 ? 1.0 : 0.8) * scaling;
            if (scaling > 1.0) {
                strokeWidth *= 1.5;
            }
            double marginX = 3.5 * scaling;
            int topMarginY = Windows8VectorTabControlIcon.round((double)(3.0 * scaling));
            int botMarginY = Windows8VectorTabControlIcon.round((double)(4.0 * scaling));
            g.clip(new Rectangle2D.Double(0.0, topMarginY, width, height - topMarginY - botMarginY));
            g.setStroke(new BasicStroke((float)strokeWidth));
            g.draw(new Line2D.Double(marginX, topMarginY, (double)width - marginX, height - botMarginY));
            g.draw(new Line2D.Double((double)width - marginX, topMarginY, marginX, height - botMarginY));
        } else if (this.buttonId == 2 || this.buttonId == 11 || this.buttonId == 4) {
            int margin = Windows8VectorTabControlIcon.round((double)(2.0 * scaling));
            int winWidth = Windows8VectorTabControlIcon.round((double)(6.5 * scaling));
            int winHeight = Windows8VectorTabControlIcon.round((double)(5.5 * scaling));
            int win1X = width - margin - winWidth;
            int win1Y = margin;
            int win2X = margin;
            int win2Y = Windows8VectorTabControlIcon.round((double)(5.5 * scaling));
            Area win1 = Windows8VectorTabControlIcon.getWindowSymbol(scaling, win1X, win1Y, winWidth, winHeight);
            Area win2 = Windows8VectorTabControlIcon.getWindowSymbol(scaling, win2X, win2Y, winWidth, winHeight);
            win1.subtract(new Area(win2.getBounds2D()));
            g.fill(win1);
            g.fill(win2);
        } else if (this.buttonId == 3) {
            int marginX = Windows8VectorTabControlIcon.round((double)(2.2 * scaling));
            int marginY = Windows8VectorTabControlIcon.round((double)(3.0 * scaling));
            int windowHeight = Windows8VectorTabControlIcon.round((double)(7.5 * scaling));
            g.fill(Windows8VectorTabControlIcon.getWindowSymbol(scaling, marginX, marginY, width - 2 * marginX, windowHeight));
        } else if (this.buttonId == 12) {
            int marginX;
            int barX = marginX = Windows8VectorTabControlIcon.round((double)(2.0 * scaling));
            int barY = Windows8VectorTabControlIcon.round((double)(8.0 * scaling));
            int barWidth = width - marginX * 2;
            int barThickness = Windows8VectorTabControlIcon.round((double)(1.8 * scaling));
            g.fill(new Rectangle2D.Double(barX, barY, barWidth, barThickness));
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            if (this.getIconWidth() == width && this.getIconHeight() == height) {
                Windows8VectorTabControlIcon.setAntiAliasing((Graphics2D)g, (boolean)false);
            }
            if (this.buttonId == 9) {
                g.translate(-Windows8VectorTabControlIcon.round((double)(1.0 * scaling)), 0);
                g.rotate(1.5707963267948966, (double)width / 2.0, (double)height / 2.0);
            } else if (this.buttonId == 10) {
                g.translate(Windows8VectorTabControlIcon.round((double)(1.0 * scaling)), 0);
                g.rotate(-1.5707963267948966, (double)width / 2.0, (double)height / 2.0);
            }
            int y = Windows8VectorTabControlIcon.round((double)(4.0 * scaling));
            double arrowWidth = (scaling == 1.0 ? 12.0 : 10.0) * scaling;
            double arrowHeight = 5.0 * scaling;
            double marginX = ((double)width - arrowWidth) / 2.0;
            double arrowMidX = marginX + arrowWidth / 2.0;
            Path2D.Double arrowPath = new Path2D.Double();
            arrowPath.moveTo(arrowMidX - arrowWidth / 2.0, y);
            arrowPath.lineTo(arrowMidX, (double)y + arrowHeight);
            arrowPath.lineTo(arrowMidX + arrowWidth / 2.0, y);
            arrowPath.closePath();
            g.fill(arrowPath);
        }
    }

    private static Area getWindowSymbol(double scaling, int x, int y, int width, int height) {
        int borderThickness = Windows8VectorTabControlIcon.round((double)(0.8 * scaling));
        int titleBarHeight = Math.max(Windows8VectorTabControlIcon.round((double)(1.8 * scaling)), borderThickness + 1);
        Area ret = new Area(new Rectangle2D.Double(x, y, width, height));
        ret.subtract(new Area(new Rectangle2D.Double(x + borderThickness, y + titleBarHeight, width - borderThickness * 2, height - borderThickness - titleBarHeight)));
        return ret;
    }
}

