/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.util.LinkedHashMap;
import java.util.Map;

public class VendorNameMgr {
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ',', '=', ';'};
    private static final String ILLEGAL_CHARS_PATTERN = "[/\\:*\"<>|,=; \\.]";
    private static final String REPLACEMENT_PATTERN = "_";
    private static Map<String, String> vendorNameToDscnMap = new LinkedHashMap<String, String>();
    private static Map<String, String> vendorNameToUrlMap;

    public static String vendorNameFromDbUrl(String url) {
        String vendorName = VendorNameMgr.getDatabaseVendorName(url = VendorNameMgr.stripExtraDBInfo(url));
        if (vendorName != null) {
            if (vendorName.length() > 0) {
                if (!VendorNameMgr.isFriendlyFilename(vendorName)) {
                    vendorName = VendorNameMgr.makeLegalFilename(vendorName);
                }
            } else {
                vendorName = VendorNameMgr.makeShorterLegalFilename(url);
            }
        }
        return vendorName;
    }

    public static String dsClassNameFromVendorName(String vendorName) {
        return vendorName != null ? vendorNameToDscnMap.get(vendorName) : null;
    }

    private static boolean isLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isFriendlyFilename(String filename) {
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return VendorNameMgr.isLegalFilename(filename);
    }

    private static String makeLegalFilename(String filename) {
        return filename.replaceAll(ILLEGAL_CHARS_PATTERN, REPLACEMENT_PATTERN);
    }

    private static String makeShorterLegalFilename(String filename) {
        int separatorIndex = filename.indexOf("://");
        if (separatorIndex != -1) {
            filename = filename.substring(0, separatorIndex) + REPLACEMENT_PATTERN + filename.substring(separatorIndex + 3);
        }
        if ((separatorIndex = filename.indexOf("//")) != -1) {
            filename = filename.substring(0, separatorIndex) + REPLACEMENT_PATTERN + filename.substring(separatorIndex + 2);
        }
        filename = VendorNameMgr.makeLegalFilename(filename);
        return filename;
    }

    static String stripExtraDBInfo(String dbConnectionString) {
        int bracketIndex = dbConnectionString.indexOf("[");
        if (bracketIndex != -1) {
            dbConnectionString = dbConnectionString.substring(0, bracketIndex).trim();
        }
        return dbConnectionString;
    }

    private static String getDatabaseVendorName(String url) {
        String vendorName = "";
        for (Map.Entry<String, String> entry : vendorNameToUrlMap.entrySet()) {
            if (url.indexOf(entry.getValue()) == -1) continue;
            vendorName = entry.getKey();
            break;
        }
        return vendorName;
    }

    static {
        vendorNameToDscnMap.put("oracle-thin", "oracle.jdbc.pool.OracleDataSource");
        vendorNameToDscnMap.put("derby_net", "org.apache.derby.jdbc.ClientDataSource");
        vendorNameToDscnMap.put("sun_db2", "com.sun.sql.jdbcx.db2.DB2DataSource");
        vendorNameToDscnMap.put("sun_msftsql", "com.sun.sql.jdbcx.sqlserver.SQLServerDataSource");
        vendorNameToDscnMap.put("sun_oracle", "com.sun.sql.jdbcx.oracle.OracleDataSource");
        vendorNameToDscnMap.put("sun_sybase", "com.sun.sql.jdbcx.sybase.SybaseDataSource");
        vendorNameToDscnMap.put("post-gre-sql", "org.postgresql.ds.PGSimpleDataSource");
        vendorNameToDscnMap.put("microsoft_sql", "com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        vendorNameToDscnMap.put("jtds_sql", "net.sourceforge.jtds.jdbcx.JtdsDataSource");
        vendorNameToDscnMap.put("jtds_sybase", "net.sourceforge.jtds.jdbcx.JtdsDataSource");
        vendorNameToDscnMap.put("oracle", "oracle.jdbc.pool.OracleDataSource");
        vendorNameToDscnMap.put("db2", "com.ibm.db2.jcc.DB2DataSource");
        vendorNameToDscnMap.put("datadirect_sql", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource");
        vendorNameToDscnMap.put("datadirect_oracle", "com.ddtek.jdbcx.oracle.OracleDataSource");
        vendorNameToDscnMap.put("datadirect_db2", "com.ddtek.jdbcx.db2.DB2DataSource");
        vendorNameToDscnMap.put("datadirect_informix", "com.ddtek.jdbcx.informix.InformixDataSource");
        vendorNameToDscnMap.put("datadirect_sybase", "com.ddtek.jdbcx.sybase.SybaseDataSource");
        vendorNameToDscnMap.put("sybase2", "com.sybase.jdbc2.jdbc.SybDataSource");
        vendorNameToDscnMap.put("pointbase", "com.pointbase.jdbc.jdbcDataSource");
        vendorNameToDscnMap.put("cloudscape", "com.cloudscape.core.BasicDataSource");
        vendorNameToDscnMap.put("informix", "com.informix.jdbcx.IfxDataSource");
        vendorNameToDscnMap.put("mysql", "com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        vendorNameToDscnMap.put("jdbc-odbc-bridge", "sun.jdbc.odbc.JdbcOdbcDriver");
        vendorNameToDscnMap.put("sql-server", "weblogic.jdbc.mssqlserver4.Driver");
        vendorNameToUrlMap = new LinkedHashMap<String, String>();
        vendorNameToUrlMap.put("oracle-thin", "jdbc:oracle:thin");
        vendorNameToUrlMap.put("derby_net", "jdbc:derby://");
        vendorNameToUrlMap.put("derby_embedded", "jdbc:derby:");
        vendorNameToUrlMap.put("sun_db2", "jdbc:sun:db2:");
        vendorNameToUrlMap.put("sun_msftsql", "jdbc:sun:sqlserver:");
        vendorNameToUrlMap.put("sun_oracle", "jdbc:sun:oracle:");
        vendorNameToUrlMap.put("sun_sybase", "jdbc:sun:sybase:");
        vendorNameToUrlMap.put("post-gre-sql", "jdbc:postgresql:");
        vendorNameToUrlMap.put("microsoft_sql", "jdbc:sqlserver:");
        vendorNameToUrlMap.put("jtds_sql", "jdbc:jtds:sqlserver:");
        vendorNameToUrlMap.put("jtds_sybase", "jdbc:jtds:sybase:");
        vendorNameToUrlMap.put("oracle", "jdbc:oracle:oci8:");
        vendorNameToUrlMap.put("db2", "jdbc:db2:");
        vendorNameToUrlMap.put("jdbc-odbc-bridge", "jdbc:odbc:");
        vendorNameToUrlMap.put("sql-server", "jdbc:weblogic:mssqlserver4:");
        vendorNameToUrlMap.put("sybase2", "jdbc:sybase:Tds:");
        vendorNameToUrlMap.put("cloudscape", "jdbc:cloudscape:");
        vendorNameToUrlMap.put("informix", "jdbc:informix-sqli:");
        vendorNameToUrlMap.put("mysql", "jdbc:mysql:");
        vendorNameToUrlMap.put("pointbase", "jdbc:pointbase:");
        vendorNameToUrlMap.put("datadirect_sql", "jdbc:datadirect:sqlserver:");
        vendorNameToUrlMap.put("datadirect_oracle", "jdbc:datadirect:oracle:");
        vendorNameToUrlMap.put("datadirect_db2", "jdbc:datadirect:db2:");
        vendorNameToUrlMap.put("datadirect_informix", "jdbc:datadirect:informix:");
        vendorNameToUrlMap.put("datadirect_sybase", "jdbc:datadirect:sybase:");
        vendorNameToUrlMap.put("as400", "jdbc:as400:");
    }
}

