/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints.projects.support;

import java.io.File;
import java.net.URI;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.tools.storage.api.ToolPreferences;
import org.netbeans.spi.editor.hints.projects.ProjectSettings;
import org.netbeans.spi.editor.hints.projects.support.ProjectCustomizer;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public class StandardProjectSettings {
    public static final String ATTR_ENABLE_KEY = "enableKey";
    public static final String ATTR_HINT_FILE_KEY = "hintFileKey";
    public static final String ATTR_DEFAULT_HINT_FILE = "defaultHintFileKey";
    public static final String ATTR_CUSTOMIZERS_FOLDER = "customizersFolder";
    private static final String KEY_USE_PROJECT = "perProjectHintSettingsEnabled";
    private static final boolean DEF_USE_PROJECT = false;
    private static final String KEY_PROJECT_SETTINGS = "perProjectHintSettingsFile";
    private static final String DEF_PROJECT_SETTINGS = "nbproject/cfg_hints.xml";

    private static String getAttributeWithDefault(FileObject file, String key, String def) {
        Object value = file.getAttribute(key);
        if (value instanceof String) {
            return (String)value;
        }
        return def;
    }

    @NonNull
    public static LookupProvider createSettings(FileObject file) {
        String keyUseProject = StandardProjectSettings.getAttributeWithDefault(file, ATTR_ENABLE_KEY, KEY_USE_PROJECT);
        String keyHintSettingsFile = StandardProjectSettings.getAttributeWithDefault(file, ATTR_HINT_FILE_KEY, KEY_PROJECT_SETTINGS);
        String defaultHintLocation = StandardProjectSettings.getAttributeWithDefault(file, ATTR_DEFAULT_HINT_FILE, DEF_PROJECT_SETTINGS);
        return StandardProjectSettings.createSettings(keyUseProject, keyHintSettingsFile, defaultHintLocation);
    }

    @NonNull
    public static LookupProvider createSettings(final @NullAllowed String keyUseProject, final @NullAllowed String keyHintSettingsFile, final @NullAllowed String defaultHintLocation) {
        return new LookupProvider(){

            public Lookup createAdditionalLookup(Lookup baseContext) {
                Project project = (Project)baseContext.lookup(Project.class);
                assert (project != null);
                return Lookups.fixed((Object[])new Object[]{new Standard(project, keyUseProject != null ? keyUseProject : StandardProjectSettings.KEY_USE_PROJECT, keyHintSettingsFile != null ? keyHintSettingsFile : StandardProjectSettings.KEY_PROJECT_SETTINGS, defaultHintLocation != null ? defaultHintLocation : StandardProjectSettings.DEF_PROJECT_SETTINGS)});
            }
        };
    }

    @NonNull
    public static LookupProvider createPreferencesBasedSettings() {
        return new LookupProvider(){

            public Lookup createAdditionalLookup(Lookup baseContext) {
                Project project = (Project)baseContext.lookup(Project.class);
                assert (project != null);
                return Lookups.fixed((Object[])new Object[]{new Standard(project, StandardProjectSettings.KEY_USE_PROJECT, null, null)});
            }
        };
    }

    @NonNull
    public static ProjectCustomizer.CompositeCategoryProvider createCustomizerProvider(FileObject file) {
        String customizersFolder = StandardProjectSettings.getAttributeWithDefault(file, ATTR_CUSTOMIZERS_FOLDER, null);
        if (customizersFolder == null) {
            throw new IllegalStateException("Must specify customizersFolder");
        }
        return StandardProjectSettings.createCustomizerProvider(customizersFolder);
    }

    @NonNull
    public static ProjectCustomizer.CompositeCategoryProvider createCustomizerProvider(@NonNull String customizersFolder) {
        Parameters.notNull((CharSequence)ATTR_CUSTOMIZERS_FOLDER, (Object)customizersFolder);
        return new ProjectCustomizer(customizersFolder);
    }

    static final class Standard
    implements ProjectSettings {
        private final Project project;
        @NonNull
        private final String keyUseProject;
        @NullAllowed
        private final String keyHintSettingsFile;
        @NullAllowed
        private final String defaultHintLocation;

        public Standard(Project project, @NonNull String keyUseProject, @NullAllowed String keyHintSettingsFile, @NullAllowed String defaultHintLocation) {
            this.keyUseProject = keyUseProject;
            this.keyHintSettingsFile = keyHintSettingsFile;
            this.defaultHintLocation = defaultHintLocation;
            this.project = project;
        }

        @Override
        public boolean getUseProjectSettings() {
            return ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).getBoolean(this.keyUseProject, false);
        }

        public void setUseProjectSettings(boolean value) {
            if (value) {
                ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).putBoolean(this.keyUseProject, true);
            } else {
                ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).remove(this.keyUseProject);
            }
        }

        public String getSettingsFileLocation() {
            assert (this.hasLocation());
            String result = ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).get(this.keyHintSettingsFile, null);
            return result != null ? result : this.defaultHintLocation;
        }

        public void setSettingsFileLocation(String settings) {
            assert (this.hasLocation());
            ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).put(this.keyHintSettingsFile, settings);
        }

        private String encodeSettingsFileLocation(String fileLocation) {
            return fileLocation.replace(" ", "%20");
        }

        @Override
        public Preferences getProjectSettings(String mimeType) {
            if (this.hasLocation()) {
                URI settingsLocation = this.project.getProjectDirectory().toURI().resolve(this.encodeSettingsFileLocation(this.getSettingsFileLocation()));
                return ToolPreferences.from((URI)settingsLocation).getPreferences("hints", mimeType);
            }
            return ProjectUtils.getPreferences((Project)this.project, ProjectSettings.class, (boolean)true).node(mimeType);
        }

        public ToolPreferences preferencesFrom(String source) {
            assert (this.hasLocation());
            URI settingsLocation = this.project.getProjectDirectory().toURI().resolve(this.encodeSettingsFileLocation(this.getSettingsFileLocation()));
            return ToolPreferences.from((URI)settingsLocation);
        }

        public String getDefaultHintLocation() {
            return this.defaultHintLocation;
        }

        public File getProjectLocation() {
            return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }

        public boolean hasLocation() {
            return this.keyHintSettingsFile != null;
        }
    }
}

