/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.spi.StrataProvider;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;

public class TruffleStrataProvider
implements StrataProvider {
    public static final String TRUFFLE_STRATUM = "GraalVM_Script";
    private static final String TRUFFLE_ACCESS_CLASS = "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor";
    private static final String TRUFFLE_ACCESS_METHOD = "executionHalted";

    public String getDefaultStratum(CallStackFrameImpl csf) {
        if (this.isInTruffleAccessPoint(csf)) {
            return TRUFFLE_STRATUM;
        }
        return null;
    }

    public List<String> getAvailableStrata(CallStackFrameImpl csf) {
        if (this.isInTruffleAccessPoint(csf)) {
            return Collections.singletonList(TRUFFLE_STRATUM);
        }
        return null;
    }

    private boolean isInTruffleAccessPoint(CallStackFrameImpl csf) {
        return TRUFFLE_ACCESS_CLASS.equals(csf.getClassName()) && TRUFFLE_ACCESS_METHOD.equals(csf.getMethodName());
    }

    public int getStrataLineNumber(CallStackFrameImpl csf, String stratum) {
        CurrentPCInfo currentPCInfo;
        if (TRUFFLE_STRATUM.equals(stratum) && this.isInTruffleAccessPoint(csf) && (currentPCInfo = TruffleAccess.getCurrentPCInfo(csf.getThread())) != null) {
            return currentPCInfo.getSourcePosition().getStartLine();
        }
        return csf.getLineNumber(stratum);
    }
}

