/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class UIUtil {
    public static void updateColumnWidths(JTable table) {
        double pw = table.getParent().getSize().getWidth();
        table.setAutoResizeMode(0);
        TableColumn column = table.getColumnModel().getColumn(1);
        int w = (int)pw / 2 - 1;
        if (w > column.getMaxWidth()) {
            w = column.getMaxWidth();
        }
        column.setWidth(w);
        column.setPreferredWidth(w);
        w = (int)pw - w;
        column = table.getColumnModel().getColumn(0);
        column.setWidth(w);
        column.setPreferredWidth(w);
    }

    public static void initTwoColumnTableVisualProperties(Component component, JTable table) {
        table.setSelectionMode(2);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        UIUtil.updateColumnWidths(table);
        component.addComponentListener(new TableColumnSizeComponentAdapter(table));
    }

    private static class TableColumnSizeComponentAdapter
    extends ComponentAdapter {
        private JTable table = null;

        public TableColumnSizeComponentAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            UIUtil.updateColumnWidths(this.table);
        }
    }
}

