/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;

public class RangesAccumulator<T extends RangesBuffer> {
    private T acc;
    private T tmp;

    public RangesAccumulator(T acc) {
        this.acc = acc;
    }

    public T get() {
        return this.acc;
    }

    public T getTmp() {
        if (this.tmp == null) {
            this.tmp = this.acc.create();
        }
        return this.tmp;
    }

    public void addRange(int lo, int hi) {
        this.acc.addRange(lo, hi);
    }

    public void appendRange(int lo, int hi) {
        this.acc.appendRange(lo, hi);
    }

    public void addSet(SortedListOfRanges set) {
        T t = this.getTmp();
        this.tmp = this.acc;
        this.acc = t;
        SortedListOfRanges.union(this.tmp, set, this.acc);
    }

    public void clear() {
        this.acc.clear();
    }
}

