/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public class DeleteVisitor
extends DepthFirstTraversalRegexASTVisitor {
    private final RegexAST ast;

    public DeleteVisitor(RegexAST ast) {
        this.ast = ast;
    }

    @Override
    protected void visit(BackReference backReference) {
        this.ast.getNodeCount().dec();
    }

    @Override
    protected void visit(Group group) {
        this.ast.getNodeCount().dec();
        if (group.getParent() instanceof RegexASTSubtreeRootNode) {
            this.ast.getNodeCount().dec();
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        this.ast.getNodeCount().dec();
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        this.ast.getNodeCount().dec();
        switch (assertion.type) {
            case CARET: {
                this.ast.getReachableCarets().remove(assertion);
                break;
            }
            case DOLLAR: {
                this.ast.getReachableDollars().remove(assertion);
            }
        }
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        this.ast.getNodeCount().dec();
        this.ast.getLookBehinds().remove(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        this.ast.getNodeCount().dec();
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        this.ast.getNodeCount().dec();
    }

    @Override
    protected void visit(MatchFound matchFound) {
        throw new IllegalStateException();
    }
}

