/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.SIMDType;

public final class SIMDCastNode
extends JavaScriptBaseNode {
    private final SIMDType simdContext;
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private JSToInt32Node toInt32Node;
    private final ConditionProfile p1 = ConditionProfile.createBinaryProfile();
    private final ConditionProfile p2 = ConditionProfile.createBinaryProfile();

    private SIMDCastNode(SIMDType simdContext) {
        this.simdContext = simdContext;
    }

    public static SIMDCastNode create(SIMDType simdContext) {
        return new SIMDCastNode(simdContext);
    }

    public Object execute(Object o) {
        Number n = o instanceof Number ? (Number)((Number)o) : (Number)this.getToNumberNode().executeNumber(o);
        return this.executeNumber(n);
    }

    private Object executeNumber(Number o) {
        if (this.simdContext.getFactory() == SIMDType.INT32X4_FACTORY) {
            if (this.p1.profile(o instanceof Float)) {
                return this.getToInt32Node().executeInt(((Float)o).floatValue());
            }
            return this.getToInt32Node().executeInt(o);
        }
        if (this.simdContext.getFactory() == SIMDType.INT16X8_FACTORY) {
            if (this.p1.profile(o instanceof Short)) {
                return (int)((Short)o).shortValue();
            }
            if (this.p2.profile(o instanceof Float)) {
                return JSRuntime.toInt16(((Float)o).floatValue());
            }
            return JSRuntime.toInt16(o);
        }
        if (this.simdContext.getFactory() == SIMDType.INT8X16_FACTORY) {
            if (this.p1.profile(o instanceof Byte)) {
                return (int)((Byte)o).byteValue();
            }
            if (this.p2.profile(o instanceof Float)) {
                return JSRuntime.toInt8(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toInt8(o);
        }
        if (this.simdContext.getFactory() == SIMDType.UINT32X4_FACTORY) {
            if (this.p1.profile(o instanceof Float)) {
                return (int)JSRuntime.toUInt32(((Float)o).floatValue());
            }
            return (int)JSRuntime.toUInt32(o);
        }
        if (this.simdContext.getFactory() == SIMDType.UINT16X8_FACTORY) {
            if (this.p1.profile(o instanceof Short)) {
                return (int)((Short)o).shortValue();
            }
            if (this.p2.profile(o instanceof Float)) {
                return JSRuntime.toUInt16(((Float)o).floatValue());
            }
            return JSRuntime.toUInt16(o);
        }
        if (this.simdContext.getFactory() == SIMDType.UINT8X16_FACTORY) {
            if (this.p1.profile(o instanceof Byte)) {
                return (int)((Byte)o).byteValue();
            }
            if (this.p2.profile(o instanceof Float)) {
                return JSRuntime.toUInt8(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toUInt8(o);
        }
        if (this.simdContext.getFactory() == SIMDType.FLOAT32X4_FACTORY) {
            if (this.p1.profile(o instanceof Float)) {
                return o;
            }
            if (this.p2.profile(o instanceof Double)) {
                return Float.valueOf((float)((Double)o).doubleValue());
            }
            return Float.valueOf(JSRuntime.floatValueVirtual(o));
        }
        if (this.simdContext.getFactory() == SIMDType.BOOL32X4_FACTORY || this.simdContext.getFactory() == SIMDType.BOOL16X8_FACTORY || this.simdContext.getFactory() == SIMDType.BOOL8X16_FACTORY) {
            return JSRuntime.toBoolean(o);
        }
        return this.simdContext.cast(o);
    }

    private JSToInt32Node getToInt32Node() {
        if (this.toInt32Node == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toInt32Node = (JSToInt32Node)this.insert(JSToInt32Node.create());
        }
        return this.toInt32Node;
    }

    protected JSToNumberNode getToNumberNode() {
        if (this.toNumberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
        }
        return this.toNumberNode;
    }
}

