/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSAddConstantRightNumberNodeGen;
import com.oracle.truffle.js.nodes.binary.JSAddNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import java.util.Objects;
import java.util.Set;

@NodeInfo(shortName="+")
public abstract class JSAddConstantRightNumberNode
extends JSUnaryNode
implements Truncatable {
    @CompilerDirectives.CompilationFinal
    boolean truncate;
    private final double rightDouble;
    private final int rightInt;
    protected final boolean isInt;

    protected JSAddConstantRightNumberNode(JavaScriptNode left, Number rightValue, boolean truncate) {
        super(left);
        this.truncate = truncate;
        this.rightDouble = rightValue.doubleValue();
        if (rightValue instanceof Integer || JSRuntime.doubleIsRepresentableAsInt(this.rightDouble)) {
            this.isInt = true;
            this.rightInt = rightValue.intValue();
        } else {
            this.isInt = false;
            this.rightInt = 0;
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", this.getClass().getAnnotation(NodeInfo.class).shortName());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = this.isInt ? JSConstantNode.JSConstantIntegerNode.create(this.rightInt) : JSConstantNode.JSConstantDoubleNode.create(this.rightDouble);
            JavaScriptNode node = JSAddNode.createUnoptimized(this.getOperand(), constantNode, this.truncate);
            JSAddConstantRightNumberNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSAddConstantRightNumberNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract Object execute(Object var1);

    public Number getRightValue() {
        return this.isInt ? (double)this.rightInt : this.rightDouble;
    }

    @Specialization(guards={"truncate", "isInt"})
    protected int doIntTruncate(int left) {
        return left + this.rightInt;
    }

    @Specialization(guards={"!truncate", "isInt"}, rewriteOn={ArithmeticException.class})
    protected int doInt(int left) {
        return Math.addExact(left, this.rightInt);
    }

    @Specialization(guards={"!truncate", "isInt"}, rewriteOn={ArithmeticException.class})
    protected Object doIntOverflow(int left) {
        long result = (long)left + (long)this.rightInt;
        return JSAddNode.doIntOverflowStaticLong(result);
    }

    @Specialization
    protected double doDouble(double left) {
        return left + this.rightDouble;
    }

    @Specialization
    protected CharSequence doStringNumber(CharSequence a, @Cached(value="rightValueToString()") String rightString, @Cached(value="create()") JSConcatStringsNode createLazyString) {
        return createLazyString.executeCharSequence(a, rightString);
    }

    @Specialization(replaces={"doInt", "doDouble", "doStringNumber"})
    protected Object doPrimitiveConversion(Object a, @Cached(value="createHintNone()") JSToPrimitiveNode toPrimitiveA, @Cached(value="create()") JSToNumberNode toNumberA, @Cached(value="rightValueToString()") String rightString, @Cached(value="create()") JSConcatStringsNode createLazyString, @Cached(value="createBinaryProfile()") ConditionProfile profileA) {
        Object primitiveA = toPrimitiveA.execute(a);
        if (profileA.profile(JSGuards.isString(primitiveA))) {
            return createLazyString.executeCharSequence((CharSequence)primitiveA, rightString);
        }
        return JSRuntime.doubleValue(toNumberA.executeNumber(primitiveA)) + this.rightDouble;
    }

    protected String rightValueToString() {
        return JSRuntime.toString(this.getRightValue());
    }

    @Override
    public void setTruncate() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.truncate) {
            this.truncate = true;
            if (this.isInt) {
                Truncatable.truncate(this.getOperand());
            }
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSAddConstantRightNumberNodeGen.create(JSAddConstantRightNumberNode.cloneUninitialized(this.getOperand()), this.getRightValue(), this.truncate);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " + " + JSRuntime.numberToString(this.getRightValue()) + ")";
        }
        return null;
    }
}

