/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSNotNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;
import java.util.concurrent.locks.Lock;

@NodeInfo(shortName="if")
public final class IfNode
extends StatementNode
implements ResumableNode {
    @Node.Child
    private JavaScriptNode condition;
    @Node.Child
    private JavaScriptNode thenPart;
    @Node.Child
    private JavaScriptNode elsePart;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public static IfNode create(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        if (condition instanceof JSNotNode) {
            JavaScriptNode operand = ((JSNotNode)condition).getOperand();
            IfNode.transferSourceSectionAddExpressionTag(condition, operand);
            return new IfNode(operand, elsePart, thenPart);
        }
        return new IfNode(condition, thenPart, elsePart);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.Conditional.name());
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (IfNode.hasMaterializationTag(materializedTags) && this.materializationNeeded()) {
            JavaScriptNode newCondition = JSTaggedExecutionNode.createForInput(this.condition, JSTags.ControlFlowBranchTag.class, JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowBranchTag.Type.Condition.name()));
            JavaScriptNode newThenPart = this.thenPart != null ? JSTaggedExecutionNode.createForInput(this.thenPart, JSTags.ControlFlowBlockTag.class) : null;
            JavaScriptNode newElsePart = this.elsePart != null ? JSTaggedExecutionNode.createForInput(this.elsePart, JSTags.ControlFlowBlockTag.class) : null;
            IfNode newIf = IfNode.create(newCondition, newThenPart, newElsePart);
            IfNode.transferSourceSectionAndTags(this, newIf);
            return newIf;
        }
        return this;
    }

    private boolean materializationNeeded() {
        return !(this.condition instanceof JSTaggedExecutionNode) || this.elsePart != null && !(this.elsePart instanceof JSTaggedExecutionNode) || this.thenPart != null && !(this.thenPart instanceof JSTaggedExecutionNode);
    }

    private static boolean hasMaterializationTag(Set<Class<? extends Tag>> materializedTags) {
        return materializedTags.contains(JSTags.ControlFlowRootTag.class) || materializedTags.contains(JSTags.ControlFlowBranchTag.class) || materializedTags.contains(JSTags.ControlFlowBlockTag.class);
    }

    private IfNode(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    public JavaScriptNode getThenPart() {
        return this.thenPart;
    }

    public JavaScriptNode getElsePart() {
        return this.elsePart;
    }

    public JavaScriptNode getCondition() {
        return this.condition;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.conditionProfile.profile(this.executeCondition(frame))) {
            if (this.thenPart != null) {
                return this.thenPart.execute(frame);
            }
            return EMPTY;
        }
        if (this.elsePart != null) {
            return this.elsePart.execute(frame);
        }
        return EMPTY;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        if (this.conditionProfile.profile(this.executeCondition(frame))) {
            if (this.thenPart != null) {
                this.thenPart.executeVoid(frame);
            }
        } else if (this.elsePart != null) {
            this.elsePart.executeVoid(frame);
        }
    }

    @Override
    public Object resume(VirtualFrame frame) {
        int index = this.getStateAsIntAndReset(frame);
        if (index == 0 && this.conditionProfile.profile(this.executeCondition(frame)) || index == 1) {
            try {
                if (this.thenPart != null) {
                    return this.thenPart.execute(frame);
                }
                return EMPTY;
            }
            catch (YieldException e) {
                this.setState(frame, 1);
                throw e;
            }
        }
        assert (index == 0 || index == 2);
        try {
            if (this.elsePart != null) {
                return this.elsePart.execute(frame);
            }
            return EMPTY;
        }
        catch (YieldException e) {
            this.setState(frame, 2);
            throw e;
        }
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return IfNode.isResultAlwaysOfType(this.thenPart, clazz) && IfNode.isResultAlwaysOfType(this.elsePart, clazz);
    }

    private static boolean isResultAlwaysOfType(JavaScriptNode child, Class<?> clazz) {
        if (child == null) {
            return clazz == Undefined.class;
        }
        return child.isResultAlwaysOfType(clazz);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new IfNode(IfNode.cloneUninitialized(this.condition), IfNode.cloneUninitialized(this.thenPart), IfNode.cloneUninitialized(this.elsePart));
    }

    protected boolean executeCondition(VirtualFrame frame) {
        try {
            return this.condition.executeBoolean(frame);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.insertToBoolean();
            return JSRuntime.toBoolean(ex.getResult());
        }
    }

    private void insertToBoolean() {
        CompilerAsserts.neverPartOfCompilation();
        Lock lock = this.getLock();
        lock.lock();
        try {
            JavaScriptNode cond = this.condition;
            if (!(cond instanceof JSToBooleanNode)) {
                this.condition = (JavaScriptNode)this.insert(JSToBooleanNode.create(cond));
            }
        }
        finally {
            lock.unlock();
        }
    }
}

