/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.other;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collections;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.hints.other.ExtractInlinedStyleRule;
import org.netbeans.modules.html.editor.refactoring.HtmlSpecificRefactoringsProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class ExtractInlinedStyleHint
extends Hint {
    public ExtractInlinedStyleHint(RuleContext context, OffsetRange range) {
        super((Rule)ExtractInlinedStyleRule.SINGLETON, ExtractInlinedStyleRule.SINGLETON.getDisplayName(), context.parserResult.getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new ExtractInlinedStyleHintFix(context)), 10);
    }

    private static class ExtractInlinedStyleHintFix
    implements HintFix {
        RuleContext context;

        public ExtractInlinedStyleHintFix(RuleContext context) {
            this.context = context;
        }

        public String getDescription() {
            return ExtractInlinedStyleRule.SINGLETON.getDisplayName();
        }

        public void implement() throws Exception {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        HtmlSpecificRefactoringsProvider provider = (HtmlSpecificRefactoringsProvider)Lookup.getDefault().lookup(HtmlSpecificRefactoringsProvider.class);
                        if (provider == null) {
                            return;
                        }
                        FileObject fileObject = ExtractInlinedStyleHintFix.this.context.parserResult.getSnapshot().getSource().getFileObject();
                        if (fileObject == null) {
                            return;
                        }
                        EditorCookie cookie = (EditorCookie)DataLoadersBridge.getDefault().getCookie(fileObject, EditorCookie.class);
                        if (cookie == null) {
                            return;
                        }
                        provider.doExtractInlineStyle(Lookups.fixed((Object[])new Object[]{cookie}));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

