/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.CallSitePrototypeBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.ErrorFunctionBuiltins;
import com.oracle.truffle.js.builtins.ErrorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.PrepareStackTraceCallback;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;
import java.util.Objects;

public final class JSError
extends JSBuiltinObject {
    public static final String MESSAGE = "message";
    public static final String NAME = "name";
    public static final String CLASS_NAME = "Error";
    public static final String PROTOTYPE_NAME = "Error.prototype";
    public static final HiddenKey EXCEPTION_PROPERTY_NAME = new HiddenKey("Exception");
    public static final String STACK_NAME = "stack";
    public static final HiddenKey FORMATTED_STACK_NAME = new HiddenKey("FormattedStack");
    public static final String ERRORS_NAME = "errors";
    public static final HiddenKey AGGREGATE_ERRORS_NAME = new HiddenKey("AggregateErrors");
    public static final String PREPARE_STACK_TRACE_NAME = "prepareStackTrace";
    public static final String LINE_NUMBER_PROPERTY_NAME = "lineNumber";
    public static final String COLUMN_NUMBER_PROPERTY_NAME = "columnNumber";
    public static final int DEFAULT_COLUMN_NUMBER = -1;
    public static final String STACK_TRACE_LIMIT_PROPERTY_NAME = "stackTraceLimit";
    public static final JSError INSTANCE = new JSError();
    private static final Property MESSAGE_PROPERTY;
    private static final Property AGGREGATE_ERRORS_PROPERTY;
    private static final String CALL_SITE_CLASS_NAME = "CallSite";
    public static final String CALL_SITE_PROTOTYPE_NAME = "CallSite.prototype";
    public static final HiddenKey STACK_TRACE_ELEMENT_PROPERTY_NAME;
    private static final Property STACK_TRACE_ELEMENT_PROPERTY;
    public static final PropertyProxy STACK_PROXY;

    private JSError() {
    }

    public static DynamicObject create(JSErrorType errorType, JSRealm realm, Object message) {
        String msg;
        DynamicObject obj;
        assert (message instanceof String || message == Undefined.instance);
        JSContext context = realm.getContext();
        DynamicObject prototype = realm.getErrorPrototype(errorType);
        if (message == Undefined.instance) {
            obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, false), realm, prototype, new Object[0]);
            msg = null;
        } else {
            obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, true), realm, prototype, message);
            msg = (String)message;
        }
        JSError.setException(realm, obj, JSException.createCapture(errorType, msg, obj, realm), false);
        return obj;
    }

    public static DynamicObject createFromJSException(JSException exception, JSRealm realm, String message) {
        JSErrorType errorType = exception.getErrorType();
        JSContext context = realm.getContext();
        DynamicObject prototype = realm.getErrorPrototype(errorType);
        DynamicObject obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, true), realm, prototype, Objects.requireNonNull(message));
        JSError.setException(realm, obj, exception, context.isOptionNashornCompatibilityMode());
        return obj;
    }

    private static DynamicObject createErrorPrototype(JSRealm realm, JSErrorType errorType) {
        JSContext ctx = realm.getContext();
        DynamicObject proto = errorType == JSErrorType.Error ? realm.getObjectPrototype() : realm.getErrorPrototype(JSErrorType.Error);
        DynamicObject errorPrototype = JSObject.createInit(realm, proto, (JSClass)(ctx.getEcmaScriptVersion() < 6 ? INSTANCE : JSUserObject.INSTANCE));
        if (errorType == JSErrorType.AggregateError) {
            JSObjectUtil.putConstantAccessorProperty(ctx, errorPrototype, ERRORS_NAME, JSError.createErrorsGetterFunction(realm), Undefined.instance);
        }
        JSObjectUtil.putDataProperty(ctx, errorPrototype, MESSAGE, "", JSAttributes.getDefaultNotEnumerable());
        if (errorType == JSErrorType.Error) {
            JSObjectUtil.putFunctionsFromContainer(realm, errorPrototype, ErrorPrototypeBuiltins.BUILTINS);
            if (ctx.isOptionNashornCompatibilityMode()) {
                JSObjectUtil.putFunctionsFromContainer(realm, errorPrototype, ErrorPrototypeBuiltins.ErrorPrototypeNashornCompatBuiltins.BUILTINS);
            }
        }
        return errorPrototype;
    }

    public static JSConstructor createErrorConstructor(JSRealm realm, JSErrorType errorType) {
        JSContext context = realm.getContext();
        String name = errorType.toString();
        DynamicObject errorConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, name);
        DynamicObject classPrototype = JSError.createErrorPrototype(realm, errorType);
        if (errorType != JSErrorType.Error) {
            JSObject.setPrototype(errorConstructor, realm.getErrorConstructor(JSErrorType.Error));
        }
        JSObjectUtil.putConstructorProperty(context, classPrototype, errorConstructor);
        JSObjectUtil.putDataProperty(context, classPrototype, NAME, name, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putConstructorPrototypeProperty(context, errorConstructor, classPrototype);
        if (errorType == JSErrorType.Error) {
            JSObjectUtil.putFunctionsFromContainer(realm, errorConstructor, ErrorFunctionBuiltins.BUILTINS);
            JSObjectUtil.putDataProperty(context, errorConstructor, STACK_TRACE_LIMIT_PROPERTY_NAME, JSContextOptions.STACK_TRACE_LIMIT.getValue(realm.getOptions()), JSAttributes.getDefault());
        }
        return new JSConstructor(errorConstructor, classPrototype);
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject errorPrototype) {
        return JSObjectUtil.getProtoChildShape(errorPrototype, INSTANCE, context);
    }

    public static Shape addAggregateErrorsPropertyToShape(Shape shape) {
        return shape.addProperty(AGGREGATE_ERRORS_PROPERTY);
    }

    public static Shape addMessagePropertyToShape(Shape shape) {
        return shape.addProperty(MESSAGE_PROPERTY);
    }

    private static DynamicObject createCallSitePrototype(JSRealm realm) {
        DynamicObject proto = realm.getObjectPrototype();
        DynamicObject callSitePrototype = JSObject.createInit(realm, proto, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, callSitePrototype, CallSitePrototypeBuiltins.BUILTINS);
        return callSitePrototype;
    }

    public static JSConstructor createCallSiteConstructor(JSRealm realm) {
        JSContext context = realm.getContext();
        DynamicObject constructor = JSFunction.createNamedEmptyFunction(realm, CALL_SITE_CLASS_NAME);
        DynamicObject prototype = JSError.createCallSitePrototype(realm);
        JSObjectUtil.putConstructorProperty(context, prototype, constructor);
        JSObjectUtil.putConstructorPrototypeProperty(context, constructor, prototype);
        return new JSConstructor(constructor, prototype);
    }

    public static Shape makeInitialCallSiteShape(JSContext context, DynamicObject callSitePrototype) {
        return JSObjectUtil.getProtoChildShape(callSitePrototype, JSUserObject.INSTANCE, context).addProperty(STACK_TRACE_ELEMENT_PROPERTY);
    }

    public static void setLineNumber(JSContext context, DynamicObject errorObj, Object lineNumber) {
        JSError.setErrorProperty(context, errorObj, LINE_NUMBER_PROPERTY_NAME, lineNumber);
    }

    public static void setColumnNumber(JSContext context, DynamicObject errorObj, Object columnNumber) {
        JSError.setErrorProperty(context, errorObj, COLUMN_NUMBER_PROPERTY_NAME, columnNumber);
    }

    public static GraalJSException getException(DynamicObject errorObj) {
        Object exception = errorObj.get((Object)EXCEPTION_PROPERTY_NAME);
        return exception instanceof GraalJSException ? (GraalJSException)exception : null;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject setException(JSRealm realm, DynamicObject errorObj, GraalJSException exception, boolean defaultColumnNumber) {
        assert (JSError.isJSError(errorObj));
        JSError.defineStackProperty(realm, errorObj, exception);
        JSContext context = realm.getContext();
        if (context.isOptionNashornCompatibilityMode() && exception.getJSStackTrace().length > 0) {
            GraalJSException.JSStackTraceElement topStackTraceElement = exception.getJSStackTrace()[0];
            JSError.setLineNumber(context, errorObj, topStackTraceElement.getLineNumber());
            JSError.setColumnNumber(context, errorObj, defaultColumnNumber ? -1 : topStackTraceElement.getColumnNumber());
        }
        return errorObj;
    }

    private static void setErrorProperty(JSContext context, DynamicObject errorObj, Object key, Object value) {
        if (!errorObj.set(key, value)) {
            JSObjectUtil.putDataProperty(context, errorObj, key, value, JSAttributes.getDefaultNotEnumerable());
        }
    }

    private static void defineStackProperty(JSRealm realm, DynamicObject errorObj, GraalJSException exception) {
        JSContext context = realm.getContext();
        JSError.setErrorProperty(context, errorObj, EXCEPTION_PROPERTY_NAME, exception);
        errorObj.define((Object)FORMATTED_STACK_NAME, null);
        JSObjectUtil.defineProxyProperty(errorObj, STACK_NAME, STACK_PROXY, JSAttributes.getDefaultNotEnumerable() | 0x10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object prepareStack(JSRealm realm, DynamicObject errorObj, GraalJSException exception) {
        GraalJSException.JSStackTraceElement[] stackTrace = exception.getJSStackTrace();
        if (realm.isPreparingStackTrace()) {
            return JSError.formatStackTrace(stackTrace, errorObj, realm);
        }
        try {
            realm.setPreparingStackTrace(true);
            PrepareStackTraceCallback prepareStackTraceCallback = realm.getContext().getPrepareStackTraceCallback();
            if (prepareStackTraceCallback == null) {
                Object object = JSError.prepareStackNoCallback(realm, errorObj, stackTrace);
                return object;
            }
            Object object = JSError.prepareStackTraceWithCallback(realm, prepareStackTraceCallback, errorObj, stackTrace);
            return object;
        }
        finally {
            realm.setPreparingStackTrace(false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object prepareStackNoCallback(JSRealm realm, DynamicObject errorObj, GraalJSException.JSStackTraceElement[] jsStackTrace) {
        DynamicObject error = realm.getErrorConstructor(JSErrorType.Error);
        Object prepareStackTrace = JSObject.get(error, (Object)PREPARE_STACK_TRACE_NAME);
        if (JSFunction.isJSFunction(prepareStackTrace)) {
            return JSError.prepareStackWithUserFunction(realm, (DynamicObject)prepareStackTrace, errorObj, jsStackTrace);
        }
        return JSError.formatStackTrace(jsStackTrace, errorObj, realm);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object prepareStackTraceWithCallback(JSRealm realm, PrepareStackTraceCallback callback, DynamicObject errorObj, GraalJSException.JSStackTraceElement[] stackTrace) {
        try {
            return callback.prepareStackTrace(realm, errorObj, JSError.toStructuredStackTrace(realm, stackTrace));
        }
        catch (Exception ex) {
            return JSError.formatStackTrace(stackTrace, errorObj, realm);
        }
    }

    private static Object prepareStackWithUserFunction(JSRealm realm, DynamicObject prepareStackTraceFun, DynamicObject errorObj, GraalJSException.JSStackTraceElement[] stackTrace) {
        return JSFunction.call(prepareStackTraceFun, errorObj, new Object[]{errorObj, JSError.toStructuredStackTrace(realm, stackTrace)});
    }

    private static DynamicObject toStructuredStackTrace(JSRealm realm, GraalJSException.JSStackTraceElement[] stackTrace) {
        Object[] elements = new Object[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            elements[i] = JSError.prepareStackElement(realm, stackTrace[i]);
        }
        return JSArray.createConstant(realm.getContext(), elements);
    }

    private static Object prepareStackElement(JSRealm realm, GraalJSException.JSStackTraceElement stackTraceElement) {
        return JSObject.createWithRealm(realm.getContext(), realm.getContext().getCallSiteFactory(), realm, stackTraceElement);
    }

    private static String getMessage(DynamicObject errorObj) {
        Object message = JSObject.get(errorObj, (Object)MESSAGE);
        return message == Undefined.instance ? null : JSRuntime.toString(message);
    }

    private static String getName(DynamicObject errorObj) {
        Object name = JSObject.get(errorObj, (Object)NAME);
        return name == Undefined.instance ? null : JSRuntime.toString(name);
    }

    private static boolean isInstanceOfJSError(DynamicObject errorObj, JSRealm realm) {
        DynamicObject errorPrototype = realm.getErrorPrototype(JSErrorType.Error);
        return JSRuntime.isPrototypeOf(errorObj, errorPrototype);
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatStackTrace(GraalJSException.JSStackTraceElement[] stackTrace, DynamicObject errObj, JSRealm realm) {
        StringBuilder builder = new StringBuilder();
        if (!realm.getContext().isOptionNashornCompatibilityMode() || JSError.isInstanceOfJSError(errObj, realm)) {
            String name = JSError.getName(errObj);
            String message = JSError.getMessage(errObj);
            if (name != null) {
                builder.append(name);
            } else {
                builder.append(CLASS_NAME);
            }
            if (message != null && message.length() > 0) {
                if (builder.length() != 0) {
                    builder.append(": ");
                }
                builder.append(message);
            }
        } else {
            builder.append(JSObject.defaultToString(errObj));
        }
        JSError.formatStackTraceIntl(stackTrace, builder, realm.getContext());
        return builder.toString();
    }

    private static void formatStackTraceIntl(GraalJSException.JSStackTraceElement[] stackTrace, StringBuilder builder, JSContext context) {
        boolean nashornCompatibilityMode = context.isOptionNashornCompatibilityMode();
        for (GraalJSException.JSStackTraceElement elem : stackTrace) {
            builder.append('\n');
            builder.append(nashornCompatibilityMode ? "\tat " : "    at ");
            if (!nashornCompatibilityMode) {
                builder.append(elem.toString(context));
                continue;
            }
            String methodName = JSError.correctMethodName(elem.getFunctionName(), context);
            builder.append(methodName);
            builder.append(" (");
            String fileName = elem.getFileName();
            if ("<builtin>".equals(fileName)) {
                builder.append("native");
            } else {
                builder.append(fileName);
                builder.append(":");
                builder.append(elem.getLineNumber());
            }
            builder.append(")");
        }
    }

    public static String correctMethodName(String methodName, JSContext context) {
        int idx;
        if (methodName == null) {
            return "";
        }
        if (methodName.isEmpty()) {
            return JSError.getAnonymousFunctionNameStackTrace(context);
        }
        if (Boundaries.stringEndsWith(methodName, "]") && (idx = Boundaries.stringLastIndexOf(methodName, '[')) >= 0) {
            return Boundaries.substring(methodName, idx);
        }
        idx = Boundaries.stringLastIndexOf(methodName, '.');
        if (idx >= 0) {
            return Boundaries.substring(methodName, idx + 1);
        }
        return methodName;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    public static boolean isJSError(Object obj) {
        return JSObject.isDynamicObject(obj) && JSError.isJSError((DynamicObject)obj);
    }

    public static boolean isJSError(DynamicObject obj) {
        return JSError.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        String messageStr;
        if (context.isOptionNashornCompatibilityMode()) {
            return super.safeToString(obj, depth, context);
        }
        Object name = JSError.getPropertyWithoutSideEffect(obj, NAME);
        Object message = JSError.getPropertyWithoutSideEffect(obj, MESSAGE);
        String nameStr = name != null ? JSRuntime.safeToString(name, depth, obj, false) : CLASS_NAME;
        String string = messageStr = message != null ? JSRuntime.safeToString(message, depth, obj, false) : "";
        if (nameStr.isEmpty()) {
            if (messageStr.isEmpty()) {
                return CLASS_NAME;
            }
            return messageStr;
        }
        if (messageStr.isEmpty()) {
            return nameStr;
        }
        return nameStr + ": " + messageStr;
    }

    private static Object getPropertyWithoutSideEffect(DynamicObject obj, String key) {
        Object value = obj.get((Object)key);
        if (value == null) {
            if (!JSProxy.isProxy(obj)) {
                return JSError.getPropertyWithoutSideEffect(JSObject.getPrototype(obj), key);
            }
            return null;
        }
        if (value instanceof Accessor) {
            return "{Accessor}";
        }
        if (value instanceof PropertyProxy) {
            return null;
        }
        return value;
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return true;
    }

    public static String getAnonymousFunctionNameStackTrace(JSContext context) {
        return context.isOptionNashornCompatibilityMode() ? "<program>" : "<anonymous>";
    }

    public static Object[] getAggregateErrors(DynamicObject obj) {
        return (Object[])obj.get((Object)AGGREGATE_ERRORS_NAME);
    }

    private static DynamicObject createErrorsGetterFunction(JSRealm realm) {
        final JSContext context = realm.getContext();
        JSFunctionData getterData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ErrorGetAggregateErrors, c -> {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
                private final BranchProfile errorBranch;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.errorBranch = BranchProfile.create();
                }

                public Object execute(VirtualFrame frame) {
                    Object obj = frame.getArguments()[0];
                    if (JSObject.isJSObject(obj) && JSError.getAggregateErrors((DynamicObject)obj) != null) {
                        Object[] value = JSError.getAggregateErrors((DynamicObject)obj);
                        return JSArray.createConstantObjectArray(context, value);
                    }
                    this.errorBranch.enter();
                    throw Errors.createTypeError("AggregateError expected");
                }
            });
            return JSFunctionData.createCallOnly(c, (CallTarget)callTarget, 0, "get errors");
        });
        return JSFunction.create(realm, getterData);
    }

    static {
        STACK_TRACE_ELEMENT_PROPERTY_NAME = new HiddenKey("StackTraceElement");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        MESSAGE_PROPERTY = JSObjectUtil.makeDataProperty(MESSAGE, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.getDefaultNotEnumerable());
        AGGREGATE_ERRORS_PROPERTY = JSObjectUtil.makeHiddenProperty(AGGREGATE_ERRORS_NAME, allocator.locationForType(Object[].class, EnumSet.of(LocationModifier.NonNull)));
        allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        STACK_TRACE_ELEMENT_PROPERTY = JSObjectUtil.makeHiddenProperty(STACK_TRACE_ELEMENT_PROPERTY_NAME, allocator.locationForType(Object.class));
        STACK_PROXY = new PropertyProxy(){

            @Override
            public Object get(DynamicObject store) {
                Object value = store.get((Object)FORMATTED_STACK_NAME);
                if (value == null) {
                    GraalJSException truffleException = JSError.getException(store);
                    if (truffleException == null) {
                        value = Undefined.instance;
                    } else {
                        JSRealm realm = this.currentRealm(store);
                        value = JSError.prepareStack(realm, store, truffleException);
                    }
                    Object currentValue = store.get((Object)FORMATTED_STACK_NAME);
                    if (currentValue == null) {
                        store.set((Object)FORMATTED_STACK_NAME, value);
                    } else {
                        value = currentValue;
                    }
                }
                return value;
            }

            private JSRealm currentRealm(DynamicObject store) {
                return JSObject.getJSContext(store).getRealm();
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                store.set((Object)FORMATTED_STACK_NAME, value);
                return true;
            }
        };
    }
}

