/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public final class JspServletDataLoader
extends MultiFileLoader {
    private static final long serialVersionUID = -6033464827752236719L;
    public static final String JAVA_EXTENSION = "java";
    public static final String JSP_MARK = "_jsp";

    public JspServletDataLoader() {
        super("org.netbeans.modules.web.core.jsploader.JspServletDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(JspServletDataLoader.class).getString("PROP_JspServletLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-jsp-servlet/Actions/";
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        Object javaPrim = fo.isFolder() ? null : (fo.getExt().equals(JAVA_EXTENSION) ? fo : null);
        if (javaPrim == null) {
            return null;
        }
        if (javaPrim.getAttribute("NetBeansAttrOriginJspPage") != null) {
            return javaPrim;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new JspServletDataObject(primaryFile, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        if (JAVA_EXTENSION.equals(primaryFile.getExt())) {
            return JavaDataSupport.createJavaFileEntry((MultiDataObject)obj, (FileObject)primaryFile);
        }
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        Logger.getLogger("global").log(Level.INFO, "Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(obj, secondaryFile);
    }
}

