/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIProxy;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebuggerConfig;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebuggerEngineProvider;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.Command;
import org.netbeans.modules.cpplite.debugger.ThreadsCollector;
import org.netbeans.modules.cpplite.debugger.Utils;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeimage.api.Location;
import org.netbeans.modules.nativeimage.api.SourceInfo;
import org.netbeans.modules.nativeimage.api.Symbol;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class CPPLiteDebugger {
    private static final Logger LOGGER = Logger.getLogger(CPPLiteDebugger.class.getName());
    private CPPLiteDebuggerConfig configuration;
    private CPPLiteDebuggerEngineProvider engineProvider;
    private ContextProvider contextProvider;
    private Process debuggee;
    private LiteMIProxy proxy;
    private volatile Object currentLine;
    private volatile boolean suspended = false;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private final BreakpointsHandler breakpointsHandler = new BreakpointsHandler();
    private final ThreadsCollector threadsCollector = new ThreadsCollector(this);
    private volatile CPPThread currentThread;
    private volatile CPPFrame currentFrame;
    private AtomicInteger exitCode = new AtomicInteger();
    private volatile boolean finished = false;

    public CPPLiteDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.configuration = (CPPLiteDebuggerConfig)contextProvider.lookupFirst(null, CPPLiteDebuggerConfig.class);
        this.engineProvider = (CPPLiteDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
    }

    void setDebuggee(Process debuggee) {
        this.debuggee = debuggee;
        CPPLiteInjector injector = new CPPLiteInjector(debuggee.getOutputStream());
        this.proxy = new LiteMIProxy(injector, "(gdb)", "UTF-8");
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(debuggee.getInputStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.proxy.processLine(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.finish(false);
        }).start();
        this.proxy.waitStarted();
        this.breakpointsHandler.init();
        this.proxy.send(new Command("-gdb-set target-async"));
        this.proxy.send(new Command("-gdb-set non-stop on"));
        this.proxy.send(new Command("-gdb-set print object on"));
    }

    public void execRun() {
        this.proxy.send(new Command("-exec-run"));
    }

    MIRecord sendAndGet(String command) throws InterruptedException {
        return this.sendAndGet(command, false);
    }

    MIRecord sendAndGet(String command, boolean waitForRunning) throws InterruptedException {
        final CountDownLatch done = new CountDownLatch(1);
        final MIRecord[] result = new MIRecord[1];
        this.proxy.send(new Command(command){

            @Override
            protected void onDone(MIRecord record) {
                result[0] = record;
                done.countDown();
            }

            @Override
            protected void onError(MIRecord record) {
                result[0] = record;
                done.countDown();
            }

            @Override
            protected void onExit(MIRecord record) {
                result[0] = record;
                done.countDown();
            }
        }, waitForRunning);
        done.await();
        return result[0];
    }

    void send(Command command) {
        this.proxy.send(command);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSuspended(boolean suspended, CPPThread thread, CPPFrame frame) {
        CPPFrame currentFrameNew;
        CPPFrame currentFrameOld;
        CPPThread currentThreadNew;
        CPPThread currentThreadOld;
        boolean suspendedNew;
        boolean suspendedOld;
        Iterator<StateListener> iterator = this;
        synchronized (iterator) {
            suspendedNew = suspendedOld = this.suspended;
            currentThreadNew = currentThreadOld = this.currentThread;
            currentFrameNew = currentFrameOld = this.currentFrame;
            if (suspended) {
                if (currentThreadOld == null || currentThreadOld.getStatus() != CPPThread.Status.SUSPENDED) {
                    currentThreadNew = thread;
                    currentFrameNew = frame;
                } else if (currentThreadOld == thread) {
                    currentFrameNew = frame;
                }
                suspendedNew = true;
            } else if (thread == currentThreadOld) {
                suspendedNew = false;
                currentFrameNew = null;
            }
            this.suspended = suspendedNew;
            this.currentThread = currentThreadNew;
            this.currentFrame = currentFrameNew;
        }
        if (suspendedNew != suspendedOld) {
            for (StateListener sl : this.stateListeners) {
                sl.suspended(suspendedNew);
            }
        }
        if (currentThreadNew != currentThreadOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentThread(currentThreadNew);
            }
        }
        if (currentFrameNew != currentFrameOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentFrame(currentFrameNew);
            }
        }
    }

    private void fireFinished() {
        for (StateListener sl : this.stateListeners) {
            sl.finished();
        }
    }

    public void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    public void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    public ThreadsCollector getThreads() {
        return this.threadsCollector;
    }

    public CPPThread getCurrentThread() {
        return this.currentThread;
    }

    public CPPFrame getCurrentFrame() {
        return this.currentFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentStackFrame(CPPFrame cppFrame) {
        CPPFrame currentFrameOld;
        CPPThread currentThreadOld;
        CPPThread currentThreadNew = cppFrame.getThread();
        Iterator<StateListener> iterator = this;
        synchronized (iterator) {
            currentThreadOld = this.currentThread;
            currentFrameOld = this.currentFrame;
            this.currentThread = currentThreadNew;
            this.currentFrame = cppFrame;
        }
        if (currentThreadNew != currentThreadOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentThread(currentThreadNew);
            }
        }
        if (cppFrame != currentFrameOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentFrame(cppFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentThread(CPPThread thread) {
        CPPFrame currentFrameNew;
        CPPFrame currentFrameOld;
        CPPThread currentThreadOld;
        Iterator<StateListener> iterator = this;
        synchronized (iterator) {
            currentThreadOld = this.currentThread;
            if (currentThreadOld == thread) {
                return;
            }
            this.currentThread = thread;
            currentFrameOld = this.currentFrame;
            this.currentFrame = currentFrameNew = thread.getTopFrame();
        }
        if (thread != currentThreadOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentThread(thread);
            }
        }
        if (currentFrameNew != currentFrameOld) {
            for (StateListener sl : this.stateListeners) {
                sl.currentFrame(currentFrameNew);
            }
        }
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    public boolean isFinished() {
        return this.finished;
    }

    void doStep(Object action) {
        CPPThread thread = this.currentThread;
        String threadId = "";
        if (thread != null) {
            thread.notifyRunning();
            threadId = " --thread " + thread.getId();
        }
        if (action == ActionsManager.ACTION_STEP_OVER) {
            this.proxy.send(new Command("-exec-next" + threadId));
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            this.proxy.send(new Command("-exec-step" + threadId));
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            this.proxy.send(new Command("-exec-finish" + threadId));
        }
    }

    void pause() {
        this.proxy.send(new Command("-exec-interrupt --all"));
    }

    void resume() {
        this.threadsCollector.running("all");
        this.proxy.send(new Command("-exec-continue --all"));
    }

    void finish(boolean sendExit) {
        this.finish(sendExit, 0);
    }

    private void finish(boolean sendExit, int exitCode) {
        if (exitCode != 0) {
            this.exitCode.set(exitCode);
        }
        LOGGER.fine("CPPLiteDebugger.finish()");
        if (this.finished) {
            LOGGER.fine("finish(): already finished.");
            return;
        }
        this.breakpointsHandler.dispose();
        if (sendExit) {
            this.proxy.send(new Command("-gdb-exit"));
        }
        Utils.unmarkCurrent();
        this.engineProvider.getDestructor().killEngine();
        this.finished = true;
        this.fireFinished();
        LOGGER.fine("finish() done, build finished.");
    }

    public String readMemory(String address, long offset, int length) {
        MITListItem row;
        MITList memoryList;
        MIRecord memory;
        String offsetArg = offset != 0L ? "-o " + offset + " " : "";
        try {
            memory = this.sendAndGet("-data-read-memory-bytes " + offsetArg + address + " " + length);
        }
        catch (InterruptedException ex) {
            return null;
        }
        MIValue memoryValue = memory.results().valueOf("memory");
        if (memoryValue instanceof MITList && !(memoryList = (MITList)memoryValue).isEmpty() && (row = memoryList.get(0)) instanceof MITList) {
            String contents = ((MITList)row).getConstValue("contents");
            return contents;
        }
        return null;
    }

    public String getVersion() {
        MIRecord versionRecord;
        try {
            versionRecord = this.sendAndGet("-gdb-version");
        }
        catch (InterruptedException ex) {
            return null;
        }
        return versionRecord.command().getConsoleStream();
    }

    public List<Location> listLocations(String filePath) {
        MIRecord lines;
        try {
            lines = this.sendAndGet("-symbol-list-lines " + filePath);
        }
        catch (InterruptedException ex) {
            return null;
        }
        MIValue linesValue = lines.results().valueOf("lines");
        if (linesValue instanceof MITList) {
            MITList lineList = (MITList)linesValue;
            int size = lineList.size();
            ArrayList<Location> locations = new ArrayList<Location>(size);
            Location.Builder locationBuilder = Location.newBuilder();
            for (MITListItem item : lineList) {
                if (!(item instanceof MITList)) continue;
                MITList il = (MITList)item;
                String pcs = il.getConstValue("pc", null);
                if (pcs != null) {
                    long pc;
                    if (pcs.startsWith("0x")) {
                        pcs = pcs.substring(2);
                        pc = Long.parseUnsignedLong(pcs, 16);
                    } else {
                        pc = Long.parseUnsignedLong(pcs);
                    }
                    locationBuilder.pc(pc);
                } else {
                    locationBuilder.pc(0L);
                }
                String lineStr = il.getConstValue("line", null);
                if (lineStr != null) {
                    locationBuilder.line(Integer.parseInt(lineStr));
                } else {
                    locationBuilder.line(0);
                }
                locations.add(locationBuilder.build());
            }
            return locations;
        }
        return null;
    }

    public Map<SourceInfo, List<Symbol>> listFunctions(String name, boolean includeNondebug, int maxResults) {
        StringBuilder command = new StringBuilder("-symbol-info-functions");
        if (name != null) {
            command.append(" --name ");
            command.append(name);
        }
        if (includeNondebug) {
            command.append(" --include-nondebug");
        }
        if (maxResults > 0) {
            command.append(" --max-results ");
            command.append(maxResults);
        }
        return this.listSymbols(command.toString());
    }

    public Map<SourceInfo, List<Symbol>> listVariables(String name, boolean includeNondebug, int maxResults) {
        StringBuilder command = new StringBuilder("-symbol-info-variables");
        if (name != null) {
            command.append(" --name ");
            command.append(name);
        }
        if (includeNondebug) {
            command.append(" --include-nondebug");
        }
        if (maxResults > 0) {
            command.append(" --max-results ");
            command.append(maxResults);
        }
        return this.listSymbols(command.toString());
    }

    private Map<SourceInfo, List<Symbol>> listSymbols(String command) {
        MIRecord result;
        try {
            result = this.sendAndGet(command);
        }
        catch (InterruptedException ex) {
            return null;
        }
        MIValue allSymbolsValue = result.results().valueOf("symbols");
        if (allSymbolsValue instanceof MITList) {
            MITList allSymbolsList = (MITList)allSymbolsValue;
            if (allSymbolsList.size() == 0) {
                return Collections.emptyMap();
            }
            MIValue debugValue = allSymbolsList.valueOf("debug");
            if (debugValue instanceof MITList) {
                MITList debugList = (MITList)debugValue;
                int size = debugList.size();
                LinkedHashMap sourceSymbols = new LinkedHashMap(size);
                for (MITListItem debugItem : debugList) {
                    if (!(debugItem instanceof MITList)) continue;
                    MITList sourceWithSymbols = (MITList)debugItem;
                    SourceInfo.Builder sourceBuilder = SourceInfo.newBuilder();
                    String filename = sourceWithSymbols.getConstValue("filename", null);
                    String fullname = sourceWithSymbols.getConstValue("fullname", null);
                    sourceBuilder.fileName(filename);
                    sourceBuilder.fullName(fullname);
                    SourceInfo source = sourceBuilder.build();
                    MIValue symbolsValue = sourceWithSymbols.valueOf("symbols");
                    if (!(symbolsValue instanceof MITList)) continue;
                    MITList symbolsList = (MITList)symbolsValue;
                    int symbolsSize = symbolsList.size();
                    ArrayList<Symbol> symbols = new ArrayList<Symbol>(symbolsSize);
                    for (MITListItem symbolItem : symbolsList) {
                        if (!(symbolItem instanceof MITList)) continue;
                        MITList symbolList = (MITList)symbolItem;
                        String name = symbolList.getConstValue("name");
                        String type = symbolList.getConstValue("type", null);
                        String description = symbolList.getConstValue("description", null);
                        Symbol.Builder symbolBuilder = Symbol.newBuilder();
                        symbolBuilder.name(name);
                        symbolBuilder.type(type);
                        symbolBuilder.description(description);
                        symbols.add(symbolBuilder.build());
                    }
                    sourceSymbols.put(source, symbols);
                }
                return Collections.unmodifiableMap(sourceSymbols);
            }
            return null;
        }
        return null;
    }

    ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    DebuggingView.DVSupport getDVSupport() {
        return (DebuggingView.DVSupport)this.contextProvider.lookupFirst(null, DebuggingView.DVSupport.class);
    }

    @NonNull
    public static Pair<DebuggerEngine, Process> startDebugging(final CPPLiteDebuggerConfig configuration, Object ... services) throws IOException {
        SessionProvider sessionProvider = new SessionProvider(){

            public String getSessionName() {
                return configuration.getDisplayName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return "CPPLiteSession";
            }

            public Object[] getServices() {
                return new Object[0];
            }
        };
        Object[] allServices = Arrays.copyOf(services, services.length + 2);
        allServices[services.length] = sessionProvider;
        allServices[services.length + 1] = configuration;
        DebuggerInfo di = DebuggerInfo.create((String)"CPPLiteDebuggerInfo", (Object[])allServices);
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(di);
        final Pty pty = PtySupport.allocate((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        CPPLiteDebugger debugger = (CPPLiteDebugger)es[0].lookupFirst(null, CPPLiteDebugger.class);
        ArrayList<String> executable = new ArrayList<String>();
        executable.add(configuration.getDebugger());
        executable.add("--interpreter=mi");
        executable.add("--tty=" + pty.getSlaveName());
        executable.addAll(configuration.getExecutable());
        final Process debuggee = new ProcessBuilder(executable).directory(configuration.getDirectory()).start();
        new RequestProcessor(configuration.getDisplayName() + " (pty deallocator)").post(() -> {
            try {
                while (debuggee.isAlive()) {
                    try {
                        debuggee.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                try {
                    PtySupport.deallocate((Pty)pty);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        debugger.setDebuggee(debuggee);
        final AtomicInteger exitCode = debugger.exitCode;
        return Pair.of((Object)es[0], (Object)new Process(){

            @Override
            public OutputStream getOutputStream() {
                return pty.getOutputStream();
            }

            @Override
            public InputStream getInputStream() {
                return pty.getInputStream();
            }

            @Override
            public InputStream getErrorStream() {
                return pty.getErrorStream();
            }

            @Override
            public boolean isAlive() {
                return debuggee.isAlive();
            }

            @Override
            public int waitFor() throws InterruptedException {
                debuggee.waitFor();
                return exitCode.get();
            }

            @Override
            public int exitValue() {
                return debuggee.exitValue();
            }

            @Override
            public void destroy() {
                debuggee.destroy();
            }
        });
    }

    private class BreakpointsHandler
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private final Map<String, CPPLiteBreakpoint> breakpointsById = new ConcurrentHashMap<String, CPPLiteBreakpoint>();
        private final Map<CPPLiteBreakpoint, String> breakpointIds = new ConcurrentHashMap<CPPLiteBreakpoint, String>();

        BreakpointsHandler() {
        }

        private void init() {
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            for (Breakpoint b : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!(b instanceof CPPLiteBreakpoint)) continue;
                CPPLiteBreakpoint cpplineBreakpoint = (CPPLiteBreakpoint)b;
                this.addBreakpoint(cpplineBreakpoint);
            }
        }

        void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            for (Breakpoint b : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!(b instanceof CPPLiteBreakpoint)) continue;
                b.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            if (breakpoint instanceof CPPLiteBreakpoint) {
                this.addBreakpoint((CPPLiteBreakpoint)breakpoint);
            }
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            if (breakpoint instanceof CPPLiteBreakpoint) {
                this.removeBreakpoint((CPPLiteBreakpoint)breakpoint);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String id;
            Object source = evt.getSource();
            if (source instanceof CPPLiteBreakpoint && (id = this.breakpointIds.get((Object)((CPPLiteBreakpoint)((Object)source)))) != null) {
                String propertyName;
                switch (propertyName = evt.getPropertyName()) {
                    case "enabled": {
                        if (Boolean.TRUE.equals(evt.getNewValue())) {
                            CPPLiteDebugger.this.proxy.send(new Command("-break-enable " + id));
                            break;
                        }
                        CPPLiteDebugger.this.proxy.send(new Command("-break-disable " + id));
                    }
                }
            }
        }

        private void addBreakpoint(final CPPLiteBreakpoint breakpoint) {
            String path = breakpoint.getFilePath();
            int lineNumber = breakpoint.getLineNumber();
            String disabled = breakpoint.isEnabled() ? "" : "-d ";
            Command command = new Command("-break-insert " + disabled + path + ":" + lineNumber){

                @Override
                protected void onDone(MIRecord record) {
                    MIValue bkpt = record.results().valueOf("bkpt");
                    if (bkpt instanceof MITList) {
                        BreakpointsHandler.this.breakpointResolved(breakpoint, (MITList)bkpt);
                    }
                    super.onDone(record);
                }

                @Override
                protected void onError(MIRecord record) {
                    String msg = record.results().getConstValue("msg");
                    BreakpointsHandler.this.breakpointError(breakpoint, msg);
                    super.onError(record);
                }
            };
            CPPLiteDebugger.this.proxy.send(command, false);
            breakpoint.addPropertyChangeListener(this);
        }

        private void removeBreakpoint(CPPLiteBreakpoint breakpoint) {
            String id = this.breakpointIds.remove((Object)breakpoint);
            if (id != null) {
                breakpoint.removePropertyChangeListener(this);
                Command command = new Command("-break-delete " + id);
                CPPLiteDebugger.this.proxy.send(command);
            }
        }

        private void breakpointResolved(CPPLiteBreakpoint breakpoint, MITList list) {
            breakpoint.setCPPValidity(Breakpoint.VALIDITY.VALID, null);
            String id = list.getConstValue("number");
            this.breakpointsById.put(id, breakpoint);
            this.breakpointIds.put(breakpoint, id);
        }

        private void breakpointError(CPPLiteBreakpoint breakpoint, String msg) {
            breakpoint.setCPPValidity(Breakpoint.VALIDITY.INVALID, msg);
        }
    }

    public static interface StateListener
    extends EventListener {
        public void currentThread(CPPThread var1);

        public void currentFrame(CPPFrame var1);

        public void suspended(boolean var1);

        public void finished();
    }

    private class LiteMIProxy
    extends MIProxy {
        private final CountDownLatch startedLatch;
        private final CountDownLatch runningLatch;
        private final CountDownLatch runningCommandLatch;
        private final Semaphore runningCommandSemaphore;
        private final Object sendLock;

        LiteMIProxy(MICommandInjector injector, String prompt, String encoding) {
            super(injector, prompt, encoding);
            this.startedLatch = new CountDownLatch(1);
            this.runningLatch = new CountDownLatch(1);
            this.runningCommandLatch = new CountDownLatch(0);
            this.runningCommandSemaphore = new Semaphore(1);
            this.sendLock = new Object();
        }

        @Override
        protected void prompt() {
            this.startedLatch.countDown();
        }

        @Override
        protected void execAsyncOutput(MIRecord record) {
            LOGGER.log(Level.FINE, "MIProxy.execAsyncOutput({0})", record);
            switch (record.cls()) {
                case "stopped": {
                    Line currentLine;
                    MITList results = record.results();
                    String threadId = results.getConstValue("thread-id");
                    MIValue stoppedThreads = results.valueOf("stopped-threads");
                    if (stoppedThreads != null) {
                        if (stoppedThreads.isConst()) {
                            CPPLiteDebugger.this.threadsCollector.stopped(stoppedThreads.asConst().value());
                        } else {
                            MITList stoppedThreadsList = stoppedThreads.asList();
                            int size = stoppedThreadsList.size();
                            String[] ids = new String[size];
                            for (int i = 0; i < size; ++i) {
                                ids[i] = ((MIConst)stoppedThreadsList.get(i)).value();
                            }
                            CPPLiteDebugger.this.threadsCollector.stopped(ids);
                        }
                    }
                    CPPThread thread = CPPLiteDebugger.this.threadsCollector.get(threadId);
                    String reason = results.getConstValue("reason", "");
                    if (reason.startsWith("exited")) {
                        if ('*' == record.type()) {
                            String exitCodeStr;
                            int exitCode = "exited-normally".equals(reason) ? 0 : ((exitCodeStr = results.getConstValue("exit-code", null)) != null ? (exitCodeStr.startsWith("0x") ? Integer.parseInt(exitCodeStr, 16) : (exitCodeStr.startsWith("0") ? Integer.parseInt(exitCodeStr, 8) : Integer.parseInt(exitCodeStr))) : 0);
                            CPPLiteDebugger.this.finish(true, exitCode);
                            break;
                        }
                        CPPLiteDebugger.this.threadsCollector.remove(threadId);
                        break;
                    }
                    MITList topFrameList = (MITList)results.valueOf("frame");
                    CPPFrame frame = topFrameList != null ? CPPFrame.create(thread, topFrameList) : null;
                    thread.setTopFrame(frame);
                    CPPLiteDebugger.this.setSuspended(true, thread, frame);
                    if (frame == null || (currentLine = frame.location()) == null) break;
                    Annotatable[] lines = new Annotatable[]{currentLine};
                    CPPLiteDebugger.this.currentLine = lines;
                    Utils.markCurrent(lines);
                    Utils.showLine(lines);
                    break;
                }
                case "running": {
                    MITList results = record.results();
                    String threadId = results.getConstValue("thread-id");
                    CPPThread thread = CPPLiteDebugger.this.threadsCollector.running(threadId);
                    CPPLiteDebugger.this.setSuspended(false, thread, null);
                    Utils.unmarkCurrent();
                    break;
                }
            }
        }

        @Override
        protected void notifyAsyncOutput(MIRecord record) {
            LOGGER.log(Level.FINE, "MIProxy.notifyAsyncOutput({0})", record);
            if ('=' == record.type()) {
                switch (record.cls()) {
                    case "thread-created": {
                        String id = this.getThreadId(record);
                        CPPLiteDebugger.this.threadsCollector.add(id);
                        break;
                    }
                    case "thread-exited": {
                        String id = this.getThreadId(record);
                        CPPLiteDebugger.this.threadsCollector.remove(id);
                    }
                }
            }
            super.notifyAsyncOutput(record);
        }

        private String getThreadId(MIRecord record) {
            MITList results = record.results();
            String id = results.getConstValue("id");
            return id;
        }

        @Override
        protected void statusAsyncOutput(MIRecord record) {
            LOGGER.log(Level.FINE, "MIProxy.statusAsyncOutput({0})", record);
            super.statusAsyncOutput(record);
        }

        @Override
        protected void result(MIRecord record) {
            LOGGER.log(Level.FINE, "MIProxy.result({0})", record);
            switch (record.cls()) {
                case "running": {
                    this.runningLatch.countDown();
                }
            }
            this.runningCommandSemaphore.release();
            super.result(record);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(MICommand cmd, boolean waitForRunning) {
            if (waitForRunning) {
                this.waitRunning();
                this.send(cmd);
            } else {
                try {
                    this.startedLatch.await();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                LOGGER.log(Level.FINE, "MIProxy.send({0})", cmd);
                Object object = this.sendLock;
                synchronized (object) {
                    super.send(cmd);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(MICommand cmd) {
            try {
                this.startedLatch.await();
                this.runningCommandSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            LOGGER.log(Level.FINE, "MIProxy.send({0})", cmd);
            Object object = this.sendLock;
            synchronized (object) {
                super.send(cmd);
            }
        }

        @Override
        public boolean processLine(String line) {
            LOGGER.log(Level.FINER, "MIProxy.processLine({0})", line);
            return super.processLine(line);
        }

        void waitStarted() {
            try {
                this.startedLatch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        void waitRunning() {
            try {
                this.runningLatch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class CPPLiteInjector
    implements MICommandInjector {
        private final OutputStream out;

        public CPPLiteInjector(OutputStream out) {
            this.out = out;
        }

        @Override
        public synchronized void inject(String data) {
            LOGGER.log(Level.FINE, "CPPLiteInjector.inject({0})", data);
            try {
                this.out.write(data.getBytes());
                this.out.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void log(String data) {
            LOGGER.log(Level.FINE, "CPPLiteInjector.log({0})", data);
        }
    }
}

