/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.util.List;
import java.util.Objects;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public final class TestSuiteInfo {
    @NonNull
    private String suiteName;
    private String file;
    private Integer line;
    @NonNull
    private String state;
    private List<TestCaseInfo> tests;

    public TestSuiteInfo() {
        this("", "");
    }

    public TestSuiteInfo(@NonNull String suiteName, @NonNull String state) {
        this.suiteName = (String)Preconditions.checkNotNull((Object)suiteName, (String)"suiteName");
        this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
    }

    public TestSuiteInfo(@NonNull String suiteName, String file, Integer line, @NonNull String state, List<TestCaseInfo> tests) {
        this(suiteName, state);
        this.file = file;
        this.line = line;
        this.tests = tests;
    }

    @Pure
    @NonNull
    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(@NonNull String suiteName) {
        this.suiteName = (String)Preconditions.checkNotNull((Object)suiteName, (String)"suiteName");
    }

    @Pure
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Pure
    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    @Pure
    @NonNull
    public String getState() {
        return this.state;
    }

    public void setState(@NonNull String state) {
        this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
    }

    @Pure
    public List<TestCaseInfo> getTests() {
        return this.tests;
    }

    public void setTests(List<TestCaseInfo> tests) {
        this.tests = tests;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("suiteName", (Object)this.suiteName);
        b.add("file", (Object)this.file);
        b.add("line", (Object)this.line);
        b.add("state", (Object)this.state);
        b.add("tests", this.tests);
        return b.toString();
    }

    @Pure
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.suiteName);
        hash = 67 * hash + Objects.hashCode(this.file);
        hash = 67 * hash + Objects.hashCode(this.line);
        hash = 67 * hash + Objects.hashCode(this.state);
        hash = 67 * hash + Objects.hashCode(this.tests);
        return hash;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuiteInfo other = (TestSuiteInfo)obj;
        if (!Objects.equals(this.suiteName, other.suiteName)) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (!Objects.equals(this.line, other.line)) {
            return false;
        }
        if (!Objects.equals(this.state, other.state)) {
            return false;
        }
        return Objects.equals(this.tests, other.tests);
    }

    public static final class State {
        public static final String Loaded = "loaded";
        public static final String Running = "running";
        public static final String Completed = "completed";
        public static final String Passed = "passed";
        public static final String Failed = "failed";
        public static final String Skipped = "skipped";
        public static final String Errored = "errored";

        private State() {
        }
    }

    public static class TestCaseInfo {
        @NonNull
        private String id;
        @NonNull
        private String shortName;
        @NonNull
        private String fullName;
        private String file;
        private Integer line;
        @NonNull
        private String state;
        private List<String> stackTrace;

        public TestCaseInfo() {
            this("", "", "", "");
        }

        public TestCaseInfo(@NonNull String id, @NonNull String shortName, @NonNull String fullName, @NonNull String state) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id");
            this.shortName = (String)Preconditions.checkNotNull((Object)shortName, (String)"shortName");
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (String)"fullName");
            this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
        }

        public TestCaseInfo(@NonNull String id, @NonNull String shortName, @NonNull String fullName, String file, Integer line, @NonNull String state, List<String> stackTrace) {
            this(id, shortName, fullName, state);
            this.file = file;
            this.line = line;
            this.stackTrace = stackTrace;
        }

        @Pure
        @NonNull
        public String getId() {
            return this.id;
        }

        public void setId(@NonNull String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id");
        }

        @Pure
        @NonNull
        public String getShortName() {
            return this.shortName;
        }

        public void setShortName(@NonNull String shortName) {
            this.shortName = (String)Preconditions.checkNotNull((Object)shortName, (String)"shortName");
        }

        @Pure
        @NonNull
        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(@NonNull String fullName) {
            this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (String)"fullName");
        }

        @Pure
        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        @Pure
        public Integer getLine() {
            return this.line;
        }

        public void setLine(Integer line) {
            this.line = line;
        }

        @Pure
        @NonNull
        public String getState() {
            return this.state;
        }

        public void setState(@NonNull String state) {
            this.state = (String)Preconditions.checkNotNull((Object)state, (String)"state");
        }

        @Pure
        public List<String> getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(List<String> stackTrace) {
            this.stackTrace = stackTrace;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("id", (Object)this.id);
            b.add("shortName", (Object)this.shortName);
            b.add("fullName", (Object)this.fullName);
            b.add("file", (Object)this.file);
            b.add("line", (Object)this.line);
            b.add("state", (Object)this.state);
            b.add("stackTrace", this.stackTrace);
            return b.toString();
        }

        @Pure
        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.id);
            hash = 97 * hash + Objects.hashCode(this.shortName);
            hash = 97 * hash + Objects.hashCode(this.fullName);
            hash = 97 * hash + Objects.hashCode(this.file);
            hash = 97 * hash + Objects.hashCode(this.line);
            hash = 97 * hash + Objects.hashCode(this.state);
            hash = 97 * hash + Objects.hashCode(this.stackTrace);
            return hash;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestCaseInfo other = (TestCaseInfo)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            if (!Objects.equals(this.shortName, other.shortName)) {
                return false;
            }
            if (!Objects.equals(this.fullName, other.fullName)) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            if (!Objects.equals(this.line, other.line)) {
                return false;
            }
            if (!Objects.equals(this.state, other.state)) {
                return false;
            }
            return Objects.equals(this.stackTrace, other.stackTrace);
        }
    }
}

