/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class SpecializedNewObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final boolean isBuiltin;
    protected final boolean isConstructor;
    protected final boolean isGenerator;
    protected final boolean isAsyncGenerator;
    @Node.Child
    private JSTargetableNode getPrototypeNode;

    public SpecializedNewObjectNode(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        this.context = context;
        this.isBuiltin = isBuiltin;
        this.isConstructor = isConstructor;
        this.isGenerator = isGenerator;
        this.isAsyncGenerator = isAsyncGenerator;
        this.getPrototypeNode = !isBuiltin && isConstructor ? PropertyNode.createProperty(context, null, "prototype") : null;
    }

    public static SpecializedNewObjectNode create(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator) {
        return SpecializedNewObjectNodeGen.create(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator);
    }

    public static SpecializedNewObjectNode create(JSFunctionData functionData) {
        return SpecializedNewObjectNode.create(functionData.getContext(), functionData.isBuiltin(), functionData.isConstructor(), functionData.isGenerator(), functionData.isAsyncGenerator());
    }

    public final DynamicObject execute(VirtualFrame frame, DynamicObject newTarget) {
        JSDynamicObject prototype = this.getPrototypeNode != null ? this.getPrototypeNode.executeWithTarget(frame, newTarget) : Undefined.instance;
        return this.execute(newTarget, (Object)prototype);
    }

    protected abstract DynamicObject execute(DynamicObject var1, Object var2);

    protected Shape getProtoChildShape(Object prototype) {
        CompilerAsserts.neverPartOfCompilation();
        if (JSGuards.isJSObject(prototype)) {
            return JSObjectUtil.getProtoChildShape((DynamicObject)prototype, JSOrdinary.INSTANCE, this.context);
        }
        return null;
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()", "isJSObject(cachedPrototype)", "prototype == cachedPrototype"}, limit="context.getPropertyCacheLimit()")
    public DynamicObject doCachedProto(DynamicObject target, Object prototype, @Cached(value="prototype") Object cachedPrototype, @Cached(value="getProtoChildShape(prototype)") Shape shape) {
        return JSOrdinary.create(this.context, shape);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()", "isJSObject(prototype)"}, replaces={"doCachedProto"})
    @ReportPolymorphism.Megamorphic
    public DynamicObject doUncachedProto(DynamicObject target, DynamicObject prototype, @Cached(value="create()") BranchProfile slowBranch) {
        Shape shape = JSObjectUtil.getProtoChildShape(prototype, JSOrdinary.INSTANCE, this.context, slowBranch);
        return JSOrdinary.create(this.context, shape);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "context.isMultiContext()", "prototypeClass != null", "prototypeClass.isInstance(prototype)"}, limit="1")
    public DynamicObject createWithProtoCachedClass(DynamicObject target, Object prototype, @CachedLibrary(limit="3") @Cached.Shared(value="setProtoNode") DynamicObjectLibrary setProtoNode, @Cached(value="getClassIfJSObject(prototype)") Class<?> prototypeClass) {
        return this.createWithProto(target, (DynamicObject)prototypeClass.cast(prototype), setProtoNode);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "context.isMultiContext()", "isJSObject(prototype)"})
    public DynamicObject createWithProto(DynamicObject target, DynamicObject prototype, @CachedLibrary(limit="3") @Cached.Shared(value="setProtoNode") DynamicObjectLibrary setProtoNode) {
        DynamicObject object = JSOrdinary.createWithoutPrototype(this.context);
        setProtoNode.put(object, (Object)JSObject.HIDDEN_PROTO, (Object)prototype);
        return object;
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!isJSObject(prototype)"})
    public DynamicObject createDefaultProto(DynamicObject target, Object prototype) {
        JSRealm realm = JSRuntime.getFunctionRealm((Object)target, this.context);
        if (this.isAsyncGenerator) {
            return JSOrdinary.createWithRealm(this.context, this.context.getAsyncGeneratorObjectFactory(), realm);
        }
        if (this.isGenerator) {
            return JSOrdinary.createWithRealm(this.context, this.context.getGeneratorObjectFactory(), realm);
        }
        return JSOrdinary.create(this.context, realm);
    }

    @Specialization(guards={"isBuiltin", "isConstructor"})
    static DynamicObject builtinConstructor(DynamicObject target, Object proto) {
        return JSFunction.CONSTRUCT;
    }

    @Specialization(guards={"!isConstructor"})
    public DynamicObject throwNotConstructorFunctionTypeError(DynamicObject target, Object proto) {
        throw Errors.createTypeErrorNotAConstructor(target, this.context);
    }
}

