/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.terminalemulator.support.Catalog;
import org.netbeans.lib.terminalemulator.support.FindState;
import org.netbeans.lib.terminalemulator.support.FontPanel;

public final class FindBar
extends JPanel {
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private final Owner owner;
    private FindState state;
    private boolean updating = false;
    private Action closeAction;
    private Action nextAction;
    private Action prevAction;
    private JTextField findText;
    private JLabel errorLabel;
    private Color originalColor;

    public FindBar(Owner owner) {
        this.owner = owner;
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JLabel findLabel = new JLabel();
        findLabel.setText(Catalog.get("LBL_Find") + ":");
        this.findText = new JTextField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, super.getPreferredSize().height);
            }
        };
        this.originalColor = this.findText.getForeground();
        this.findText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!FindBar.this.updating) {
                    FindBar.this.state.setPattern(FindBar.this.findText.getText());
                    FindBar.this.error(FindBar.this.state.getStatus(), false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        });
        findLabel.setLabelFor(this.findText);
        this.prevAction = new PrevAction();
        JButton prevButton = new JButton(this.prevAction);
        this.adjustButton(prevButton);
        this.nextAction = new NextAction();
        JButton nextButton = new JButton(this.nextAction);
        this.adjustButton(nextButton);
        this.closeAction = new CloseAction();
        JButton closeButton = new JButton(this.closeAction);
        this.adjustButton(closeButton);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(114, 1), FindBar.getName(this.prevAction));
        inputMap.put(KeyStroke.getKeyStroke(114, 0), FindBar.getName(this.nextAction));
        inputMap.put(KeyStroke.getKeyStroke(27, 0), FindBar.getName(this.closeAction));
        ActionMap actionMap = this.getActionMap();
        actionMap.put(this.prevAction.getValue("Name"), this.prevAction);
        actionMap.put(this.nextAction.getValue("Name"), this.nextAction);
        actionMap.put(this.closeAction.getValue("Name"), this.closeAction);
        this.findText.getActionMap().put(this.nextAction.getValue("Name"), this.nextAction);
        this.findText.getInputMap().put(KeyStroke.getKeyStroke(10, 0), FindBar.getName(this.nextAction));
        this.errorLabel = new JLabel();
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(findLabel);
        this.add(this.findText);
        this.add(prevButton);
        this.add(nextButton);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.errorLabel);
        this.add(Box.createHorizontalGlue());
        this.add(closeButton);
    }

    private static String getName(Action a) {
        Object name = a.getValue("Name");
        if (name instanceof String) {
            return (String)name;
        }
        return "null";
    }

    public void setState(FindState state) {
        this.state = state;
        this.updating = true;
        try {
            if (state != null) {
                this.findText.setText(state.getPattern());
                this.error(state.getStatus(), false);
            } else {
                this.findText.setText("");
                this.error(FindState.Status.OK, false);
            }
        }
        finally {
            this.updating = false;
        }
    }

    public void requestTextFocus() {
        this.findText.requestFocus();
    }

    public FindState getState() {
        return this.state;
    }

    private void error(FindState.Status status, boolean prevNext) {
        switch (status) {
            case OK: {
                this.errorLabel.setText("");
                this.findText.setForeground(this.originalColor);
                break;
            }
            case NOTFOUND: {
                this.errorLabel.setText(Catalog.get("MSG_NotFound"));
                this.findText.setForeground(FontPanel.ERROR_COLOR);
                break;
            }
            case WILLWRAP: {
                this.errorLabel.setText(Catalog.get("MSG_OneMore"));
                this.findText.setForeground(this.originalColor);
                break;
            }
            case EMPTYPATTERN: {
                if (prevNext) {
                    this.errorLabel.setText(Catalog.get("MSG_Empty"));
                } else {
                    this.errorLabel.setText("");
                }
                this.findText.setForeground(this.originalColor);
            }
        }
    }

    private void close() {
        this.owner.close(this);
    }

    private void next() {
        if (this.state != null) {
            this.state.next();
            this.error(this.state.getStatus(), true);
        }
    }

    private void prev() {
        if (this.state != null) {
            this.state.prev();
            this.error(this.state.getStatus(), true);
        }
    }

    private void adjustButton(final JButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setMargin(BUTTON_INSETS);
        button.setFocusable(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setContentAreaFilled(true);
                    button.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        });
    }

    private final class PrevAction
    extends AbstractAction {
        public PrevAction() {
            super(Catalog.get("CTL_Previous"), new ImageIcon(FindBar.class.getResource("find_previous.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FindBar.this.prev();
        }
    }

    private final class NextAction
    extends AbstractAction {
        public NextAction() {
            super(Catalog.get("CTL_Next"), new ImageIcon(FindBar.class.getResource("find_next.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FindBar.this.next();
        }
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Catalog.get("CTL_Close"), new ImageIcon(FindBar.class.getResource("find_close.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FindBar.this.close();
        }
    }

    public static interface Owner {
        public void close(FindBar var1);
    }
}

