/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.foojay.api.discoclient.pkg.Architecture;
import io.foojay.api.discoclient.pkg.ArchiveType;
import io.foojay.api.discoclient.pkg.Bitness;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.LibCType;
import io.foojay.api.discoclient.pkg.MajorVersion;
import io.foojay.api.discoclient.pkg.OperatingSystem;
import io.foojay.api.discoclient.pkg.PackageType;
import io.foojay.api.discoclient.pkg.ReleaseStatus;
import io.foojay.api.discoclient.pkg.SemVer;
import io.foojay.api.discoclient.pkg.TermOfSupport;
import io.foojay.api.discoclient.pkg.VersionNumber;
import java.util.Objects;
import java.util.OptionalInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkg {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pkg.class);
    public static final String FIELD_ID = "id";
    public static final String FIELD_ARCHIVE_TYPE = "archive_type";
    public static final String FIELD_DISTRIBUTION = "distribution";
    public static final String FIELD_MAJOR_VERSION = "major_version";
    public static final String FIELD_JAVA_VERSION = "java_version";
    public static final String FIELD_DISTRIBUTION_VERSION = "distribution_version";
    public static final String FIELD_LATEST_BUILD_AVAILABLE = "latest_build_available";
    public static final String FIELD_RELEASE_STATUS = "release_status";
    public static final String FIELD_TERM_OF_SUPPORT = "term_of_support";
    public static final String FIELD_OPERATING_SYSTEM = "operating_system";
    public static final String FIELD_LIB_C_TYPE = "lib_c_type";
    public static final String FIELD_ARCHITECTURE = "architecture";
    public static final String FIELD_PACKAGE_TYPE = "package_type";
    public static final String FIELD_JAVAFX_BUNDLED = "javafx_bundled";
    public static final String FIELD_DIRECTLY_DOWNLOADABLE = "directly_downloadable";
    public static final String FIELD_FILENAME = "filename";
    public static final String FIELD_EPHEMERAL_ID = "ephemeral_id";
    private String id;
    private ArchiveType archiveType;
    private Distribution distribution;
    private MajorVersion majorVersion;
    private SemVer javaVersion;
    private VersionNumber distributionVersion;
    private Boolean latestBuildAvailable;
    private ReleaseStatus releaseStatus;
    private TermOfSupport termOfSupport;
    private OperatingSystem operatingSystem;
    private LibCType libcType;
    private Architecture architecture;
    private PackageType packageType;
    private Boolean javafxBundled;
    private Boolean directlyDownloadable;
    private String fileName;
    private String ephemeralId;

    public Pkg(String packageJson) {
        if (null == packageJson || packageJson.isEmpty()) {
            LOGGER.debug("Package json string cannot be null or empty.");
            throw new IllegalArgumentException("Package json string cannot be null or empty.");
        }
        Gson gson = new Gson();
        JsonObject json = (JsonObject)gson.fromJson(packageJson, JsonObject.class);
        this.id = json.has(FIELD_ID) ? json.get(FIELD_ID).getAsString() : "";
        this.distribution = json.has(FIELD_DISTRIBUTION) ? Distribution.fromText(json.get(FIELD_DISTRIBUTION).getAsString()) : Distribution.NOT_FOUND;
        this.majorVersion = json.has(FIELD_MAJOR_VERSION) ? new MajorVersion(json.get(FIELD_MAJOR_VERSION).getAsInt()) : new MajorVersion(1);
        this.javaVersion = json.has(FIELD_JAVA_VERSION) ? SemVer.fromText(json.get(FIELD_JAVA_VERSION).getAsString()).getSemVer1() : new SemVer(new VersionNumber());
        this.distributionVersion = json.has(FIELD_DISTRIBUTION) ? VersionNumber.fromText(json.get(FIELD_DISTRIBUTION_VERSION).getAsString()) : new VersionNumber();
        this.latestBuildAvailable = json.has(FIELD_LATEST_BUILD_AVAILABLE) ? json.get(FIELD_LATEST_BUILD_AVAILABLE).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.architecture = json.has(FIELD_ARCHITECTURE) ? Architecture.fromText(json.get(FIELD_ARCHITECTURE).getAsString()) : Architecture.NOT_FOUND;
        this.operatingSystem = json.has(FIELD_OPERATING_SYSTEM) ? OperatingSystem.fromText(json.get(FIELD_OPERATING_SYSTEM).getAsString()) : OperatingSystem.NOT_FOUND;
        this.libcType = json.has(FIELD_LIB_C_TYPE) ? LibCType.fromText(json.get(FIELD_LIB_C_TYPE).getAsString()) : LibCType.NOT_FOUND;
        this.packageType = json.has(FIELD_PACKAGE_TYPE) ? PackageType.fromText(json.get(FIELD_PACKAGE_TYPE).getAsString()) : PackageType.NOT_FOUND;
        this.releaseStatus = json.has(FIELD_RELEASE_STATUS) ? ReleaseStatus.fromText(json.get(FIELD_RELEASE_STATUS).getAsString()) : ReleaseStatus.NOT_FOUND;
        this.archiveType = json.has(FIELD_ARCHIVE_TYPE) ? ArchiveType.fromText(json.get(FIELD_ARCHIVE_TYPE).getAsString()) : ArchiveType.NOT_FOUND;
        this.termOfSupport = json.has(FIELD_TERM_OF_SUPPORT) ? TermOfSupport.fromText(json.get(FIELD_TERM_OF_SUPPORT).getAsString()) : TermOfSupport.NOT_FOUND;
        this.javafxBundled = json.has(FIELD_JAVAFX_BUNDLED) ? json.get(FIELD_JAVAFX_BUNDLED).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.directlyDownloadable = json.has(FIELD_DIRECTLY_DOWNLOADABLE) ? json.get(FIELD_DIRECTLY_DOWNLOADABLE).getAsBoolean() : Boolean.FALSE.booleanValue();
        this.fileName = json.has(FIELD_FILENAME) ? json.get(FIELD_FILENAME).getAsString() : "";
        this.ephemeralId = json.has(FIELD_EPHEMERAL_ID) ? json.get(FIELD_EPHEMERAL_ID).getAsString() : "";
    }

    public String getId() {
        return this.id;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public String getDistributionName() {
        return this.distribution.name();
    }

    public MajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public SemVer getJavaVersion() {
        return this.javaVersion;
    }

    public VersionNumber getDistributionVersion() {
        return this.distributionVersion;
    }

    public Boolean isLatestBuildAvailable() {
        return this.latestBuildAvailable;
    }

    public OptionalInt getFeatureVersion() {
        return this.javaVersion.getVersionNumber().getFeature();
    }

    public OptionalInt getInterimVersion() {
        return this.javaVersion.getVersionNumber().getInterim();
    }

    public OptionalInt getUpdateVersion() {
        return this.javaVersion.getVersionNumber().getUpdate();
    }

    public OptionalInt getPatchVersion() {
        return this.javaVersion.getVersionNumber().getPatch();
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public Bitness getBitness() {
        return this.architecture == Architecture.NOT_FOUND ? Bitness.NOT_FOUND : this.architecture.getBitness();
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public LibCType getLibCType() {
        return this.libcType;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public TermOfSupport getTermOfSupport() {
        return this.termOfSupport;
    }

    public Boolean isJavaFXBundled() {
        return this.javafxBundled;
    }

    public Boolean isDirectlyDownloadable() {
        return this.directlyDownloadable;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pkg pkg = (Pkg)o;
        return this.javafxBundled == pkg.javafxBundled && this.distribution.equals(pkg.distribution) && this.javaVersion.equalTo(pkg.javaVersion) && this.architecture == pkg.architecture && this.operatingSystem == pkg.operatingSystem && this.packageType == pkg.packageType && this.releaseStatus == pkg.releaseStatus && this.archiveType == pkg.archiveType && this.termOfSupport == pkg.termOfSupport && this.ephemeralId.equals(pkg.ephemeralId) && this.latestBuildAvailable == pkg.latestBuildAvailable;
    }

    public int hashCode() {
        return Objects.hash(this.distribution, this.javaVersion, this.latestBuildAvailable, this.architecture, this.operatingSystem, this.packageType, this.releaseStatus, this.archiveType, this.termOfSupport, this.javafxBundled, this.ephemeralId);
    }

    public String toString() {
        return "{\n" + "  \"" + FIELD_ID + "\"" + ":" + this.getId() + ",\n" + "  \"" + FIELD_DISTRIBUTION + "\"" + ":" + "\"" + this.distribution.name() + "\"" + ",\n" + "  \"" + FIELD_JAVA_VERSION + "\"" + ":" + "\"" + this.javaVersion.toString() + "\"" + ",\n" + "  \"" + FIELD_DISTRIBUTION_VERSION + "\"" + ":" + "\"" + this.distributionVersion + "\"" + ",\n" + "  \"" + FIELD_LATEST_BUILD_AVAILABLE + "\"" + ":" + this.latestBuildAvailable + ",\n" + "  \"" + FIELD_ARCHITECTURE + "\"" + ":" + "\"" + this.architecture.name() + "\"" + ",\n" + "  \"" + FIELD_OPERATING_SYSTEM + "\"" + ":" + "\"" + this.operatingSystem.name() + "\"" + ",\n" + "  \"" + FIELD_PACKAGE_TYPE + "\"" + ":" + "\"" + this.packageType.name() + "\"" + ",\n" + "  \"" + FIELD_RELEASE_STATUS + "\"" + ":" + "\"" + this.releaseStatus.name() + "\"" + ",\n" + "  \"" + FIELD_ARCHIVE_TYPE + "\"" + ":" + "\"" + this.archiveType.getUiString() + "\"" + ",\n" + "  \"" + FIELD_TERM_OF_SUPPORT + "\"" + ":" + "\"" + this.termOfSupport.name() + "\"" + ",\n" + "  \"" + FIELD_JAVAFX_BUNDLED + "\"" + ":" + this.javafxBundled + ",\n" + "  \"" + FIELD_FILENAME + "\"" + ":" + this.fileName + ",\n" + "  \"" + FIELD_EPHEMERAL_ID + "\"" + ":" + "\"" + this.ephemeralId + "\"" + "\n" + "}";
    }
}

