/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class GradleProject
implements Serializable,
Lookup.Provider {
    final Set<String> problems;
    final NbGradleProject.Quality quality;
    final long evaluationTime = System.currentTimeMillis();
    final Lookup lookup;
    final GradleBaseProject baseProject;

    public GradleProject(NbGradleProject.Quality quality, Set<String> problems, Collection infos) {
        this.quality = quality;
        LinkedHashSet<String> probs = new LinkedHashSet<String>();
        for (String prob : problems) {
            if (prob == null) continue;
            probs.add(prob);
        }
        this.problems = probs;
        InstanceContent ic = new InstanceContent();
        for (Object i : infos) {
            ic.add(i);
        }
        this.lookup = new AbstractLookup((AbstractLookup.Content)ic);
        this.baseProject = (GradleBaseProject)this.lookup.lookup(GradleBaseProject.class);
        assert (this.baseProject != null) : "GradleProject always shall have a GradleBaseProject in it's lookup!";
    }

    private GradleProject(NbGradleProject.Quality quality, Set<String> problems, GradleProject origin) {
        this.quality = quality;
        LinkedHashSet<String> probs = new LinkedHashSet<String>();
        for (String prob : problems) {
            if (prob == null) continue;
            probs.add(prob);
        }
        this.problems = probs;
        this.lookup = origin.lookup;
        this.baseProject = (GradleBaseProject)this.lookup.lookup(GradleBaseProject.class);
        assert (this.baseProject != null) : "GradleProject always shall have a GradleBaseProject in it's lookup!";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public Set<String> getProblems() {
        return Collections.unmodifiableSet(this.problems);
    }

    public NbGradleProject.Quality getQuality() {
        return this.quality;
    }

    public long getEvaluationTime() {
        return this.evaluationTime;
    }

    @NonNull
    public GradleBaseProject getBaseProject() {
        return this.baseProject;
    }

    public String toString() {
        return "GradleProject{quality=" + (Object)((Object)this.quality) + ", baseProject=" + this.baseProject + '}';
    }

    public final GradleProject invalidate(String ... reasons) {
        if (this.getQuality().worseThan(NbGradleProject.Quality.EVALUATED)) {
            return this;
        }
        LinkedHashSet<String> p = new LinkedHashSet<String>(Arrays.asList(reasons));
        return new GradleProject(NbGradleProject.Quality.EVALUATED, p, this);
    }
}

