/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.StayOpenPopupMenu;

public class ToggleButtonMenuItem
extends StayOpenPopupMenu.Item {
    private final JLabel label;
    private final Icon selectedIcon;
    private final Icon unselectedIcon;
    private boolean pressed;

    public ToggleButtonMenuItem(String text, Icon icon) {
        super(ToggleButtonMenuItem.sizeText(text));
        this.setLayout(null);
        this.selectedIcon = ToggleButtonMenuItem.createSelectedIcon(icon);
        this.unselectedIcon = ToggleButtonMenuItem.createUnselectedIcon(icon);
        this.label = new JLabel(this.unselectedIcon, 10);
        this.add(this.label, "West");
    }

    public void setPressed(boolean pressed) {
        if (this.pressed == pressed) {
            return;
        }
        this.pressed = pressed;
        this.label.setIcon(pressed ? this.selectedIcon : this.unselectedIcon);
        this.repaint();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = Math.max(dim.height, this.getComponent((int)0).getPreferredSize().height);
        return dim;
    }

    public void doLayout() {
        this.getComponent(0).setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    private static Icon createSelectedIcon(Icon icon) {
        JComponent c = new JToggleButton(){
            {
                this.setSelected(true);
                if (UIUtils.isAquaLookAndFeel()) {
                    this.putClientProperty("JButton.buttonType", "textured");
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (UIUtils.isOracleLookAndFeel()) {
                    Color c = UIManager.getColor("List.selectionBackground");
                    g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 140));
                    g.fillRect(1, 1, this.getWidth() - 3, this.getHeight() - 2);
                }
            }
        };
        if (UIUtils.isWindowsLookAndFeel() || UIUtils.isMetalLookAndFeel() || UIUtils.isOracleLookAndFeel()) {
            JToolBar t = new JToolBar(){
                {
                    this.setLayout(null);
                    this.setOpaque(false);
                    this.setRollover(true);
                    this.setFloatable(false);
                    this.setBorderPainted(false);
                }

                @Override
                public void setSize(int w, int h) {
                    super.setSize(w, h);
                    if (this.getComponentCount() > 0) {
                        this.getComponent(0).setBounds(0, 0, w, h);
                    }
                }
            };
            t.removeAll();
            t.add(c);
            c = t;
        }
        return ToggleButtonMenuItem.createMenuIcon(icon, c);
    }

    private static Icon createUnselectedIcon(Icon icon) {
        return ToggleButtonMenuItem.createMenuIcon(icon, null);
    }

    private static Icon createMenuIcon(Icon icon, Component decorator) {
        int h = ToggleButtonMenuItem.menuIconSize();
        int w = UIUtils.isAquaLookAndFeel() ? h + 4 : h;
        BufferedImage i = new BufferedImage(w, h, 2);
        Graphics g = i.getGraphics();
        if (decorator != null) {
            decorator.setSize(w, h);
            decorator.paint(g);
        }
        icon.paintIcon(null, g, (w - icon.getIconWidth()) / 2, (h - icon.getIconHeight()) / 2);
        g.dispose();
        return new ImageIcon(i);
    }

    private static int menuIconSize() {
        if (UIUtils.isMetalLookAndFeel()) {
            return 23;
        }
        if (UIUtils.isAquaLookAndFeel()) {
            return 26;
        }
        if (UIUtils.isGTKLookAndFeel()) {
            return 24;
        }
        if (UIUtils.isNimbus()) {
            return 25;
        }
        if (UIUtils.isOracleLookAndFeel()) {
            return 21;
        }
        return 22;
    }

    private static String sizeText(String text) {
        if (UIUtils.isMetalLookAndFeel()) {
            return "  " + text;
        }
        if (UIUtils.isAquaLookAndFeel()) {
            return "   " + text;
        }
        if (UIUtils.isGTKLookAndFeel()) {
            return " " + text;
        }
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            return "  " + text;
        }
        return text;
    }
}

