/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.gradle.actions.Bundle;

public class KeyValueTableModel
extends AbstractTableModel {
    final String keyPrefix;
    final String[] keys;
    final String[] values;

    public KeyValueTableModel(String keyPrefix, String ... keys) {
        this(keyPrefix, keys, new String[keys.length]);
        Arrays.fill(this.values, "");
    }

    public KeyValueTableModel(String keyPrefix, String[] keys, String[] values) {
        this.keyPrefix = keyPrefix;
        this.keys = keys;
        this.values = values;
    }

    @Override
    public int getRowCount() {
        return this.keys.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? Bundle.LBL_KVTM_Key() : Bundle.LBL_KVTM_Value();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return columnIndex == 0 ? this.keys[rowIndex] : this.values[rowIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.values[rowIndex] = aValue.toString();
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < this.keys.length; ++i) {
            ret.put(this.keyPrefix + this.keys[i], this.values[i]);
        }
        return ret;
    }
}

