/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.gsf.testrunner.api.NamedObject;
import org.netbeans.modules.gsf.testrunner.api.SizeRestrictedPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class GuiUtils {
    public static final String TEMPLATES_DIR = "Templates/JUnit";
    public static final String JUNIT_TEST_FRAMEWORK = "JUnit";
    public static final String TESTNG_TEST_FRAMEWORK = "TestNG";
    public static final String CHK_INTEGRATION_TESTS = "IntegrationTests";
    public static final String CHK_PUBLIC = "Public";
    public static final String CHK_PROTECTED = "Protected";
    public static final String CHK_PACKAGE = "Package";
    public static final String CHK_PACKAGE_PRIVATE_CLASSES = "PackagePrivateClasses";
    public static final String CHK_ABSTRACT_CLASSES = "AbstractImpl";
    public static final String CHK_EXCEPTION_CLASSES = "Exceptions";
    public static final String CHK_SUITES = "GenerateSuites";
    public static final String CHK_SETUP = "SetUp";
    public static final String CHK_TEARDOWN = "TearDown";
    public static final String CHK_BEFORE_CLASS = "BeforeClass";
    public static final String CHK_AFTER_CLASS = "AfterClass";
    public static final String CHK_METHOD_BODIES = "Content";
    public static final String CHK_JAVADOC = "JavaDoc";
    public static final String CHK_HINTS = "Comments";

    public static JComboBox createTemplateChooser(String defaultTemplate) {
        JComboBox<Object> comboBox;
        FileObject templatesDir = FileUtil.getConfigFile((String)TEMPLATES_DIR);
        if (templatesDir == null) {
            throw new RuntimeException("Not found: Templates/JUnit");
        }
        FileObject[] templates = templatesDir.getChildren();
        ArrayList<NamedObject> itemList = new ArrayList<NamedObject>(templates.length);
        int defaultItemIndex = -1;
        int itemIndex = 0;
        for (int i = 0; i < templates.length; ++i) {
            FileObject template = templates[i];
            if (!template.getExt().equals("java")) continue;
            itemList.add(new NamedObject((Object)template, template.getName()));
            if (defaultItemIndex == -1 && defaultTemplate != null && template.getPath().equals(defaultTemplate)) {
                defaultItemIndex = itemIndex;
            }
            ++itemIndex;
        }
        if (itemList.isEmpty()) {
            comboBox = new JComboBox();
        } else {
            comboBox = new JComboBox<Object>(itemList.toArray());
            if (defaultItemIndex != -1) {
                comboBox.setSelectedIndex(defaultItemIndex);
            }
        }
        comboBox.setEditable(false);
        return comboBox;
    }

    public static JCheckBox[] createCheckBoxes(String[] ids) {
        JCheckBox[] chkBoxes = new JCheckBox[ids.length];
        if (chkBoxes.length == 0) {
            return chkBoxes;
        }
        ResourceBundle bundle = NbBundle.getBundle(GuiUtils.class);
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            if (id == null) {
                chkBoxes[i] = null;
                continue;
            }
            JCheckBox chkBox = new JCheckBox();
            String baseName = "CommonTestsCfgOfCreate.chk" + id;
            AccessibleContext accessCtx = chkBox.getAccessibleContext();
            Mnemonics.setLocalizedText((AbstractButton)chkBox, (String)bundle.getString(baseName + ".text"));
            chkBox.setToolTipText(bundle.getString(baseName + ".toolTip"));
            accessCtx.setAccessibleName(bundle.getString(baseName + ".AN"));
            accessCtx.setAccessibleDescription(bundle.getString(baseName + ".AD"));
            chkBoxes[i] = chkBox;
        }
        return chkBoxes;
    }

    public static JComponent createChkBoxGroup(String title, JCheckBox[] elements) {
        JPanel content = new JPanel(new GridLayout(0, 1, 0, 5));
        for (int i = 0; i < elements.length; ++i) {
            content.add(elements[i]);
        }
        SizeRestrictedPanel result = new SizeRestrictedPanel((LayoutManager)new BorderLayout(), true, true);
        result.add((Component)new JLabel(title), "North");
        GuiUtils.addBorder(content, BorderFactory.createEmptyBorder(6, 12, 0, 0));
        result.add((Component)content, "Center");
        return result;
    }

    public static JTextComponent createMultilineLabel(String text) {
        return GuiUtils.createMultilineLabel(text, null);
    }

    public static JTextComponent createMultilineLabel(String text, Color color) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(false);
        textArea.setOpaque(false);
        textArea.setColumns(25);
        textArea.setDisabledTextColor(color != null ? color : new JLabel().getForeground());
        return textArea;
    }

    private static void addBorder(JComponent component, Border newBorder) {
        Border currentBorder = component.getBorder();
        if (currentBorder == null) {
            component.setBorder(newBorder);
        } else {
            component.setBorder(BorderFactory.createCompoundBorder(newBorder, currentBorder));
        }
    }
}

