/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import com.google.gson.stream.JsonWriter;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.lang.model.element.ElementKind;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class Utils {
    private static final char[] SNIPPET_ESCAPE_CHARS = new char[]{'\\', '$', '}'};

    public static SymbolKind elementKind2SymbolKind(ElementKind kind) {
        switch (kind) {
            case PACKAGE: {
                return SymbolKind.Package;
            }
            case ENUM: {
                return SymbolKind.Enum;
            }
            case CLASS: {
                return SymbolKind.Class;
            }
            case ANNOTATION_TYPE: {
                return SymbolKind.Interface;
            }
            case INTERFACE: {
                return SymbolKind.Interface;
            }
            case ENUM_CONSTANT: {
                return SymbolKind.EnumMember;
            }
            case FIELD: {
                return SymbolKind.Field;
            }
            case PARAMETER: {
                return SymbolKind.Variable;
            }
            case LOCAL_VARIABLE: {
                return SymbolKind.Variable;
            }
            case EXCEPTION_PARAMETER: {
                return SymbolKind.Variable;
            }
            case METHOD: {
                return SymbolKind.Method;
            }
            case CONSTRUCTOR: {
                return SymbolKind.Constructor;
            }
            case TYPE_PARAMETER: {
                return SymbolKind.TypeParameter;
            }
            case RESOURCE_VARIABLE: {
                return SymbolKind.Variable;
            }
            case MODULE: {
                return SymbolKind.Module;
            }
        }
        return SymbolKind.File;
    }

    public static Range treeRange(CompilationInfo info, Tree tree) {
        long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), tree);
        long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), tree);
        if (end == -1L) {
            end = start;
        }
        return new Range(Utils.createPosition(info.getCompilationUnit(), (int)start), Utils.createPosition(info.getCompilationUnit(), (int)end));
    }

    public static Position createPosition(CompilationUnitTree cut, int offset) {
        return Utils.createPosition(cut.getLineMap(), offset);
    }

    public static Position createPosition(LineMap lm, int offset) {
        return new Position((int)lm.getLineNumber(offset) - 1, (int)lm.getColumnNumber(offset) - 1);
    }

    public static Position createPosition(FileObject file, int offset) {
        try {
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
            int column = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
            return new Position(line, column);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static int getOffset(LineDocument doc, Position pos) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)doc, (int)pos.getLine()) + pos.getCharacter();
    }

    public static synchronized String toUri(FileObject file) {
        return URITranslator.getDefault().uriToLSP(file.toURI().toString());
    }

    public static synchronized FileObject fromUri(String uri) throws MalformedURLException {
        uri = URITranslator.getDefault().uriFromLSP(uri);
        return URLMapper.findFileObject((URL)URI.create(uri).toURL());
    }

    public static String escapeCompletionSnippetSpecialChars(String text) {
        if (text.isEmpty()) {
            return text;
        }
        for (char c : SNIPPET_ESCAPE_CHARS) {
            StringBuilder replaced = null;
            int lastPos = 0;
            int i = 0;
            while ((i = text.indexOf(c, i)) >= 0) {
                if (replaced == null) {
                    replaced = new StringBuilder(text.length() + 5);
                }
                replaced.append(text.substring(lastPos, i));
                replaced.append('\\');
                lastPos = i++;
            }
            if (replaced != null) {
                replaced.append(text.substring(lastPos, text.length()));
                text = replaced.toString();
            }
            replaced = null;
        }
        return text;
    }

    public static String encode2JSON(String value) {
        if (value.isEmpty()) {
            return value;
        }
        StringWriter sw = new StringWriter();
        try (JsonWriter w = new JsonWriter((Writer)sw);){
            w.beginArray();
            w.value(value);
            w.endArray();
            w.flush();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String encoded = sw.toString();
        return encoded.substring(2, encoded.length() - 2);
    }
}

