/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.editor.indent.CssIndenter;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public class CssIndentTask
implements IndentTask,
Lookup.Provider {
    private final Context context;
    private final CssIndenter indenter;
    private final Lookup lookup;

    CssIndentTask(Context context) {
        this.context = context;
        this.indenter = new CssIndenter(context);
        this.lookup = Lookups.singleton((Object)this.indenter.createFormattingContext());
    }

    public void reindent() throws BadLocationException {
        if (!this.context.isIndent()) {
            this.doFormat();
        }
        this.indenter.reindent();
        if (!this.context.isIndent()) {
            this.doTrim();
        }
    }

    private void doTrim() throws BadLocationException {
        ArrayList<Pair> whitespaceDelete = new ArrayList<Pair>();
        for (Context.Region reg : this.context.indentRegions()) {
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.document());
            List tslist = th.embeddedTokenSequences(reg.getStartOffset(), false);
            TokenSequence ts = (TokenSequence)tslist.get(tslist.size() - 1);
            ts.move(reg.getStartOffset());
            Token lastToken = null;
            while (ts.moveNext() && ts.offset() < reg.getEndOffset()) {
                if (lastToken != null && lastToken.id() == CssTokenId.WS && ts.token().id() == CssTokenId.NL) {
                    whitespaceDelete.add(Pair.of((Object)lastToken.offset(th), (Object)lastToken.length()));
                }
                lastToken = ts.token();
            }
        }
        Collections.reverse(whitespaceDelete);
        for (Pair toDelete : whitespaceDelete) {
            this.context.document().remove((Integer)toDelete.first(), (Integer)toDelete.second());
        }
    }

    private void doFormat() throws BadLocationException {
        ArrayList<Integer> newlinesMissing = new ArrayList<Integer>();
        for (Context.Region reg : this.context.indentRegions()) {
            List tslist = TokenHierarchy.get((Document)this.context.document()).embeddedTokenSequences(reg.getStartOffset(), false);
            TokenSequence ts = (TokenSequence)tslist.get(tslist.size() - 1);
            int blockLevel = this.determineBlocklevel(ts);
            ts.moveStart();
            block1: while (ts.moveNext()) {
                if (ts.token().id() == CssTokenId.LBRACE) {
                    ++blockLevel;
                    if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)CssTokenId.NL, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.COMMENT}) != null) continue;
                    while (ts.moveNext()) {
                        if (ts.token().id() == CssTokenId.WS || ts.token().id() == CssTokenId.COMMENT) continue;
                        newlinesMissing.add(ts.offset());
                        ts.movePrevious();
                        continue block1;
                    }
                    continue;
                }
                if (ts.token().id() == CssTokenId.RBRACE) {
                    --blockLevel;
                    if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)CssTokenId.NL, (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.COMMENT}) == null) {
                        newlinesMissing.add(ts.offset());
                    }
                    if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)CssTokenId.NL, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.COMMENT}) != null) continue;
                    while (ts.moveNext()) {
                        if (ts.token().id() == CssTokenId.WS || ts.token().id() == CssTokenId.COMMENT) continue;
                        newlinesMissing.add(ts.offset());
                        ts.movePrevious();
                        continue block1;
                    }
                    continue;
                }
                if (ts.token().id() != CssTokenId.SEMI || blockLevel <= 0 || LexerUtils.followsToken((TokenSequence)ts, Arrays.asList(CssTokenId.NL, CssTokenId.RBRACE), (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS, CssTokenId.COMMENT}) != null) continue;
                while (ts.moveNext()) {
                    if (ts.token().id() == CssTokenId.WS || ts.token().id() == CssTokenId.COMMENT) continue;
                    newlinesMissing.add(ts.offset());
                    ts.movePrevious();
                    continue block1;
                }
            }
        }
        for (int i = 0; i < newlinesMissing.size() - 1; ++i) {
            int currentPos = (Integer)newlinesMissing.get(i);
            int nextPos = (Integer)newlinesMissing.get(i + 1);
            String interText = this.context.document().getText(currentPos, nextPos - currentPos);
            if (!interText.trim().isEmpty()) continue;
            newlinesMissing.remove(i + 1);
        }
        Collections.reverse(newlinesMissing);
        Iterator iterator = newlinesMissing.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!this.isPositionInFormatRegions(index)) continue;
            this.context.document().insertString(index, "\n", null);
        }
    }

    private boolean isPositionInFormatRegions(int pos) {
        for (Context.Region r : this.context.indentRegions()) {
            if (r.getStartOffset() > pos || r.getEndOffset() <= pos) continue;
            return true;
        }
        return false;
    }

    private int determineBlocklevel(TokenSequence<?> ts) {
        int blockLevel = 0;
        ts.moveStart();
        if (!ts.moveNext()) {
            return 0;
        }
        List tokenSequences = TokenHierarchy.get((Document)this.context.document()).tokenSequenceList(ts.languagePath(), 0, ts.offset());
        block0: for (TokenSequence tsX : tokenSequences) {
            tsX.moveStart();
            while (tsX.moveNext()) {
                if (tsX.offset() >= ts.offset()) break block0;
                if (tsX.token().id() == CssTokenId.LBRACE) {
                    ++blockLevel;
                    continue;
                }
                if (tsX.token().id() != CssTokenId.RBRACE) continue;
                --blockLevel;
            }
        }
        return blockLevel;
    }

    public ExtraLock indentLock() {
        return null;
    }

    public Lookup getLookup() {
        return this.lookup;
    }
}

