/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.openide.util.NbPreferences;

public class PhpUnitOptions {
    private static final String PREFERENCES_PATH = "phpunit";
    private static final PhpUnitOptions INSTANCE = new PhpUnitOptions();
    private static final String PHP_UNIT_PATH = "phpUnit.path";
    private static final String SKELETON_GENERATOR_PATH = "skeletonGenerator.path";
    private volatile boolean phpUnitSearched = false;
    private volatile boolean skeletonGeneratorSearched = false;

    public static PhpUnitOptions getInstance() {
        return INSTANCE;
    }

    public String getPhpUnitPath() {
        String phpUnitPath = this.getPreferences().get(PHP_UNIT_PATH, null);
        if (phpUnitPath == null && !this.phpUnitSearched) {
            this.phpUnitSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{PREFERENCES_PATH, PhpUnit.SCRIPT_NAME_LONG, "phpunit.phar"});
            if (!scripts.isEmpty()) {
                phpUnitPath = (String)scripts.get(0);
                this.setPhpUnitPath(phpUnitPath);
            }
        }
        return phpUnitPath;
    }

    public void setPhpUnitPath(String phpUnitPath) {
        this.getPreferences().put(PHP_UNIT_PATH, phpUnitPath);
    }

    public String getSkeletonGeneratorPath() {
        String skeletonGeneratorPath = this.getPreferences().get(SKELETON_GENERATOR_PATH, null);
        if (skeletonGeneratorPath == null && !this.skeletonGeneratorSearched) {
            this.skeletonGeneratorSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"phpunit-skelgen", SkeletonGenerator.SCRIPT_NAME_LONG, "phpunit-skelgen.phar"});
            if (!scripts.isEmpty()) {
                skeletonGeneratorPath = (String)scripts.get(0);
                this.setSkeletonGeneratorPath(skeletonGeneratorPath);
            }
        }
        return skeletonGeneratorPath;
    }

    public void setSkeletonGeneratorPath(String skeletonGeneratorPath) {
        this.getPreferences().put(SKELETON_GENERATOR_PATH, skeletonGeneratorPath);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(PhpUnitOptions.class).node(PREFERENCES_PATH);
    }
}

