/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class AmbiguousComparisonHint
extends HintRule {
    private static final String HINT_ID = "Ambiguous.Comparison.Hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
        phpParseResult.getProgram().accept(checkVisitor);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.AmbiguousComparisonHintDescName();
    }

    public String getDisplayName() {
        return Bundle.AmbiguousComparisonHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class AssignmentHintFix
    implements HintFix {
        private final BaseDocument doc;
        private final InfixExpression expression;
        private static final String ASSIGNMENT = " = ";

        public AssignmentHintFix(BaseDocument doc, InfixExpression expression) {
            this.doc = doc;
            this.expression = expression;
        }

        public String getDescription() {
            return Bundle.AssignmentHintFixDisp();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            OffsetRange offsetRange = new OffsetRange(this.expression.getLeft().getEndOffset(), this.expression.getRight().getStartOffset());
            edits.replace(offsetRange.getStart(), offsetRange.getLength(), ASSIGNMENT, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class CheckVisitor
    extends DefaultTreePathVisitor {
        private final FileObject fileObject;
        private final BaseDocument doc;
        private final List<InfixExpression> expressions = new ArrayList<InfixExpression>();
        private final List<Hint> hints = new ArrayList<Hint>();

        public CheckVisitor(FileObject fileObject, BaseDocument doc) {
            this.fileObject = fileObject;
            this.doc = doc;
        }

        public List<Hint> getHints() {
            for (InfixExpression infixExpression : this.expressions) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                this.createHint(infixExpression);
            }
            return this.hints;
        }

        private void createHint(InfixExpression node) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (AmbiguousComparisonHint.this.showHint(offsetRange, this.doc)) {
                this.hints.add(new Hint((Rule)AmbiguousComparisonHint.this, Bundle.AmbiguousComparisonHintCustom(), this.fileObject, offsetRange, Collections.singletonList(new AssignmentHintFix(this.doc, node)), 500));
            }
        }

        @Override
        public void visit(InfixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            InfixExpression.OperatorType operator = node.getOperator();
            if (InfixExpression.OperatorType.IS_EQUAL.equals((Object)operator) || InfixExpression.OperatorType.IS_IDENTICAL.equals((Object)operator)) {
                this.checkPathForNode(node);
            }
            super.visit(node);
        }

        private void checkPathForNode(InfixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            List<ASTNode> path = this.getPath();
            if (path.isEmpty() || !this.isValidContext(path)) {
                this.expressions.add(node);
            }
        }

        private boolean isValidContext(List<ASTNode> path) {
            boolean result = false;
            for (ASTNode node : path) {
                if (this.isConditionalNode(node) || node instanceof Assignment || node instanceof ReturnStatement || node instanceof FunctionInvocation) {
                    result = true;
                    break;
                }
                if (!(node instanceof Block)) continue;
                result = false;
                break;
            }
            return result;
        }

        private boolean isConditionalNode(ASTNode node) {
            return node instanceof IfStatement || node instanceof WhileStatement || node instanceof DoStatement || node instanceof ForStatement || node instanceof ForEachStatement || node instanceof ConditionalExpression || node instanceof SwitchCase;
        }
    }
}

