/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.EnumSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript2.editor.Bundle;

public enum JsVersion {
    ECMA5(Bundle.LBL_ECMA5(), 5),
    ECMA6(Bundle.LBL_ECMA6(), 6),
    ECMA7(Bundle.LBL_ECMA7(), 7),
    ECMA8(Bundle.LBL_ECMA8(), 8),
    ECMA9(Bundle.LBL_ECMA9(), 9),
    ECMA10(Bundle.LBL_ECMA10(), 10),
    ECMA11(Bundle.LBL_ECMA11(), 11),
    ECMA12(Bundle.LBL_ECMA12(), 12),
    EMCANEXT(Bundle.LBL_ECMANEXT(), Integer.MAX_VALUE);

    private final String displayName;
    private final int ecmascriptEdition;

    private JsVersion(String displayName, int ecmascriptEdition) {
        this.displayName = displayName;
        this.ecmascriptEdition = ecmascriptEdition;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getEcmascriptEdition() {
        return this.ecmascriptEdition;
    }

    public static JsVersion fromEcmascriptEdition(int edition) {
        for (JsVersion v : EnumSet.allOf(JsVersion.class)) {
            if (v.getEcmascriptEdition() != edition) continue;
            return v;
        }
        return null;
    }

    @CheckForNull
    public static JsVersion fromString(String str) {
        if (str == null) {
            return null;
        }
        for (JsVersion v : EnumSet.allOf(JsVersion.class)) {
            if (!str.equals(v.name()) && !str.equals(v.getDisplayName())) continue;
            return v;
        }
        return null;
    }
}

