/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.ui.wizard.SiteTemplateWizard;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

public class SiteTemplateWizardPanel
implements WizardDescriptor.ExtendedAsynchronousValidatingPanel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor> {
    static final Logger LOGGER = Logger.getLogger(SiteTemplateWizardPanel.class.getName());
    private volatile SiteTemplateWizard siteTemplateWizard;
    private volatile WizardDescriptor wizardDescriptor;

    public SiteTemplateWizard getComponent() {
        if (this.siteTemplateWizard == null) {
            this.siteTemplateWizard = (SiteTemplateWizard)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<SiteTemplateWizard>(){

                public SiteTemplateWizard run() {
                    return new SiteTemplateWizard();
                }
            });
        }
        return this.siteTemplateWizard;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.wizard.SiteTemplateWizard");
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        SiteTemplateImplementation template = (SiteTemplateImplementation)this.wizardDescriptor.getProperty("SITE_TEMPLATE");
        if (template != null) {
            this.getComponent().preSelectSiteTemplate(template);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        this.wizardDescriptor.putProperty("SITE_TEMPLATE", (Object)this.getComponent().getSiteTemplate());
    }

    public void prepareValidation() {
        this.getComponent().lockPanel();
    }

    public void validate() throws WizardValidationException {
        String error = this.getComponent().prepareTemplate();
        if (error != null) {
            throw new WizardValidationException((JComponent)this.getComponent(), "ERROR_PREPARE", error);
        }
    }

    public void finishValidation() {
        this.getComponent().unlockPanel();
    }

    public boolean isValid() {
        String error = this.getComponent().getErrorMessage();
        if (error != null && !error.isEmpty()) {
            this.setErrorMessage(error);
            return false;
        }
        String warning = this.getComponent().getWarningMessage();
        if (warning != null && !warning.isEmpty()) {
            this.setErrorMessage(warning);
            return true;
        }
        this.setErrorMessage("");
        return true;
    }

    private void setErrorMessage(String message) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    public void addChangeListener(ChangeListener l) {
        this.getComponent().addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.getComponent().removeChangeListener(l);
    }

    public boolean isFinishPanel() {
        return true;
    }
}

