/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.Closeable;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerContainerDetail;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.node.Refreshable;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class StatefulDockerContainer
implements Refreshable,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(StatefulDockerContainer.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(StatefulDockerContainer.class);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DockerEvent.Listener listener = new DockerEvent.Listener(){

        public void onEvent(DockerEvent event) {
            if (event.getId().equals(StatefulDockerContainer.this.container.getId()) && event.getStatus() != DockerEvent.Status.DESTROY && event.getStatus() != DockerEvent.Status.UNTAG) {
                DockerContainer.Status fresh = StatefulDockerContainer.getStatus(event);
                if (fresh != null) {
                    StatefulDockerContainer.this.update(fresh);
                } else {
                    StatefulDockerContainer.this.refresh();
                }
            }
        }
    };
    private final DockerContainer container;
    private DockerContainerDetail detail;
    private boolean attached;

    public StatefulDockerContainer(DockerContainer container) {
        this.container = container;
        this.detail = new DockerContainerDetail(container.getName(), container.getStatus(), false, false);
        this.attach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attach() {
        StatefulDockerContainer statefulDockerContainer = this;
        synchronized (statefulDockerContainer) {
            if (!this.attached) {
                this.container.getInstance().addContainerListener(this.listener);
                this.attached = true;
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public DockerContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerContainerDetail getDetail() {
        StatefulDockerContainer statefulDockerContainer = this;
        synchronized (statefulDockerContainer) {
            return this.detail;
        }
    }

    @Override
    public void refresh() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                DockerAction action = new DockerAction(StatefulDockerContainer.this.container.getInstance());
                try {
                    StatefulDockerContainer.this.update(action.getDetail(StatefulDockerContainer.this.container));
                }
                catch (DockerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        StatefulDockerContainer statefulDockerContainer = this;
        synchronized (statefulDockerContainer) {
            if (this.attached) {
                this.container.getInstance().removeContainerListener(this.listener);
                this.attached = false;
            }
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.container);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatefulDockerContainer other = (StatefulDockerContainer)obj;
        return Objects.equals(this.container, other.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(DockerContainer.Status status) {
        StatefulDockerContainer statefulDockerContainer = this;
        synchronized (statefulDockerContainer) {
            this.detail = new DockerContainerDetail(this.detail.getName(), status, this.detail.isStdin(), this.detail.isTty());
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(DockerContainerDetail value) {
        StatefulDockerContainer statefulDockerContainer = this;
        synchronized (statefulDockerContainer) {
            this.detail = value;
        }
        this.changeSupport.fireChange();
    }

    private static DockerContainer.Status getStatus(DockerEvent event) {
        DockerEvent.Status status = event.getStatus();
        switch (status) {
            case DIE: {
                return DockerContainer.Status.STOPPED;
            }
            case START: {
                return DockerContainer.Status.RUNNING;
            }
            case PAUSE: {
                return DockerContainer.Status.PAUSED;
            }
            case UNPAUSE: {
                return DockerContainer.Status.RUNNING;
            }
        }
        return null;
    }
}

