/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.breakpoints;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.NbBreakpoint;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;

public final class NbBreakpointsRequestHandler {
    public static final String CAUGHT_EXCEPTION_FILTER_NAME = "caught";
    public static final String UNCAUGHT_EXCEPTION_FILTER_NAME = "uncaught";
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase().startsWith("win");

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments arguments, DebugAdapterContext context) {
        String drivePrefix;
        CompletableFuture<SetBreakpointsResponse> resultFuture = new CompletableFuture<SetBreakpointsResponse>();
        if (context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(resultFuture, "Empty debug session.", ResponseErrorCode.InvalidParams);
            return resultFuture;
        }
        Source source = arguments.getSource();
        String clientPath = source.getPath();
        if (IS_WINDOWS && (drivePrefix = FilenameUtils.getPrefix((String)clientPath)) != null && drivePrefix.length() >= 2 && Character.isLowerCase(drivePrefix.charAt(0)) && drivePrefix.charAt(1) == ':') {
            clientPath = Character.toUpperCase(clientPath.charAt(0)) + clientPath.substring(1);
        }
        String sourcePath = null;
        if (clientPath != null) {
            sourcePath = context.getDebuggerPath(clientPath.trim());
        }
        if (sourcePath == null || sourcePath.isEmpty()) {
            ErrorUtilities.completeExceptionally(resultFuture, String.format("Failed to setBreakpoint, unresolved path '%s'.", clientPath), ResponseErrorCode.InvalidParams);
            return resultFuture;
        }
        sourcePath = URITranslator.getDefault().uriFromLSP(sourcePath);
        ArrayList<Breakpoint> res = new ArrayList<Breakpoint>();
        NbBreakpoint[] toAdds = this.convertClientBreakpointsToDebugger(source, sourcePath, arguments.getBreakpoints(), context);
        NbBreakpoint[] added = context.getBreakpointManager().setBreakpoints(NbBreakpointsRequestHandler.decodeURI(sourcePath), toAdds, arguments.getSourceModified());
        for (int i = 0; i < arguments.getBreakpoints().length; ++i) {
            if (toAdds[i] == added[i]) {
                added[i].install();
            } else {
                if (toAdds[i].getHitCount() != added[i].getHitCount()) {
                    added[i].setHitCount(toAdds[i].getHitCount());
                }
                if (!StringUtils.equals((CharSequence)toAdds[i].getLogMessage(), (CharSequence)added[i].getLogMessage())) {
                    added[i].setLogMessage(toAdds[i].getLogMessage());
                }
                if (!StringUtils.equals((CharSequence)toAdds[i].getCondition(), (CharSequence)added[i].getCondition())) {
                    added[i].setCondition(toAdds[i].getCondition());
                }
            }
            res.add(added[i].convertDebuggerBreakpointToClient());
        }
        SetBreakpointsResponse response = new SetBreakpointsResponse();
        response.setBreakpoints(res.toArray(new Breakpoint[res.size()]));
        resultFuture.complete(response);
        return resultFuture;
    }

    private static String decodeURI(String uri) {
        try {
            return URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return uri;
        }
    }

    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments arguments, DebugAdapterContext context) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        if (context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(resultFuture, "Empty debug session.", ResponseErrorCode.InvalidParams);
            return resultFuture;
        }
        Object[] filters = arguments.getFilters();
        boolean notifyCaught = ArrayUtils.contains((Object[])filters, (Object)CAUGHT_EXCEPTION_FILTER_NAME);
        boolean notifyUncaught = ArrayUtils.contains((Object[])filters, (Object)UNCAUGHT_EXCEPTION_FILTER_NAME);
        context.getBreakpointManager().setExceptionBreakpoints(notifyCaught, notifyUncaught);
        return CompletableFuture.completedFuture(null);
    }

    private NbBreakpoint[] convertClientBreakpointsToDebugger(Source source, String sourceFile, SourceBreakpoint[] sourceBreakpoints, DebugAdapterContext context) {
        int n = sourceBreakpoints.length;
        int[] lines = new int[n];
        for (int i = 0; i < n; ++i) {
            lines[i] = context.getDebuggerLine(sourceBreakpoints[i].getLine());
        }
        NbBreakpoint[] breakpoints = new NbBreakpoint[n];
        for (int i = 0; i < n; ++i) {
            int hitCount = 0;
            try {
                hitCount = Integer.parseInt(sourceBreakpoints[i].getHitCondition());
            }
            catch (NumberFormatException e) {
                hitCount = 0;
            }
            breakpoints[i] = new NbBreakpoint(source, sourceFile, lines[i], hitCount, sourceBreakpoints[i].getCondition(), sourceBreakpoints[i].getLogMessage(), context);
        }
        return breakpoints;
    }
}

