/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.common;

import com.google.common.base.Optional;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.common.ClientBuilderBase;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegionalClientBuilder<B extends RegionalClientBuilder, C>
extends ClientBuilderBase<B, C> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionalClientBuilder.class);

    public RegionalClientBuilder(Service service) {
        super(service);
    }

    public B region(Region region) {
        Optional<String> endpoint = region.getEndpoint(this.service);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + this.service + " is not known in region " + region);
        }
        this.endpoint((String)endpoint.get());
        return (B)this;
    }

    public B region(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            return this.region(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(this.service, regionId);
            return (B)((RegionalClientBuilder)this.endpoint(endpoint));
        }
    }
}

