/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SharedArrayBufferPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import java.nio.ByteBuffer;

public final class SharedArrayBufferPrototypeBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new SharedArrayBufferPrototypeBuiltins();

    protected SharedArrayBufferPrototypeBuiltins() {
        super("SharedArrayBuffer.prototype");
        this.defineFunction("slice", 2, (context, builtin) -> SharedArrayBufferPrototypeBuiltinsFactory.JSSharedArrayBufferSliceNodeGen.create(context, builtin, SharedArrayBufferPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context)));
    }

    public static abstract class JSSharedArrayBufferSliceNode
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferAbstractSliceNode {
        private final BranchProfile errorBranch = BranchProfile.create();

        public JSSharedArrayBufferSliceNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        private DynamicObject constructNewSharedArrayBuffer(DynamicObject thisObj, int newLen) {
            DynamicObject defaultConstructor = this.getContext().getRealm().getSharedArrayBufferConstructor();
            DynamicObject constr = this.getArraySpeciesConstructorNode().speciesConstructor(thisObj, defaultConstructor);
            return (DynamicObject)this.getArraySpeciesConstructorNode().construct(constr, newLen);
        }

        private void checkErrors(DynamicObject resObj, DynamicObject thisObj, int newLen) {
            if (!JSSharedArrayBuffer.isJSSharedArrayBuffer(resObj)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("SharedArrayBuffer expected");
            }
            if (resObj == thisObj) {
                this.errorBranch.enter();
                throw Errors.createTypeError("SameValue(new, O) is forbidden");
            }
            if (JSSharedArrayBuffer.getDirectByteBuffer(resObj).capacity() < newLen) {
                this.errorBranch.enter();
                throw Errors.createTypeError("insufficient length constructed");
            }
        }

        @Specialization(guards={"!isJSSharedArrayBuffer(thisObj)"})
        protected static DynamicObject error(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        @Specialization(guards={"isJSSharedArrayBuffer(thisObj)"})
        protected DynamicObject sliceSharedDirect(DynamicObject thisObj, int begin, int end) {
            ByteBuffer byteBuffer = JSSharedArrayBuffer.getDirectByteBuffer(thisObj);
            int byteLength = JSArrayBuffer.getDirectByteLength(thisObj);
            int clampedBegin = JSSharedArrayBufferSliceNode.clampIndex(begin, 0, byteLength);
            int clampedEnd = JSSharedArrayBufferSliceNode.clampIndex(end, clampedBegin, byteLength);
            int newLen = clampedEnd - clampedBegin;
            DynamicObject resObj = this.constructNewSharedArrayBuffer(thisObj, newLen);
            this.checkErrors(resObj, thisObj, newLen);
            ByteBuffer resBuffer = JSArrayBuffer.getDirectByteBuffer(resObj);
            Boundaries.byteBufferPutSlice(resBuffer, 0, byteBuffer, clampedBegin, clampedEnd);
            return resObj;
        }

        @Specialization(guards={"isJSSharedArrayBuffer(thisObj)"})
        protected DynamicObject sliceSharedDirect(DynamicObject thisObj, Object begin0, Object end0) {
            int len = JSSharedArrayBuffer.getDirectByteBuffer(thisObj).capacity();
            int begin = this.getStart(begin0, len);
            int end = this.getEnd(end0, len);
            return this.sliceSharedDirect(thisObj, begin, end);
        }
    }
}

