/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDTD;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.spec.DTD;

public class TreeDTD
extends AbstractTreeDTD
implements TreeDocumentRoot,
TreeDTDRoot {
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENCODING = "encoding";
    private TreeEventManager eventManager;
    private String version;
    private String encoding;

    public TreeDTD(String version, String encoding) throws InvalidArgumentException {
        this.checkVersion(version);
        this.checkEncoding(encoding);
        this.checkHeader(version, encoding);
        this.version = version;
        this.encoding = encoding;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::init: encoding = " + this.encoding);
        }
        this.eventManager = new TreeEventManager();
    }

    public TreeDTD() throws InvalidArgumentException {
        this(null, null);
    }

    protected TreeDTD(TreeDTD dtd, boolean deep) {
        super(dtd, deep);
        this.version = dtd.version;
        this.encoding = dtd.encoding;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::init [copy]: encoding = " + this.encoding);
        }
        this.eventManager = new TreeEventManager(dtd.eventManager);
    }

    @Override
    public Object clone(boolean deep) {
        return new TreeDTD(this, deep);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeDTD peer = (TreeDTD)object;
        if (!Util.equals(this.getVersion(), peer.getVersion())) {
            return false;
        }
        return Util.equals(this.getEncoding(), peer.getEncoding());
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeDTD peer = (TreeDTD)treeObject;
        try {
            this.setVersionImpl(peer.getVersion());
            this.setEncodingImpl(peer.getEncoding());
        }
        catch (Exception exc) {
            throw new CannotMergeException(treeObject, exc);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    private final void setVersionImpl(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        this.firePropertyChange(PROP_VERSION, oldVersion, newVersion);
    }

    @Override
    public final void setVersion(String newVersion) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.version, newVersion)) {
            return;
        }
        this.checkReadOnly();
        this.checkVersion(newVersion);
        this.checkHeader(newVersion, this.encoding);
        this.setVersionImpl(newVersion);
    }

    protected final void checkVersion(String version) throws InvalidArgumentException {
        TreeUtilities.checkDTDVersion(version);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    private final void setEncodingImpl(String newEncoding) {
        String oldEncoding = this.encoding;
        this.encoding = newEncoding;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDTD::setEncodingImpl: encoding = " + this.encoding);
        }
        this.firePropertyChange(PROP_ENCODING, oldEncoding, newEncoding);
    }

    @Override
    public final void setEncoding(String newEncoding) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.encoding, newEncoding)) {
            return;
        }
        this.checkReadOnly();
        this.checkEncoding(newEncoding);
        this.checkHeader(this.version, newEncoding);
        this.setEncodingImpl(newEncoding);
    }

    protected final void checkEncoding(String encoding) throws InvalidArgumentException {
        TreeUtilities.checkDTDEncoding(encoding);
    }

    public final void setHeader(String newVersion, String newEncoding) throws ReadOnlyException, InvalidArgumentException {
        boolean setEncoding;
        boolean setVersion = !Util.equals(this.version, newVersion);
        boolean bl = setEncoding = !Util.equals(this.encoding, newEncoding);
        if (!setVersion && !setEncoding) {
            return;
        }
        this.checkReadOnly();
        if (setVersion) {
            this.checkVersion(newVersion);
        }
        if (setEncoding) {
            this.checkEncoding(newEncoding);
        }
        this.checkHeader(newVersion, newEncoding);
        if (setVersion) {
            this.setVersionImpl(newVersion);
        }
        if (setEncoding) {
            this.setEncodingImpl(newEncoding);
        }
    }

    protected final void checkHeader(String version, String encoding) throws InvalidArgumentException {
        if (version != null && encoding == null) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_dtd_header"), new NullPointerException());
        }
    }

    @Override
    public TreeEventManager getRootEventManager() {
        return this.eventManager;
    }

    @Override
    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDTD.ChildListContentManager {
        protected ChildListContentManager() {
        }

        @Override
        public TreeNode getOwnerNode() {
            return TreeDTD.this;
        }

        @Override
        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(DTD.Child.class, obj);
        }
    }
}

