/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import org.netbeans.tax.TreeAttlistDecl;
import org.netbeans.tax.TreeAttlistDeclAttributeDef;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeCharacterReference;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeConditionalSection;
import org.netbeans.tax.TreeDTD;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeDocumentFragment;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeEntityDecl;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNotationDecl;
import org.netbeans.tax.TreeParameterEntityReference;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.io.TreeOutputResult;
import org.netbeans.tax.io.TreeWriter;
import org.netbeans.tax.spec.AttlistDecl;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.CDATASection;
import org.netbeans.tax.spec.CharacterReference;
import org.netbeans.tax.spec.Comment;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.ElementDecl;
import org.netbeans.tax.spec.EntityDecl;
import org.netbeans.tax.spec.GeneralEntityReference;
import org.netbeans.tax.spec.NotationDecl;
import org.netbeans.tax.spec.ParameterEntityReference;
import org.netbeans.tax.spec.ProcessingInstruction;
import org.netbeans.tax.spec.Text;

public class TreeStreamResult
implements TreeOutputResult {
    private TreeStreamWriter writer;

    public TreeStreamResult(OutputStream outputStream) {
        this.writer = new TreeStreamWriter(outputStream);
    }

    public TreeStreamResult(StringWriter writer) {
        this.writer = new TreeStreamWriter(writer);
    }

    public TreeStreamResult(PipedWriter writer) {
        this.writer = new TreeStreamWriter(writer);
    }

    @Override
    public final TreeWriter getWriter(TreeDocumentRoot document) {
        this.writer.setDocument(document);
        return this.writer;
    }

    public static final class TreeStreamWriter
    implements TreeWriter,
    AttlistDecl.Writer,
    Attribute.Writer,
    CDATASection.Writer,
    CharacterReference.Writer,
    Comment.Writer,
    ConditionalSection.Writer,
    DocumentFragment.Writer,
    Document.Writer,
    DocumentType.Writer,
    DTD.Writer,
    ElementDecl.Writer,
    Element.Writer,
    EntityDecl.Writer,
    GeneralEntityReference.Writer,
    NotationDecl.Writer,
    ParameterEntityReference.Writer,
    ProcessingInstruction.Writer,
    Text.Writer {
        private static final char LESS_THAN = '<';
        private static final char GREAT_THAN = '>';
        private static final char AMPERSAND = '&';
        private static final char SEMICOLON = ';';
        private static final char APOSTROPHE = '\'';
        private static final char QUOTE = '\"';
        private static final char PER_CENT = '%';
        private static final char ASSIGN = '=';
        private static final char BRACKET_LEFT = '[';
        private static final char SPACE = ' ';
        private static final String PI_START = "<?";
        private static final String PI_END = "?>";
        private static final String COMMENT_START = "<!--";
        private static final String COMMENT_END = "-->";
        private static final String ELEMENT_EMPTY_END = " />";
        private static final String ELEMENT_END_START = "</";
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String DOCTYPE_START = "<!DOCTYPE ";
        private static final String DOCTYPE_INTERN_END = "]]>";
        private static final String CHAR_REF_START = "&#";
        private static final String CHAR_REF_HEX_START = "&#x";
        private static final String ELEMENT_DECL_START = "<!ELEMENT ";
        private static final String ATTLIST_DECL_START = "<!ATTLIST ";
        private static final String ENTITY_DECL_START = "<!ENTITY ";
        private static final String NOTATION_DECL_START = "<!NOTATION ";
        private static final String XML_HEADER = "<?xml ";
        private static final String XML_VERSION = "version";
        private static final String XML_ENCODING = "encoding";
        private static final String XML_STANDALONE = "standalone";
        private static final String PUBLIC = "PUBLIC ";
        private static final String SYSTEM = "SYSTEM ";
        private OutputStream outputStream;
        private Writer writer;
        private TreeDocumentRoot document;
        private int indent = 0;
        private int indent_step = 4;

        public TreeStreamWriter(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public TreeStreamWriter(StringWriter writer) {
            this.writer = writer;
        }

        public TreeStreamWriter(PipedWriter writer) {
            this.writer = writer;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public void setDocument(TreeDocumentRoot document) {
            this.document = document;
        }

        @Override
        public void writeDocument() throws TreeException {
            String encoding = this.document.getEncoding();
            if (this.outputStream != null) {
                try {
                    if (encoding != null) {
                        encoding = TreeUtilities.iana2java(encoding);
                    }
                    this.writer = encoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, encoding);
                }
                catch (UnsupportedEncodingException exc) {
                    throw new TreeException(exc);
                }
            }
            this.writeNode((TreeNode)((Object)this.document));
            try {
                this.writer.flush();
            }
            catch (IOException ex) {
                throw new TreeException(ex);
            }
        }

        public void writeNode(TreeNode node) throws TreeException {
            if (node instanceof TreeAttlistDecl) {
                this.writeAttlistDecl((TreeAttlistDecl)node);
            } else if (node instanceof TreeAttribute) {
                this.writeAttribute((TreeAttribute)node);
            } else if (node instanceof TreeCDATASection) {
                this.writeCDATASection((TreeCDATASection)node);
            } else if (node instanceof TreeCharacterReference) {
                this.writeCharacterReference((TreeCharacterReference)node);
            } else if (node instanceof TreeComment) {
                this.writeComment((TreeComment)node);
            } else if (node instanceof TreeConditionalSection) {
                this.writeConditionalSection((TreeConditionalSection)node);
            } else if (node instanceof TreeDocumentFragment) {
                this.writeDocumentFragment((TreeDocumentFragment)node);
            } else if (node instanceof TreeDocument) {
                this.writeDocument((TreeDocument)node);
            } else if (node instanceof TreeDocumentType) {
                this.writeDocumentType((TreeDocumentType)node);
            } else if (node instanceof TreeDTD) {
                this.writeDTD((TreeDTD)node);
            } else if (node instanceof TreeElementDecl) {
                this.writeElementDecl((TreeElementDecl)node);
            } else if (node instanceof TreeElement) {
                this.writeElement((TreeElement)node);
            } else if (node instanceof TreeEntityDecl) {
                this.writeEntityDecl((TreeEntityDecl)node);
            } else if (node instanceof TreeGeneralEntityReference) {
                this.writeGeneralEntityReference((TreeGeneralEntityReference)node);
            } else if (node instanceof TreeNotationDecl) {
                this.writeNotationDecl((TreeNotationDecl)node);
            } else if (node instanceof TreeParameterEntityReference) {
                this.writeParameterEntityReference((TreeParameterEntityReference)node);
            } else if (node instanceof TreeProcessingInstruction) {
                this.writeProcessingInstruction((TreeProcessingInstruction)node);
            } else if (node instanceof TreeText) {
                this.writeText((TreeText)node);
            }
        }

        @Override
        public void writeAttlistDecl(TreeAttlistDecl attlistDecl) throws TreeException {
            StringBuffer sb = new StringBuffer();
            sb.append(ATTLIST_DECL_START).append(attlistDecl.getElementName());
            TreeNamedObjectMap attrdefs = attlistDecl.getAttributeDefs();
            for (TreeAttlistDeclAttributeDef attrDef : attrdefs) {
                sb.append("\n\t").append(attrDef.getName()).append(' ');
                if (attrDef.getType() != 8) {
                    sb.append(attrDef.getTypeName()).append(' ');
                }
                if (attrDef.getType() == 8 || attrDef.getType() == 9) {
                    sb.append(attrDef.getEnumeratedTypeString()).append(' ');
                }
                if (attrDef.getDefaultType() != 0) {
                    sb.append(attrDef.getDefaultTypeName()).append(' ');
                }
                if (attrDef.getDefaultType() != 3 && attrDef.getDefaultType() != 0) continue;
                sb.append("\"").append(attrDef.getDefaultValue()).append("\"");
            }
            sb.append('>');
            this.write(sb.toString());
        }

        @Override
        public void writeAttribute(TreeAttribute attribute) throws TreeException {
            if (!attribute.isSpecified()) {
                return;
            }
            this.write(this.createValueString(attribute.getQName(), attribute.getNonNormalizedValue()));
        }

        @Override
        public void writeCDATASection(TreeCDATASection cdataSection) throws TreeException {
            String cdataData = cdataSection.getData();
            String cdataString = MessageFormat.format("<![CDATA[{0}]]>", cdataData);
            this.write(cdataString);
        }

        @Override
        public void writeCharacterReference(TreeCharacterReference characterReference) throws TreeException {
            String refName = characterReference.getName();
            String refString = MessageFormat.format("&{0};", refName);
            this.write(refString);
        }

        @Override
        public void writeComment(TreeComment comment) throws TreeException {
            String comName = comment.getData();
            String comString = MessageFormat.format("<!--{0}-->", comName);
            this.write(comString);
        }

        @Override
        public void writeConditionalSection(TreeConditionalSection conditionalSection) throws TreeException {
            if (conditionalSection.isInclude()) {
                this.write("<![ INCLUDE [\n");
                this.writeObjectList(conditionalSection);
            } else {
                this.write("<![ IGNORE [");
                this.write(conditionalSection.getIgnoredContent());
            }
            this.write("]]>");
        }

        @Override
        public void writeDocumentFragment(TreeDocumentFragment documentFragment) throws TreeException {
            StringBuffer sb = new StringBuffer();
            StringBuffer header = null;
            if (documentFragment.getVersion() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(this.createValueString(XML_VERSION, documentFragment.getVersion())).append(' ');
            }
            if (documentFragment.getEncoding() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(this.createValueString(XML_ENCODING, documentFragment.getEncoding()));
            }
            if (header != null) {
                sb.append(XML_HEADER).append(header).append(PI_END);
            }
            this.write(sb.toString() + "\n\n");
            this.indent -= this.indent_step;
            this.writeObjectList(documentFragment);
        }

        @Override
        public void writeDocument(TreeDocument document) throws TreeException {
            StringBuffer sb = new StringBuffer();
            StringBuffer header = null;
            if (document.getVersion() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(this.createValueString(XML_VERSION, document.getVersion()));
            }
            if (document.getEncoding() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(' ').append(this.createValueString(XML_ENCODING, document.getEncoding()));
            }
            if (document.getStandalone() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(' ').append(this.createValueString(XML_STANDALONE, document.getStandalone()));
            }
            if (header != null) {
                sb.append(XML_HEADER).append(header).append(PI_END);
            }
            this.write(sb.toString() + "\n");
            this.indent -= this.indent_step;
            this.writeObjectList(document);
        }

        @Override
        public void writeDocumentType(TreeDocumentType documentType) throws TreeException {
            StringBuffer sb = new StringBuffer();
            sb.append(DOCTYPE_START).append(documentType.getElementName());
            if (documentType.getPublicId() != null) {
                sb.append(' ').append(PUBLIC);
                sb.append(this.createQuoteString(documentType.getPublicId())).append(' ');
                String systemId = documentType.getSystemId();
                sb.append(this.createQuoteString(systemId == null ? "" : systemId));
            } else if (documentType.getSystemId() != null) {
                sb.append(' ').append(SYSTEM);
                sb.append(this.createQuoteString(documentType.getSystemId()));
            }
            this.write(sb.toString());
            if (documentType.hasChildNodes()) {
                this.write(" [");
                try {
                    if (documentType == null) {
                        return;
                    }
                    Class<?> klass = documentType.getClass();
                    Field field = klass.getDeclaredField("internalDTDText");
                    field.setAccessible(true);
                    String internalDTDText = (String)field.get(documentType);
                    if (internalDTDText != null) {
                        this.write(internalDTDText);
                    } else {
                        this.write("\n");
                        this.writeObjectList(documentType);
                    }
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.write("\n");
                    this.writeObjectList(documentType);
                }
                this.write("]");
            }
            this.write('>');
        }

        @Override
        public void writeDTD(TreeDTD dtd) throws TreeException {
            StringBuffer sb = new StringBuffer();
            StringBuffer header = null;
            if (dtd.getVersion() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(this.createValueString(XML_VERSION, dtd.getVersion())).append(' ');
            }
            if (dtd.getEncoding() != null) {
                if (header == null) {
                    header = new StringBuffer();
                }
                header.append(this.createValueString(XML_ENCODING, dtd.getEncoding()));
            }
            if (header != null) {
                sb.append(XML_HEADER).append(header).append(PI_END);
            }
            this.write(sb.toString() + "\n\n");
            this.indent -= this.indent_step;
            this.writeObjectList(dtd);
        }

        @Override
        public void writeElementDecl(TreeElementDecl elementDecl) throws TreeException {
            StringBuffer sb = new StringBuffer();
            sb.append(ELEMENT_DECL_START).append(elementDecl.getName()).append(' ');
            sb.append(elementDecl.getContentType().toString());
            sb.append('>');
            this.write(sb.toString());
        }

        @Override
        public void writeElement(TreeElement element) throws TreeException {
            String elemName = element.getQName();
            this.write("<" + elemName);
            for (TreeAttribute attr : element.getAttributes()) {
                if (!attr.isSpecified()) continue;
                this.write(' ');
                this.writeAttribute(attr);
            }
            if (element.isEmpty()) {
                this.write("/>");
            } else {
                this.write(">");
                this.writeObjectList(element);
                String endElemString = MessageFormat.format("</{0}>", elemName);
                this.write(endElemString);
            }
        }

        @Override
        public void writeEntityDecl(TreeEntityDecl entityDecl) throws TreeException {
            String entParam = entityDecl.isParameter() ? "% " : "";
            String entName = entityDecl.getName();
            String entType = "";
            switch (entityDecl.getType()) {
                case 1: {
                    entType = "\"" + entityDecl.getInternalText() + "\"";
                    break;
                }
                case 2: {
                    entType = this.createExternalIdString(entityDecl.getPublicId(), entityDecl.getSystemId());
                    break;
                }
                case 3: {
                    entType = this.createExternalIdString(entityDecl.getPublicId(), entityDecl.getSystemId()) + " NDATA " + entityDecl.getNotationName();
                }
            }
            String entString = MessageFormat.format("<!ENTITY {0}{1} {2}>", entParam, entName, entType);
            this.write(entString);
        }

        @Override
        public void writeGeneralEntityReference(TreeGeneralEntityReference generalEntityReference) throws TreeException {
            String refName = generalEntityReference.getName();
            String refString = MessageFormat.format("&{0};", refName);
            this.write(refString);
        }

        @Override
        public void writeNotationDecl(TreeNotationDecl notationDecl) throws TreeException {
            String notName = notationDecl.getName();
            String notSysId = notationDecl.getSystemId();
            String notPubId = notationDecl.getPublicId();
            String notExtId = this.createExternalIdString(notPubId, notSysId);
            String notString = MessageFormat.format("<!NOTATION {0} {1}>", notName, notExtId);
            this.write(notString);
        }

        @Override
        public void writeParameterEntityReference(TreeParameterEntityReference parameterEntityReference) throws TreeException {
            String refName = parameterEntityReference.getName();
            String refString = MessageFormat.format("%{0};", refName);
            this.write(refString);
        }

        @Override
        public void writeProcessingInstruction(TreeProcessingInstruction processingInstruction) throws TreeException {
            String piTarget = processingInstruction.getTarget();
            String piData = processingInstruction.getData();
            String piString = MessageFormat.format("<?{0} {1}?>", piTarget, piData);
            this.write(piString);
        }

        @Override
        public void writeText(TreeText text) throws TreeException {
            String textString = text.getData();
            this.write(textString);
        }

        private void write(String string) throws TreeException {
            try {
                this.writer.write(string);
            }
            catch (IOException exc) {
                throw new TreeException(exc);
            }
        }

        private void write(char ch) throws TreeException {
            try {
                this.writer.write(ch);
            }
            catch (IOException exc) {
                throw new TreeException(exc);
            }
        }

        private void startIndent() throws TreeException {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.indent; ++i) {
                sb.append(' ');
            }
            try {
                this.writer.write(sb.toString());
            }
            catch (IOException exc) {
                throw new TreeException(exc);
            }
        }

        private void endIndent() throws TreeException {
            this.write("\n");
        }

        private void writeObjectList(TreeParentNode parentNode) throws TreeException {
            this.indent += this.indent_step;
            boolean notElementChild = !(parentNode instanceof TreeElement);
            boolean documentChild = parentNode instanceof TreeDocument;
            for (TreeNode node : parentNode.getChildNodes()) {
                if (notElementChild) {
                    this.startIndent();
                }
                this.writeNode(node);
                if (!notElementChild) continue;
                this.endIndent();
            }
            this.indent -= this.indent_step;
        }

        private String createValueString(String name, String value) {
            String valueString = MessageFormat.format("{0}={1}", name, this.createQuoteString(value));
            return valueString;
        }

        private String createQuoteString(String value) {
            Character quote = Character.valueOf('\"');
            if (value.indexOf(34) != -1) {
                quote = Character.valueOf('\'');
            }
            return this.createQuoteString(value, quote);
        }

        private String createQuoteString(String value, Character quote) {
            String valueString = MessageFormat.format("{1}{0}{1}", value, quote);
            return valueString;
        }

        private String createExternalIdString(String publicId, String systemId) {
            String externId = publicId == null ? MessageFormat.format("SYSTEM {0}", this.createQuoteString(systemId)) : (systemId == null ? MessageFormat.format("PUBLIC {0}", this.createQuoteString(publicId)) : MessageFormat.format("PUBLIC {0} {1}", this.createQuoteString(publicId), this.createQuoteString(systemId)));
            return externId;
        }
    }
}

