/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;

public abstract class AbstractValueAdaptingCache
implements Cache {
    private final boolean allowNullValues;

    protected AbstractValueAdaptingCache(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        return this.toValueWrapper(this.lookup(key));
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(key));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    protected abstract Object lookup(Object var1);

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NullValue.INSTANCE) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NullValue.INSTANCE;
        }
        return userValue;
    }

    protected Cache.ValueWrapper toValueWrapper(Object storeValue) {
        return storeValue != null ? new SimpleValueWrapper(this.fromStoreValue(storeValue)) : null;
    }
}

