/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.InternalVSEMetaDataImpl;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;

public class QueryBuilderMetaData {
    private Map<String, List<String>> importKcTable = new Hashtable<String, List<String>>();
    private Map<String, String> allColumnNames = null;
    private VisualSQLEditorMetaData metadata;
    private QueryBuilder queryBuilder;
    private boolean DEBUG = false;

    QueryBuilderMetaData(VisualSQLEditorMetaData vseMetaData, QueryBuilder queryBuilder) {
        this.metadata = vseMetaData;
        this.queryBuilder = queryBuilder;
    }

    QueryBuilderMetaData(DatabaseConnection dbconn, QueryBuilder queryBuilder) {
        this.metadata = new InternalVSEMetaDataImpl(dbconn);
        this.queryBuilder = queryBuilder;
    }

    boolean isSchemaName(String schemaName) {
        List<String> schemas = this.getSchemas();
        if (schemas.contains(schemaName)) {
            Log.getLogger().finest(" found schema name " + schemaName);
            return true;
        }
        return false;
    }

    boolean isTableName(String tableName) {
        try {
            String x = this.checkTableName(tableName);
            if (x != null) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    boolean isColumnName(String columnName) {
        try {
            if (this.allColumnNames == null) {
                this.getAllColumnNames();
            }
            return this.allColumnNames.containsKey(columnName);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    void getAllColumnNames() throws SQLException {
        this.allColumnNames = new Hashtable<String, String>(500);
        List<List<String>> tables = this.getTables();
        for (List<String> table : tables) {
            List<String> columns = this.getColumns(table.get(0), table.get(1));
            for (String column : columns) {
                this.allColumnNames.put(column, column);
            }
        }
    }

    String checkTableName(String tableName) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkTableName", tableName);
        if (tableName == null || tableName.length() < 1) {
            return tableName;
        }
        String[] descrip = QueryBuilderMetaData.parseTableName(tableName);
        String paramSchemaName = descrip[0];
        String paramTableName = descrip[1];
        if (paramSchemaName != null) {
            return this.checkFullTableName(tableName);
        }
        String returnTable = null;
        List<String> tables = this.getAllTables();
        for (String fullNameDb : tables) {
            String tableNameDb = QueryBuilderMetaData.parseTableName(fullNameDb)[1];
            if (!tableNameDb.equalsIgnoreCase(paramTableName)) continue;
            returnTable = fullNameDb;
            break;
        }
        if (returnTable == null) {
            String fullAliasTableName = this.queryBuilder.getQueryModel().getFullTableName(paramTableName);
            if (fullAliasTableName != null && tableName.equals(fullAliasTableName)) {
                return null;
            }
            if (fullAliasTableName != null) {
                return this.checkTableName(fullAliasTableName);
            }
        }
        if (returnTable != null) {
            this.getColumnNames(returnTable);
        }
        return returnTable;
    }

    String checkFullTableName(String fullTableName) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkFullTableName", fullTableName);
        String returnTable = null;
        if (QueryBuilderMetaData.parseTableName(fullTableName)[0] == null) {
            return this.checkTableName(fullTableName);
        }
        List<String> tables = this.getAllTables();
        for (String fullNameDb : tables) {
            if (!fullNameDb.equalsIgnoreCase(fullTableName)) continue;
            returnTable = fullNameDb;
            break;
        }
        if (returnTable != null) {
            this.getColumnNames(returnTable);
        }
        return returnTable;
    }

    String checkColumnName(String tableName, String columnName) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkColumnName", new Object[]{tableName, columnName});
        String tabName = this.checkTableName(tableName);
        List<String> columns = this.getColumnNames(tabName);
        if (columns == null) {
            return null;
        }
        for (int k = 0; k < columns.size(); ++k) {
            String columnDB = columns.get(k);
            if (columnName.equals(columnDB)) {
                return columnName;
            }
            if (!columnName.equalsIgnoreCase(columnDB)) continue;
            return columnDB;
        }
        return null;
    }

    boolean checkColumnNameForTable(Column col, String tableName) {
        boolean retVal;
        block7: {
            List<String> cols;
            String checkedTable;
            String columnName;
            block6: {
                columnName = col.getColumnName();
                Log.getLogger().entering("QueryBuilderMetaData", "checkColumnNameForTable", tableName);
                String fullTableNameFromAlias = this.queryBuilder.getQueryModel().getFullTableName(tableName);
                if (fullTableNameFromAlias != null) {
                    tableName = fullTableNameFromAlias;
                }
                retVal = false;
                try {
                    checkedTable = this.checkTableName(tableName);
                    if (checkedTable == null) {
                        return false;
                    }
                    cols = this.getColumnNames(checkedTable);
                }
                catch (SQLException sqle) {
                    Log.getLogger().finest("  ** problems getting metadata " + sqle.getMessage());
                    return false;
                }
                if (!"*".equals(columnName)) break block6;
                retVal = true;
                if (fullTableNameFromAlias != null || checkedTable.equals(col.getTableSpec())) break block7;
                col.setTableSpec(col.getTableSpec(), checkedTable);
                Log.getLogger().finest(" adjust table to " + checkedTable);
                break block7;
            }
            for (int icnt = 0; icnt < cols.size(); ++icnt) {
                if (!columnName.equalsIgnoreCase(cols.get(icnt))) continue;
                col.setColumnName(col.getColumnName(), cols.get(icnt));
                Log.getLogger().finest(" adjust colname to " + cols.get(icnt));
                if (col.getTableSpec() == null) {
                    col.setTableSpec(col.getTableSpec(), checkedTable);
                    Log.getLogger().finest(" adjust table to " + checkedTable);
                }
                retVal = true;
                break;
            }
        }
        Log.getLogger().finest("checkColumnNameForTable found=" + retVal);
        return retVal;
    }

    boolean checkTableColumnName(Column col) throws SQLException {
        String tableSpec = col.getTableSpec();
        String tableName = col.getFullTableName();
        String colName = col.getColumnName();
        Log.getLogger().finest("checkTableColunName col=*, notable  tableSpec = " + tableSpec + " tableName = " + tableName + " . " + colName);
        if ("*".equals(col.getColumnName()) && tableSpec == null) {
            Log.getLogger().finest("checkTableColunName col=*, notable ");
            return true;
        }
        String checkedTableName = this.checkTableName(tableSpec);
        String fullTableNameFromAlias = null;
        fullTableNameFromAlias = this.queryBuilder.getQueryModel().getFullTableName(tableSpec);
        Log.getLogger().finest("checkTableColumnName called.  checkedTableName = " + checkedTableName + " fullTableNameFromAlias = " + fullTableNameFromAlias);
        if (checkedTableName == null) {
            return false;
        }
        if (fullTableNameFromAlias != null && !fullTableNameFromAlias.equalsIgnoreCase(tableSpec)) {
            if (this.DEBUG) {
                System.out.println("setColumnTableName called.  checkedTableName = " + checkedTableName + " tableSpec = " + tableSpec + " fullTableNameFromAlias = " + fullTableNameFromAlias + "\n");
            }
            col.setColumnTableName(checkedTableName);
            col.setColumnCorrName(tableSpec);
        } else if (!checkedTableName.equals(tableName)) {
            if (this.DEBUG) {
                System.out.println("setTableSpec called.  checkedTableName = " + checkedTableName + "\n");
            }
            col.setTableSpec(tableName, checkedTableName);
        }
        String columnName = col.getColumnName();
        if (columnName.equals("*")) {
            return true;
        }
        String checkedColumnName = this.checkColumnName(checkedTableName, columnName);
        if (this.DEBUG) {
            System.out.println("column Name = " + columnName + "\nchecked column Name = " + checkedColumnName + "\n");
        }
        if (checkedColumnName == null) {
            return false;
        }
        if (!checkedColumnName.equals(columnName)) {
            if (this.DEBUG) {
                System.out.println("set column name called. oldColumnName = " + columnName + " newColumnName = " + checkedColumnName + "\n");
            }
            col.setColumnName(columnName, checkedColumnName);
        }
        return true;
    }

    List<String> getAllTables() throws SQLException {
        List<List<String>> tables = this.getTables();
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> fullTable : tables) {
            String schema = fullTable.get(0);
            String table = fullTable.get(1);
            result.add(schema == null || schema.equals("") ? table : schema + "." + table);
        }
        return result;
    }

    List<String> getImportedKeyColumns(String fullTableName) throws SQLException {
        List<String> keys = this.importKcTable.get(fullTableName);
        if (keys != null) {
            return keys;
        }
        String[] tb = QueryBuilderMetaData.parseTableName(fullTableName);
        List<List<String>> importedKeys = this.getImportedKeys(tb[0], tb[1]);
        keys = new ArrayList<String>();
        for (List<String> key : importedKeys) {
            keys.add(key.get(1));
        }
        this.importKcTable.put(fullTableName, keys);
        return keys;
    }

    List getForeignKeys(String fullTableName) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "getForeignKeys", fullTableName);
        String[] tableSpec = QueryBuilderMetaData.parseTableName(fullTableName);
        List<List<String>> keys = this.getImportedKeys(tableSpec[0], tableSpec[1]);
        keys.addAll(this.getExportedKeys(tableSpec[0], tableSpec[1]));
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (List<String> key : keys) {
            result.add(key.toArray());
        }
        return result;
    }

    String[] findForeignKey(String oldFullTableName, String newFullTableName, List foreignKeys) {
        Log.getLogger().entering("QueryBuilderMetaData", "findForeignKey", new Object[]{oldFullTableName, newFullTableName});
        if (foreignKeys != null) {
            for (int i = 0; i < foreignKeys.size(); ++i) {
                String[] key = (String[])foreignKeys.get(i);
                if ((!key[0].equalsIgnoreCase(newFullTableName) || !key[2].equalsIgnoreCase(oldFullTableName)) && (!key[0].equalsIgnoreCase(oldFullTableName) || !key[2].equalsIgnoreCase(newFullTableName))) continue;
                return (String[])foreignKeys.get(i);
            }
        }
        Log.getLogger().finest("No key found");
        return null;
    }

    String[] findForeignKey(String fullTableName1, String colName1, String fullTableName2, String colName2) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "findForeignKey", new Object[]{fullTableName1, colName1, fullTableName1, colName2});
        List foreignKeys = this.getForeignKeys(fullTableName1);
        if (foreignKeys != null) {
            for (int i = 0; i < foreignKeys.size(); ++i) {
                String[] key = (String[])foreignKeys.get(i);
                if ((!key[0].equalsIgnoreCase(fullTableName1) || !key[1].equalsIgnoreCase(colName1) || !key[2].equalsIgnoreCase(fullTableName2) || !key[3].equalsIgnoreCase(colName2)) && (!key[0].equalsIgnoreCase(fullTableName2) || !key[1].equalsIgnoreCase(colName2) || !key[2].equalsIgnoreCase(fullTableName1) || !key[3].equalsIgnoreCase(colName1))) continue;
                return (String[])foreignKeys.get(i);
            }
        }
        Log.getLogger().finest("No key found");
        return null;
    }

    public void getColumnNames(String fullTableName, List columnNames) {
        try {
            columnNames.addAll(this.getColumnNames(fullTableName));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public List<String> getColumnNames(String fullTableName) throws SQLException {
        String[] tb = QueryBuilderMetaData.parseTableName(fullTableName);
        return this.getColumns(tb[0], tb[1]);
    }

    List getPrimaryKeys(String fullTableName) throws SQLException {
        String tableName;
        Log.getLogger().entering("QueryBuilderMetaData", "getPrimaryKeys", fullTableName);
        String schemaName = null;
        String[] table = QueryBuilderMetaData.parseTableName(fullTableName);
        if (table.length > 1) {
            schemaName = table[0];
            tableName = table[1];
        } else {
            tableName = table[0];
        }
        return this.getPrimaryKeys(schemaName, tableName);
    }

    List<String> getSchemas() {
        return this.metadata.getSchemas();
    }

    List<List<String>> getTables() throws SQLException {
        return this.metadata.getTables();
    }

    List<String> getPrimaryKeys(String schema, String table) throws SQLException {
        return this.metadata.getPrimaryKeys(schema, table);
    }

    List<List<String>> getImportedKeys(String schema, String table) throws SQLException {
        return this.metadata.getImportedKeys(schema, table);
    }

    List<List<String>> getExportedKeys(String schema, String table) throws SQLException {
        return this.metadata.getExportedKeys(schema, table);
    }

    List<String> getColumns(String schema, String table) throws SQLException {
        return this.metadata.getColumns(schema, table);
    }

    public String getIdentifierQuoteString() {
        try {
            return this.metadata.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            return "";
        }
    }

    void checkDatabaseConnection() throws SQLException {
    }

    private static String[] parseTableName(String fullTableName) {
        String[] retVal = new String[2];
        String[] table = fullTableName.split("\\.");
        if (table.length > 1) {
            retVal[0] = table[0];
            retVal[1] = table[1];
        } else {
            retVal[0] = null;
            retVal[1] = table[0];
        }
        return retVal;
    }
}

