/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.SecurityPermission;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public final class PolicyContext {
    private static ThreadLocal<String> threadLocalContextID = new ThreadLocal();
    private static ThreadLocal<Object> threadLocalHandlerData = new ThreadLocal();
    private static Map<String, PolicyContextHandler> handlerTable = new ConcurrentHashMap<String, PolicyContextHandler>();

    private PolicyContext() {
    }

    public static void setContextID(String contextID) {
        PolicyContext.checkSetPolicyPermission();
        threadLocalContextID.set(contextID);
    }

    public static String getContextID() {
        return threadLocalContextID.get();
    }

    public static void setHandlerData(Object data) {
        PolicyContext.checkSetPolicyPermission();
        threadLocalHandlerData.set(data);
    }

    public static void registerHandler(String key, PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        if (handler == null || key == null) {
            throw new IllegalArgumentException("invalid (null) key or handler");
        }
        if (!handler.supports(key)) {
            throw new IllegalArgumentException("handler does not support key");
        }
        PolicyContext.checkSetPolicyPermission();
        if (handlerTable.containsKey(key) && !replace) {
            throw new IllegalArgumentException("handler exists");
        }
        handlerTable.put(key, handler);
    }

    public static Set getHandlerKeys() {
        return handlerTable.keySet();
    }

    public static Object getContext(String key) throws PolicyContextException {
        if (key == null) {
            throw new IllegalArgumentException("invalid key");
        }
        PolicyContextHandler handler = handlerTable.get(key);
        if (handler == null || !handler.supports(key)) {
            throw new IllegalArgumentException("unknown handler key");
        }
        PolicyContext.checkSetPolicyPermission();
        return handler.getContext(key, threadLocalHandlerData.get());
    }

    private static void checkSetPolicyPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
    }
}

