/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.Objects;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;

public final class ArtifactSpec<T> {
    private final VersionKind kind;
    private final String type;
    private final String groupId;
    private final String artifactId;
    private final String versionSpec;
    private final String classifier;
    private final boolean optional;
    private final FileObject localFile;
    final T data;

    ArtifactSpec(VersionKind kind, String groupId, String artifactId, String versionSpec, String type, String classifier, boolean optional, FileObject localFile, T impl) {
        this.kind = kind;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.versionSpec = versionSpec;
        this.classifier = classifier;
        this.optional = optional;
        this.data = impl;
        this.type = type;
        this.localFile = localFile;
    }

    public T getData() {
        return this.data;
    }

    public FileObject getLocalFile() {
        return this.localFile;
    }

    public VersionKind getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionSpec() {
        return this.versionSpec;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode((Object)this.kind);
        hash = 79 * hash + Objects.hashCode(this.type);
        hash = 79 * hash + Objects.hashCode(this.groupId);
        hash = 79 * hash + Objects.hashCode(this.artifactId);
        hash = 79 * hash + Objects.hashCode(this.versionSpec);
        hash = 79 * hash + Objects.hashCode(this.classifier);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactSpec other = (ArtifactSpec)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.versionSpec, other.versionSpec)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        return this.kind == other.kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("%s:%s:%s", this.getGroupId(), this.getArtifactId(), this.getVersionSpec() == null ? "" : this.getVersionSpec()));
        if (this.classifier != null) {
            sb.append(":").append(this.classifier);
        }
        if (this.type != null) {
            sb.append("[").append(this.type).append("]");
        }
        if (this.optional) {
            sb.append("?");
        }
        return sb.toString();
    }

    public T getProjectData() {
        return this.data;
    }

    public static <V> ArtifactSpec<V> createVersionSpec(@NonNull String groupId, @NonNull String artifactId, @NullAllowed String type, @NullAllowed String classifier, @NonNull String versionSpec, boolean optional, @NullAllowed FileObject localFile, @NonNull V data) {
        return new ArtifactSpec<V>(VersionKind.REGULAR, groupId, artifactId, versionSpec, type, classifier, optional, localFile, data);
    }

    public static <V> ArtifactSpec<V> createSnapshotSpec(@NonNull String groupId, @NonNull String artifactId, @NullAllowed String type, @NullAllowed String classifier, @NonNull String versionSpec, boolean optional, @NullAllowed FileObject localFile, @NonNull V data) {
        return new ArtifactSpec<V>(VersionKind.SNAPSHOT, groupId, artifactId, versionSpec, type, classifier, optional, localFile, data);
    }

    public static enum VersionKind {
        REGULAR,
        SNAPSHOT;

    }
}

