/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.CloudChildFactory;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class OCINode
extends AbstractNode {
    private RefreshListener refreshListener;
    private final OCIItem item;
    private final CloudChildFactory factory;

    public OCINode(OCIItem item) {
        this(new CloudChildFactory(item), item, Lookups.fixed((Object[])new Object[]{item}));
    }

    private OCINode(CloudChildFactory factory, OCIItem item, Lookup lookup) {
        super(Children.create((ChildFactory)factory, (boolean)true), lookup);
        this.setName(item.getName());
        this.item = item;
        this.factory = factory;
        this.refreshListener = new RefreshListener();
        item.addChangeListener(this.refreshListener);
    }

    public OCINode(OCIItem item, Children children) {
        super(children, Lookups.fixed((Object[])new Object[]{item}));
        this.setName(item.getName());
        this.item = item;
        this.factory = null;
        this.refreshListener = new RefreshListener();
        item.addChangeListener(this.refreshListener);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> result = new ArrayList<Action>();
        String path = this.item.getKey().getPath();
        String provider = path.substring(0, path.indexOf("/"));
        List commonActions = Utilities.actionsForPath((String)String.format("Cloud/%s/Common/Actions", provider));
        for (Action commonAction : commonActions) {
            if (!commonAction.isEnabled()) continue;
            result.add(commonAction);
        }
        result.addAll(Utilities.actionsForPath((String)String.format("Cloud/%s/Actions", this.item.getKey().getPath())));
        return result.toArray(new Action[0]);
    }

    public void refresh() {
        this.factory.refreshKeys();
    }

    public Node.Handle getHandle() {
        return super.getHandle();
    }

    private final class RefreshListener
    implements ChangeListener {
        private RefreshListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            OCINode.this.refresh();
        }
    }
}

