/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CloudAutonomousVmCluster {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="lastUpdateHistoryEntryId")
    private final String lastUpdateHistoryEntryId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Double dataStorageSizeInTBs;
    @JsonProperty(value="dataStorageSizeInGBs")
    private final Double dataStorageSizeInGBs;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="ocpuCount")
    private final Float ocpuCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="availableCpus")
    private final Float availableCpus;
    @JsonProperty(value="reclaimableCpus")
    private final Float reclaimableCpus;
    @JsonProperty(value="availableContainerDatabases")
    private final Integer availableContainerDatabases;
    @JsonProperty(value="totalContainerDatabases")
    private final Integer totalContainerDatabases;
    @JsonProperty(value="availableAutonomousDataStorageSizeInTBs")
    private final Double availableAutonomousDataStorageSizeInTBs;
    @JsonProperty(value="autonomousDataStorageSizeInTBs")
    private final Double autonomousDataStorageSizeInTBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
    private final Integer memoryPerOracleComputeUnitInGBs;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).description(this.description).availabilityDomain(this.availabilityDomain).subnetId(this.subnetId).nsgIds(this.nsgIds).lastUpdateHistoryEntryId(this.lastUpdateHistoryEntryId).lifecycleState(this.lifecycleState).displayName(this.displayName).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).lifecycleDetails(this.lifecycleDetails).hostname(this.hostname).domain(this.domain).cloudExadataInfrastructureId(this.cloudExadataInfrastructureId).shape(this.shape).nodeCount(this.nodeCount).dataStorageSizeInTBs(this.dataStorageSizeInTBs).dataStorageSizeInGBs(this.dataStorageSizeInGBs).cpuCoreCount(this.cpuCoreCount).ocpuCount(this.ocpuCount).memorySizeInGBs(this.memorySizeInGBs).licenseModel(this.licenseModel).lastMaintenanceRunId(this.lastMaintenanceRunId).nextMaintenanceRunId(this.nextMaintenanceRunId).freeformTags(this.freeformTags).definedTags(this.definedTags).availableCpus(this.availableCpus).reclaimableCpus(this.reclaimableCpus).availableContainerDatabases(this.availableContainerDatabases).totalContainerDatabases(this.totalContainerDatabases).availableAutonomousDataStorageSizeInTBs(this.availableAutonomousDataStorageSizeInTBs).autonomousDataStorageSizeInTBs(this.autonomousDataStorageSizeInTBs).dbNodeStorageSizeInGBs(this.dbNodeStorageSizeInGBs).memoryPerOracleComputeUnitInGBs(this.memoryPerOracleComputeUnitInGBs);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public String getLastUpdateHistoryEntryId() {
        return this.lastUpdateHistoryEntryId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Double getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public Double getDataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Float getOcpuCount() {
        return this.ocpuCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Float getAvailableCpus() {
        return this.availableCpus;
    }

    public Float getReclaimableCpus() {
        return this.reclaimableCpus;
    }

    public Integer getAvailableContainerDatabases() {
        return this.availableContainerDatabases;
    }

    public Integer getTotalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public Double getAvailableAutonomousDataStorageSizeInTBs() {
        return this.availableAutonomousDataStorageSizeInTBs;
    }

    public Double getAutonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public Integer getMemoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudAutonomousVmCluster)) {
            return false;
        }
        CloudAutonomousVmCluster other = (CloudAutonomousVmCluster)o;
        Integer this$nodeCount = this.getNodeCount();
        Integer other$nodeCount = other.getNodeCount();
        if (this$nodeCount == null ? other$nodeCount != null : !((Object)this$nodeCount).equals(other$nodeCount)) {
            return false;
        }
        Double this$dataStorageSizeInTBs = this.getDataStorageSizeInTBs();
        Double other$dataStorageSizeInTBs = other.getDataStorageSizeInTBs();
        if (this$dataStorageSizeInTBs == null ? other$dataStorageSizeInTBs != null : !((Object)this$dataStorageSizeInTBs).equals(other$dataStorageSizeInTBs)) {
            return false;
        }
        Double this$dataStorageSizeInGBs = this.getDataStorageSizeInGBs();
        Double other$dataStorageSizeInGBs = other.getDataStorageSizeInGBs();
        if (this$dataStorageSizeInGBs == null ? other$dataStorageSizeInGBs != null : !((Object)this$dataStorageSizeInGBs).equals(other$dataStorageSizeInGBs)) {
            return false;
        }
        Integer this$cpuCoreCount = this.getCpuCoreCount();
        Integer other$cpuCoreCount = other.getCpuCoreCount();
        if (this$cpuCoreCount == null ? other$cpuCoreCount != null : !((Object)this$cpuCoreCount).equals(other$cpuCoreCount)) {
            return false;
        }
        Float this$ocpuCount = this.getOcpuCount();
        Float other$ocpuCount = other.getOcpuCount();
        if (this$ocpuCount == null ? other$ocpuCount != null : !((Object)this$ocpuCount).equals(other$ocpuCount)) {
            return false;
        }
        Integer this$memorySizeInGBs = this.getMemorySizeInGBs();
        Integer other$memorySizeInGBs = other.getMemorySizeInGBs();
        if (this$memorySizeInGBs == null ? other$memorySizeInGBs != null : !((Object)this$memorySizeInGBs).equals(other$memorySizeInGBs)) {
            return false;
        }
        Float this$availableCpus = this.getAvailableCpus();
        Float other$availableCpus = other.getAvailableCpus();
        if (this$availableCpus == null ? other$availableCpus != null : !((Object)this$availableCpus).equals(other$availableCpus)) {
            return false;
        }
        Float this$reclaimableCpus = this.getReclaimableCpus();
        Float other$reclaimableCpus = other.getReclaimableCpus();
        if (this$reclaimableCpus == null ? other$reclaimableCpus != null : !((Object)this$reclaimableCpus).equals(other$reclaimableCpus)) {
            return false;
        }
        Integer this$availableContainerDatabases = this.getAvailableContainerDatabases();
        Integer other$availableContainerDatabases = other.getAvailableContainerDatabases();
        if (this$availableContainerDatabases == null ? other$availableContainerDatabases != null : !((Object)this$availableContainerDatabases).equals(other$availableContainerDatabases)) {
            return false;
        }
        Integer this$totalContainerDatabases = this.getTotalContainerDatabases();
        Integer other$totalContainerDatabases = other.getTotalContainerDatabases();
        if (this$totalContainerDatabases == null ? other$totalContainerDatabases != null : !((Object)this$totalContainerDatabases).equals(other$totalContainerDatabases)) {
            return false;
        }
        Double this$availableAutonomousDataStorageSizeInTBs = this.getAvailableAutonomousDataStorageSizeInTBs();
        Double other$availableAutonomousDataStorageSizeInTBs = other.getAvailableAutonomousDataStorageSizeInTBs();
        if (this$availableAutonomousDataStorageSizeInTBs == null ? other$availableAutonomousDataStorageSizeInTBs != null : !((Object)this$availableAutonomousDataStorageSizeInTBs).equals(other$availableAutonomousDataStorageSizeInTBs)) {
            return false;
        }
        Double this$autonomousDataStorageSizeInTBs = this.getAutonomousDataStorageSizeInTBs();
        Double other$autonomousDataStorageSizeInTBs = other.getAutonomousDataStorageSizeInTBs();
        if (this$autonomousDataStorageSizeInTBs == null ? other$autonomousDataStorageSizeInTBs != null : !((Object)this$autonomousDataStorageSizeInTBs).equals(other$autonomousDataStorageSizeInTBs)) {
            return false;
        }
        Integer this$dbNodeStorageSizeInGBs = this.getDbNodeStorageSizeInGBs();
        Integer other$dbNodeStorageSizeInGBs = other.getDbNodeStorageSizeInGBs();
        if (this$dbNodeStorageSizeInGBs == null ? other$dbNodeStorageSizeInGBs != null : !((Object)this$dbNodeStorageSizeInGBs).equals(other$dbNodeStorageSizeInGBs)) {
            return false;
        }
        Integer this$memoryPerOracleComputeUnitInGBs = this.getMemoryPerOracleComputeUnitInGBs();
        Integer other$memoryPerOracleComputeUnitInGBs = other.getMemoryPerOracleComputeUnitInGBs();
        if (this$memoryPerOracleComputeUnitInGBs == null ? other$memoryPerOracleComputeUnitInGBs != null : !((Object)this$memoryPerOracleComputeUnitInGBs).equals(other$memoryPerOracleComputeUnitInGBs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        if (this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain)) {
            return false;
        }
        String this$subnetId = this.getSubnetId();
        String other$subnetId = other.getSubnetId();
        if (this$subnetId == null ? other$subnetId != null : !this$subnetId.equals(other$subnetId)) {
            return false;
        }
        List<String> this$nsgIds = this.getNsgIds();
        List<String> other$nsgIds = other.getNsgIds();
        if (this$nsgIds == null ? other$nsgIds != null : !((Object)this$nsgIds).equals(other$nsgIds)) {
            return false;
        }
        String this$lastUpdateHistoryEntryId = this.getLastUpdateHistoryEntryId();
        String other$lastUpdateHistoryEntryId = other.getLastUpdateHistoryEntryId();
        if (this$lastUpdateHistoryEntryId == null ? other$lastUpdateHistoryEntryId != null : !this$lastUpdateHistoryEntryId.equals(other$lastUpdateHistoryEntryId)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeUpdated = this.getTimeUpdated();
        Date other$timeUpdated = other.getTimeUpdated();
        if (this$timeUpdated == null ? other$timeUpdated != null : !((Object)this$timeUpdated).equals(other$timeUpdated)) {
            return false;
        }
        String this$lifecycleDetails = this.getLifecycleDetails();
        String other$lifecycleDetails = other.getLifecycleDetails();
        if (this$lifecycleDetails == null ? other$lifecycleDetails != null : !this$lifecycleDetails.equals(other$lifecycleDetails)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$cloudExadataInfrastructureId = this.getCloudExadataInfrastructureId();
        String other$cloudExadataInfrastructureId = other.getCloudExadataInfrastructureId();
        if (this$cloudExadataInfrastructureId == null ? other$cloudExadataInfrastructureId != null : !this$cloudExadataInfrastructureId.equals(other$cloudExadataInfrastructureId)) {
            return false;
        }
        String this$shape = this.getShape();
        String other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        LicenseModel this$licenseModel = this.getLicenseModel();
        LicenseModel other$licenseModel = other.getLicenseModel();
        if (this$licenseModel == null ? other$licenseModel != null : !((Object)((Object)this$licenseModel)).equals((Object)other$licenseModel)) {
            return false;
        }
        String this$lastMaintenanceRunId = this.getLastMaintenanceRunId();
        String other$lastMaintenanceRunId = other.getLastMaintenanceRunId();
        if (this$lastMaintenanceRunId == null ? other$lastMaintenanceRunId != null : !this$lastMaintenanceRunId.equals(other$lastMaintenanceRunId)) {
            return false;
        }
        String this$nextMaintenanceRunId = this.getNextMaintenanceRunId();
        String other$nextMaintenanceRunId = other.getNextMaintenanceRunId();
        if (this$nextMaintenanceRunId == null ? other$nextMaintenanceRunId != null : !this$nextMaintenanceRunId.equals(other$nextMaintenanceRunId)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $nodeCount = this.getNodeCount();
        result = result * 59 + ($nodeCount == null ? 43 : ((Object)$nodeCount).hashCode());
        Double $dataStorageSizeInTBs = this.getDataStorageSizeInTBs();
        result = result * 59 + ($dataStorageSizeInTBs == null ? 43 : ((Object)$dataStorageSizeInTBs).hashCode());
        Double $dataStorageSizeInGBs = this.getDataStorageSizeInGBs();
        result = result * 59 + ($dataStorageSizeInGBs == null ? 43 : ((Object)$dataStorageSizeInGBs).hashCode());
        Integer $cpuCoreCount = this.getCpuCoreCount();
        result = result * 59 + ($cpuCoreCount == null ? 43 : ((Object)$cpuCoreCount).hashCode());
        Float $ocpuCount = this.getOcpuCount();
        result = result * 59 + ($ocpuCount == null ? 43 : ((Object)$ocpuCount).hashCode());
        Integer $memorySizeInGBs = this.getMemorySizeInGBs();
        result = result * 59 + ($memorySizeInGBs == null ? 43 : ((Object)$memorySizeInGBs).hashCode());
        Float $availableCpus = this.getAvailableCpus();
        result = result * 59 + ($availableCpus == null ? 43 : ((Object)$availableCpus).hashCode());
        Float $reclaimableCpus = this.getReclaimableCpus();
        result = result * 59 + ($reclaimableCpus == null ? 43 : ((Object)$reclaimableCpus).hashCode());
        Integer $availableContainerDatabases = this.getAvailableContainerDatabases();
        result = result * 59 + ($availableContainerDatabases == null ? 43 : ((Object)$availableContainerDatabases).hashCode());
        Integer $totalContainerDatabases = this.getTotalContainerDatabases();
        result = result * 59 + ($totalContainerDatabases == null ? 43 : ((Object)$totalContainerDatabases).hashCode());
        Double $availableAutonomousDataStorageSizeInTBs = this.getAvailableAutonomousDataStorageSizeInTBs();
        result = result * 59 + ($availableAutonomousDataStorageSizeInTBs == null ? 43 : ((Object)$availableAutonomousDataStorageSizeInTBs).hashCode());
        Double $autonomousDataStorageSizeInTBs = this.getAutonomousDataStorageSizeInTBs();
        result = result * 59 + ($autonomousDataStorageSizeInTBs == null ? 43 : ((Object)$autonomousDataStorageSizeInTBs).hashCode());
        Integer $dbNodeStorageSizeInGBs = this.getDbNodeStorageSizeInGBs();
        result = result * 59 + ($dbNodeStorageSizeInGBs == null ? 43 : ((Object)$dbNodeStorageSizeInGBs).hashCode());
        Integer $memoryPerOracleComputeUnitInGBs = this.getMemoryPerOracleComputeUnitInGBs();
        result = result * 59 + ($memoryPerOracleComputeUnitInGBs == null ? 43 : ((Object)$memoryPerOracleComputeUnitInGBs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        String $subnetId = this.getSubnetId();
        result = result * 59 + ($subnetId == null ? 43 : $subnetId.hashCode());
        List<String> $nsgIds = this.getNsgIds();
        result = result * 59 + ($nsgIds == null ? 43 : ((Object)$nsgIds).hashCode());
        String $lastUpdateHistoryEntryId = this.getLastUpdateHistoryEntryId();
        result = result * 59 + ($lastUpdateHistoryEntryId == null ? 43 : $lastUpdateHistoryEntryId.hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeUpdated = this.getTimeUpdated();
        result = result * 59 + ($timeUpdated == null ? 43 : ((Object)$timeUpdated).hashCode());
        String $lifecycleDetails = this.getLifecycleDetails();
        result = result * 59 + ($lifecycleDetails == null ? 43 : $lifecycleDetails.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $cloudExadataInfrastructureId = this.getCloudExadataInfrastructureId();
        result = result * 59 + ($cloudExadataInfrastructureId == null ? 43 : $cloudExadataInfrastructureId.hashCode());
        String $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        LicenseModel $licenseModel = this.getLicenseModel();
        result = result * 59 + ($licenseModel == null ? 43 : ((Object)((Object)$licenseModel)).hashCode());
        String $lastMaintenanceRunId = this.getLastMaintenanceRunId();
        result = result * 59 + ($lastMaintenanceRunId == null ? 43 : $lastMaintenanceRunId.hashCode());
        String $nextMaintenanceRunId = this.getNextMaintenanceRunId();
        result = result * 59 + ($nextMaintenanceRunId == null ? 43 : $nextMaintenanceRunId.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "CloudAutonomousVmCluster(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", description=" + this.getDescription() + ", availabilityDomain=" + this.getAvailabilityDomain() + ", subnetId=" + this.getSubnetId() + ", nsgIds=" + this.getNsgIds() + ", lastUpdateHistoryEntryId=" + this.getLastUpdateHistoryEntryId() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", displayName=" + this.getDisplayName() + ", timeCreated=" + this.getTimeCreated() + ", timeUpdated=" + this.getTimeUpdated() + ", lifecycleDetails=" + this.getLifecycleDetails() + ", hostname=" + this.getHostname() + ", domain=" + this.getDomain() + ", cloudExadataInfrastructureId=" + this.getCloudExadataInfrastructureId() + ", shape=" + this.getShape() + ", nodeCount=" + this.getNodeCount() + ", dataStorageSizeInTBs=" + this.getDataStorageSizeInTBs() + ", dataStorageSizeInGBs=" + this.getDataStorageSizeInGBs() + ", cpuCoreCount=" + this.getCpuCoreCount() + ", ocpuCount=" + this.getOcpuCount() + ", memorySizeInGBs=" + this.getMemorySizeInGBs() + ", licenseModel=" + (Object)((Object)this.getLicenseModel()) + ", lastMaintenanceRunId=" + this.getLastMaintenanceRunId() + ", nextMaintenanceRunId=" + this.getNextMaintenanceRunId() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", availableCpus=" + this.getAvailableCpus() + ", reclaimableCpus=" + this.getReclaimableCpus() + ", availableContainerDatabases=" + this.getAvailableContainerDatabases() + ", totalContainerDatabases=" + this.getTotalContainerDatabases() + ", availableAutonomousDataStorageSizeInTBs=" + this.getAvailableAutonomousDataStorageSizeInTBs() + ", autonomousDataStorageSizeInTBs=" + this.getAutonomousDataStorageSizeInTBs() + ", dbNodeStorageSizeInGBs=" + this.getDbNodeStorageSizeInGBs() + ", memoryPerOracleComputeUnitInGBs=" + this.getMemoryPerOracleComputeUnitInGBs() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "description", "availabilityDomain", "subnetId", "nsgIds", "lastUpdateHistoryEntryId", "lifecycleState", "displayName", "timeCreated", "timeUpdated", "lifecycleDetails", "hostname", "domain", "cloudExadataInfrastructureId", "shape", "nodeCount", "dataStorageSizeInTBs", "dataStorageSizeInGBs", "cpuCoreCount", "ocpuCount", "memorySizeInGBs", "licenseModel", "lastMaintenanceRunId", "nextMaintenanceRunId", "freeformTags", "definedTags", "availableCpus", "reclaimableCpus", "availableContainerDatabases", "totalContainerDatabases", "availableAutonomousDataStorageSizeInTBs", "autonomousDataStorageSizeInTBs", "dbNodeStorageSizeInGBs", "memoryPerOracleComputeUnitInGBs"})
    @Deprecated
    public CloudAutonomousVmCluster(String id, String compartmentId, String description, String availabilityDomain, String subnetId, List<String> nsgIds, String lastUpdateHistoryEntryId, LifecycleState lifecycleState, String displayName, Date timeCreated, Date timeUpdated, String lifecycleDetails, String hostname, String domain, String cloudExadataInfrastructureId, String shape, Integer nodeCount, Double dataStorageSizeInTBs, Double dataStorageSizeInGBs, Integer cpuCoreCount, Float ocpuCount, Integer memorySizeInGBs, LicenseModel licenseModel, String lastMaintenanceRunId, String nextMaintenanceRunId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Float availableCpus, Float reclaimableCpus, Integer availableContainerDatabases, Integer totalContainerDatabases, Double availableAutonomousDataStorageSizeInTBs, Double autonomousDataStorageSizeInTBs, Integer dbNodeStorageSizeInGBs, Integer memoryPerOracleComputeUnitInGBs) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.description = description;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.nsgIds = nsgIds;
        this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleDetails = lifecycleDetails;
        this.hostname = hostname;
        this.domain = domain;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.shape = shape;
        this.nodeCount = nodeCount;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        this.cpuCoreCount = cpuCoreCount;
        this.ocpuCount = ocpuCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.licenseModel = licenseModel;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.availableCpus = availableCpus;
        this.reclaimableCpus = reclaimableCpus;
        this.availableContainerDatabases = availableContainerDatabases;
        this.totalContainerDatabases = totalContainerDatabases;
        this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
        this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
    }

    public static enum LicenseModel {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="lastUpdateHistoryEntryId")
        private String lastUpdateHistoryEntryId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="dataStorageSizeInTBs")
        private Double dataStorageSizeInTBs;
        @JsonProperty(value="dataStorageSizeInGBs")
        private Double dataStorageSizeInGBs;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="ocpuCount")
        private Float ocpuCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="availableCpus")
        private Float availableCpus;
        @JsonProperty(value="reclaimableCpus")
        private Float reclaimableCpus;
        @JsonProperty(value="availableContainerDatabases")
        private Integer availableContainerDatabases;
        @JsonProperty(value="totalContainerDatabases")
        private Integer totalContainerDatabases;
        @JsonProperty(value="availableAutonomousDataStorageSizeInTBs")
        private Double availableAutonomousDataStorageSizeInTBs;
        @JsonProperty(value="autonomousDataStorageSizeInTBs")
        private Double autonomousDataStorageSizeInTBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
        private Integer memoryPerOracleComputeUnitInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            this.__explicitlySet__.add("lastUpdateHistoryEntryId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            this.__explicitlySet__.add("dataStorageSizeInTBs");
            return this;
        }

        public Builder dataStorageSizeInGBs(Double dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            this.__explicitlySet__.add("dataStorageSizeInGBs");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder ocpuCount(Float ocpuCount) {
            this.ocpuCount = ocpuCount;
            this.__explicitlySet__.add("ocpuCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder availableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
            this.__explicitlySet__.add("availableCpus");
            return this;
        }

        public Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            this.__explicitlySet__.add("reclaimableCpus");
            return this;
        }

        public Builder availableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
            this.__explicitlySet__.add("availableContainerDatabases");
            return this;
        }

        public Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            this.__explicitlySet__.add("totalContainerDatabases");
            return this;
        }

        public Builder availableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("availableAutonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("autonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            this.__explicitlySet__.add("memoryPerOracleComputeUnitInGBs");
            return this;
        }

        public CloudAutonomousVmCluster build() {
            CloudAutonomousVmCluster __instance__ = new CloudAutonomousVmCluster(this.id, this.compartmentId, this.description, this.availabilityDomain, this.subnetId, this.nsgIds, this.lastUpdateHistoryEntryId, this.lifecycleState, this.displayName, this.timeCreated, this.timeUpdated, this.lifecycleDetails, this.hostname, this.domain, this.cloudExadataInfrastructureId, this.shape, this.nodeCount, this.dataStorageSizeInTBs, this.dataStorageSizeInGBs, this.cpuCoreCount, this.ocpuCount, this.memorySizeInGBs, this.licenseModel, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.freeformTags, this.definedTags, this.availableCpus, this.reclaimableCpus, this.availableContainerDatabases, this.totalContainerDatabases, this.availableAutonomousDataStorageSizeInTBs, this.autonomousDataStorageSizeInTBs, this.dbNodeStorageSizeInGBs, this.memoryPerOracleComputeUnitInGBs);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CloudAutonomousVmCluster o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).description(o.getDescription()).availabilityDomain(o.getAvailabilityDomain()).subnetId(o.getSubnetId()).nsgIds(o.getNsgIds()).lastUpdateHistoryEntryId(o.getLastUpdateHistoryEntryId()).lifecycleState(o.getLifecycleState()).displayName(o.getDisplayName()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).lifecycleDetails(o.getLifecycleDetails()).hostname(o.getHostname()).domain(o.getDomain()).cloudExadataInfrastructureId(o.getCloudExadataInfrastructureId()).shape(o.getShape()).nodeCount(o.getNodeCount()).dataStorageSizeInTBs(o.getDataStorageSizeInTBs()).dataStorageSizeInGBs(o.getDataStorageSizeInGBs()).cpuCoreCount(o.getCpuCoreCount()).ocpuCount(o.getOcpuCount()).memorySizeInGBs(o.getMemorySizeInGBs()).licenseModel(o.getLicenseModel()).lastMaintenanceRunId(o.getLastMaintenanceRunId()).nextMaintenanceRunId(o.getNextMaintenanceRunId()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).availableCpus(o.getAvailableCpus()).reclaimableCpus(o.getReclaimableCpus()).availableContainerDatabases(o.getAvailableContainerDatabases()).totalContainerDatabases(o.getTotalContainerDatabases()).availableAutonomousDataStorageSizeInTBs(o.getAvailableAutonomousDataStorageSizeInTBs()).autonomousDataStorageSizeInTBs(o.getAutonomousDataStorageSizeInTBs()).dbNodeStorageSizeInGBs(o.getDbNodeStorageSizeInGBs()).memoryPerOracleComputeUnitInGBs(o.getMemoryPerOracleComputeUnitInGBs());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CloudAutonomousVmCluster.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", description=" + this.description + ", availabilityDomain=" + this.availabilityDomain + ", subnetId=" + this.subnetId + ", nsgIds=" + this.nsgIds + ", lastUpdateHistoryEntryId=" + this.lastUpdateHistoryEntryId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", displayName=" + this.displayName + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", lifecycleDetails=" + this.lifecycleDetails + ", hostname=" + this.hostname + ", domain=" + this.domain + ", cloudExadataInfrastructureId=" + this.cloudExadataInfrastructureId + ", shape=" + this.shape + ", nodeCount=" + this.nodeCount + ", dataStorageSizeInTBs=" + this.dataStorageSizeInTBs + ", dataStorageSizeInGBs=" + this.dataStorageSizeInGBs + ", cpuCoreCount=" + this.cpuCoreCount + ", ocpuCount=" + this.ocpuCount + ", memorySizeInGBs=" + this.memorySizeInGBs + ", licenseModel=" + (Object)((Object)this.licenseModel) + ", lastMaintenanceRunId=" + this.lastMaintenanceRunId + ", nextMaintenanceRunId=" + this.nextMaintenanceRunId + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", availableCpus=" + this.availableCpus + ", reclaimableCpus=" + this.reclaimableCpus + ", availableContainerDatabases=" + this.availableContainerDatabases + ", totalContainerDatabases=" + this.totalContainerDatabases + ", availableAutonomousDataStorageSizeInTBs=" + this.availableAutonomousDataStorageSizeInTBs + ", autonomousDataStorageSizeInTBs=" + this.autonomousDataStorageSizeInTBs + ", dbNodeStorageSizeInGBs=" + this.dbNodeStorageSizeInGBs + ", memoryPerOracleComputeUnitInGBs=" + this.memoryPerOracleComputeUnitInGBs + ")";
        }
    }
}

