/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.ui.api.TestCreatorPanelDisplayer;
import org.netbeans.modules.java.testrunner.ui.hints.Bundle;
import org.netbeans.modules.java.testrunner.ui.hints.Utils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class CreateTestMethodsHint {
    public static ErrorDescription computeWarning(HintContext context) {
        TreePath tp = context.getPath();
        MethodTree method = (MethodTree)tp.getLeaf();
        if (method.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
            return null;
        }
        String methodName = method.getName().toString();
        CompilationInfo info = context.getInfo();
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        int startPos = (int)sourcePositions.getStartPosition(tp.getCompilationUnit(), method);
        int caret = context.getCaretLocation();
        String code = context.getInfo().getText();
        if (startPos < 0 || caret < 0 || caret < startPos || caret >= code.length()) {
            return null;
        }
        String headerText = code.substring(startPos, caret);
        int idx = headerText.indexOf(123);
        if (idx >= 0) {
            return null;
        }
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject fileObject = info.getFileObject();
        if (!fileObject.isValid()) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(fileObject);
        if (root == null) {
            return null;
        }
        Collection providers = Lookup.getDefault().lookupAll(TestCreatorProvider.class);
        Map<Object, List<String>> validCombinations = Utils.getValidCombinations(info, methodName);
        if (validCombinations == null) {
            return null;
        }
        for (TestCreatorProvider provider : providers) {
            if (!provider.enable(new FileObject[]{fileObject}) || validCombinations.isEmpty()) continue;
            ArrayList<CreateTestMethodsFix> fixes = new ArrayList<CreateTestMethodsFix>();
            for (Map.Entry<Object, List<String>> entrySet : validCombinations.entrySet()) {
                Object location = entrySet.getKey();
                for (String testingFramework : entrySet.getValue()) {
                    CreateTestMethodsFix fix = new CreateTestMethodsFix(new FileObject[]{fileObject}, location, testingFramework);
                    fixes.add(fix);
                }
            }
            validCombinations.clear();
            return ErrorDescriptionFactory.forTree((HintContext)context, (TreePath)context.getPath(), (String)Bundle.ERR_CreateTestMethodsHint(), (Fix[])fixes.toArray(new Fix[fixes.size()]));
        }
        validCombinations.clear();
        return null;
    }

    private static final class CreateTestMethodsFix
    implements Fix {
        FileObject[] activatedFOs;
        Object location;
        String testingFramework;

        public CreateTestMethodsFix(FileObject[] activatedFOs, Object location, String testingFramework) {
            this.activatedFOs = activatedFOs;
            this.location = location;
            this.testingFramework = testingFramework;
        }

        public String getText() {
            return Bundle.FIX_CreateTestMethodsHint(this.testingFramework, Utils.getLocationText(this.location));
        }

        public ChangeInfo implement() throws Exception {
            TestCreatorPanelDisplayer.getDefault().displayPanel(this.activatedFOs, this.location, this.testingFramework);
            return null;
        }
    }
}

