/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk.mapreduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.mapreduce.TreeUtilities;

public class PreconditionsChecker {
    private ForLoopTreeVisitor visitor;
    private boolean hasUncaughtException = false;
    private boolean isForLoop;
    private Set<Name> innerVariables;
    private CompilationInfo workingCopy;
    private boolean isIterable;

    public PreconditionsChecker(Tree forLoop, CompilationInfo workingCopy) {
        if (forLoop.getKind() == Tree.Kind.ENHANCED_FOR_LOOP) {
            this.isForLoop = true;
            this.workingCopy = workingCopy;
            this.hasUncaughtException = workingCopy.getTreeUtilities().getUncaughtExceptions(TreePath.getPath(workingCopy.getCompilationUnit(), forLoop)).stream().anyMatch(this::filterCheckedExceptions);
            this.innerVariables = this.getInnerVariables(forLoop, workingCopy.getTrees());
            this.visitor = new ForLoopTreeVisitor(this.innerVariables, workingCopy, new TreePath(workingCopy.getCompilationUnit()), (EnhancedForLoopTree)forLoop);
            this.isIterable = this.isIterbale(((EnhancedForLoopTree)forLoop).getExpression());
            this.visitor.scan(TreePath.getPath(workingCopy.getCompilationUnit(), forLoop), workingCopy.getTrees());
        } else {
            this.isForLoop = false;
        }
    }

    public Set<Name> getInnerVariables() {
        return this.innerVariables;
    }

    private Set<Name> getInnerVariables(Tree tree, Trees trees) {
        VariablesVisitor vis = new VariablesVisitor(new TreePath(this.workingCopy.getCompilationUnit()));
        vis.scan(tree, trees);
        return vis.getInnervariables();
    }

    public Boolean isSafeToRefactor() {
        return this.isForLoop && this.iteratesOverIterable() && this.throwsException() == false && this.containsNEFs() == false && this.containsReturn() == false && this.containsBreak() == false && this.containsContinue() == false;
    }

    protected Boolean throwsException() {
        return this.hasUncaughtException;
    }

    protected Boolean containsNEFs() {
        return this.visitor.hasNonEffectivelyFinalVars;
    }

    protected Boolean containsBreak() {
        return this.visitor.containsBreak();
    }

    protected Boolean containsContinue() {
        return this.visitor.containsContinue();
    }

    protected Boolean containsReturn() {
        return this.visitor.containsReturn();
    }

    public Boolean isReducer() {
        return this.visitor.reducerStatement != null;
    }

    public Tree getReducer() {
        return this.visitor.reducerStatement;
    }

    public IdentifierTree getVariableToAssign() {
        return this.visitor.mutatedVariable;
    }

    Map<Name, String> getVarToName() {
        return this.visitor.varToType;
    }

    private boolean iteratesOverIterable() {
        return this.isIterable;
    }

    private boolean isIterbale(ExpressionTree expression) {
        TypeMirror tm = this.workingCopy.getTrees().getTypeMirror(TreePath.getPath(this.workingCopy.getCompilationUnit(), (Tree)expression));
        if (!Utilities.isValidType(tm)) {
            return false;
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            return false;
        }
        tm = this.workingCopy.getTypes().erasure(tm);
        TypeElement typeEl = this.workingCopy.getElements().getTypeElement("java.util.Collection");
        if (typeEl != null) {
            TypeMirror collection = typeEl.asType();
            collection = this.workingCopy.getTypes().erasure(collection);
            if (this.workingCopy.getTypes().isSubtype(tm, collection)) {
                return true;
            }
        }
        return false;
    }

    private boolean filterCheckedExceptions(TypeMirror ex) {
        TypeElement el = this.workingCopy.getElements().getTypeElement("java.lang.RuntimeException");
        if (el == null) {
            return true;
        }
        if (this.workingCopy.getTypes().isSubtype(ex, el.asType())) {
            return false;
        }
        el = this.workingCopy.getElements().getTypeElement("java.lang.Error");
        return el == null || !this.workingCopy.getTypes().isSubtype(ex, el.asType());
    }

    private static class ForLoopTreeVisitor
    extends ErrorAwareTreePathScanner<Tree, Trees> {
        private Set<Name> inners;
        private CompilationInfo workingCopy;
        EnhancedForLoopTree loop;
        private Tree reducerStatement = null;
        private IdentifierTree mutatedVariable;
        Map<Name, String> varToType = new HashMap<Name, String>();
        private Boolean hasReturns = false;
        private Boolean hasBreaks = false;
        private Boolean hasContinue = false;
        private Boolean hasNonEffectivelyFinalVars = false;
        private Boolean hasOneNEFReducer = false;
        private Boolean hasMatcherReturn = false;

        public ForLoopTreeVisitor(Set<Name> inners, CompilationInfo workingCopy, TreePath treePath, EnhancedForLoopTree loop) {
            this.inners = inners;
            this.workingCopy = workingCopy;
            this.loop = loop;
        }

        public Boolean containsReturn() {
            return this.hasReturns;
        }

        public Boolean containsBreak() {
            return this.hasBreaks;
        }

        public Boolean containsContinue() {
            return this.hasContinue;
        }

        public Tree visitIdentifier(IdentifierTree that, Trees trees) {
            TypeMirror type = trees.getTypeMirror(this.getCurrentPath());
            if (type == null) {
                return (Tree)super.visitIdentifier(that, (Object)trees);
            }
            if (type.getKind().isPrimitive()) {
                this.varToType.put(that.getName(), this.workingCopy.getTypes().boxedClass((PrimitiveType)type).toString());
            } else {
                this.varToType.put(that.getName(), type.toString());
            }
            TreePath currentTreePath = this.getCurrentPath();
            Element el = trees.getElement(currentTreePath);
            if (el != null && this.isExternalNEF(el, that)) {
                this.checkIfRefactorableMutation(currentTreePath, that);
            }
            return (Tree)super.visitIdentifier(that, (Object)trees);
        }

        private boolean isLocalVariable(Element el) {
            return el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.PARAMETER;
        }

        public Tree visitContinue(ContinueTree that, Trees trees) {
            if (that.getLabel() != null || !this.isIfWithContinueOnly(that)) {
                this.hasContinue = true;
            }
            return (Tree)super.visitContinue(that, (Object)trees);
        }

        public Tree visitReturn(ReturnTree that, Trees trees) {
            ExpressionTree thatExpression = that.getExpression();
            if (!this.hasMatcherReturn.booleanValue() && thatExpression != null && thatExpression.getKind() == Tree.Kind.BOOLEAN_LITERAL && this.thisIsMatcherReturn(that, this.getCurrentPath())) {
                this.hasMatcherReturn = true;
            } else {
                this.hasReturns = true;
            }
            return (Tree)super.visitReturn(that, (Object)trees);
        }

        public Tree visitBreak(BreakTree that, Trees trees) {
            this.hasBreaks = true;
            return (Tree)super.visitBreak(that, (Object)trees);
        }

        private boolean isIfWithContinueOnly(ContinueTree that) {
            BlockTree parentBlock;
            TreePath currentTreePath = this.getCurrentPath();
            TreePath parentPath = currentTreePath.getParentPath();
            Tree parentTree = parentPath.getLeaf();
            if (parentTree.getKind() == Tree.Kind.IF) {
                return true;
            }
            return parentTree.getKind() == Tree.Kind.BLOCK && (parentBlock = (BlockTree)parentTree).getStatements().size() == 1;
        }

        private boolean thisIsMatcherReturn(Tree that, TreePath currentTreePath) {
            TreePath parentPath = currentTreePath.getParentPath();
            Tree parent = parentPath.getLeaf();
            if (parent.getKind() == Tree.Kind.BLOCK && ((BlockTree)parent).getStatements().size() == 1) {
                return this.thisIsMatcherReturn(parent, parentPath);
            }
            return parent.getKind() == Tree.Kind.IF && ((IfTree)parent).getElseStatement() == null;
        }

        private boolean isLastInControlFlow(TreePath pathToInstruction) {
            Tree currentTree = pathToInstruction.getLeaf();
            Tree parentTree = pathToInstruction.getParentPath().getLeaf();
            if (parentTree.equals(this.loop)) {
                return true;
            }
            if (parentTree.getKind() == Tree.Kind.BLOCK) {
                List<? extends StatementTree> ls = ((BlockTree)parentTree).getStatements();
                if (ls.get(ls.size() - 1).equals(currentTree)) {
                    return this.isLastInControlFlow(pathToInstruction.getParentPath());
                }
                return false;
            }
            if (parentTree.getKind() == Tree.Kind.IF && ((IfTree)parentTree).getElseStatement() != null) {
                return false;
            }
            return this.isLastInControlFlow(pathToInstruction.getParentPath());
        }

        private boolean isStatementPreOrPostfix(Tree parent, Tree parentOfParent) {
            return TreeUtilities.isPreOrPostfixOp(parent.getKind()) && parentOfParent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        }

        private boolean isLeftHandSideOfCompoundAssignement(Tree parent, IdentifierTree that) {
            return TreeUtilities.isCompoundAssignementAssignement(parent.getKind()) && ((CompoundAssignmentTree)parent).getVariable().equals(that);
        }

        private boolean isExternalNEF(Element el, IdentifierTree that) {
            return this.isLocalVariable(el) && !this.workingCopy.getElementUtilities().isEffectivelyFinal((VariableElement)el) && !this.inners.contains(that.getName());
        }

        private boolean isPureMutator(TreePath parentOfParentPath) {
            return parentOfParentPath.getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT && this.isLastInControlFlow(parentOfParentPath);
        }

        private void checkIfRefactorableMutation(TreePath currentTreePath, IdentifierTree that) {
            TreePath parentOfParentPath;
            Tree parentOfParent;
            Tree parent = currentTreePath.getParentPath().getLeaf();
            if ((this.isStatementPreOrPostfix(parent, parentOfParent = (parentOfParentPath = currentTreePath.getParentPath().getParentPath()).getLeaf()) || this.isLeftHandSideOfCompoundAssignement(parent, that)) && this.isPureMutator(parentOfParentPath)) {
                if (this.hasOneNEFReducer.booleanValue()) {
                    this.hasNonEffectivelyFinalVars = true;
                } else {
                    this.hasOneNEFReducer = true;
                    this.reducerStatement = currentTreePath.getParentPath().getParentPath().getLeaf();
                    this.mutatedVariable = that;
                }
            } else {
                this.hasNonEffectivelyFinalVars = true;
            }
        }
    }

    public static class VariablesVisitor
    extends ErrorAwareTreeScanner<Tree, Trees> {
        private Set<Name> innerVariables = new HashSet<Name>();
        private Set<Name> allLocalVariables = new HashSet<Name>();
        private TreePath treePath;

        public VariablesVisitor(TreePath tp) {
            this.treePath = tp;
        }

        public Set<Name> getInnervariables() {
            return this.innerVariables;
        }

        public Set<Name> getAllLocalVariablesUsed() {
            return this.allLocalVariables;
        }

        public Tree visitVariable(VariableTree that, Trees trees) {
            this.innerVariables.add(that.getName());
            this.allLocalVariables.add(that.getName());
            return (Tree)super.visitVariable(that, (Object)trees);
        }

        public Tree visitIdentifier(IdentifierTree that, Trees trees) {
            if (this.isLocalVariable(that, trees)) {
                this.allLocalVariables.add(that.getName());
            }
            return (Tree)super.visitIdentifier(that, (Object)trees);
        }

        private boolean isLocalVariable(IdentifierTree id, Trees trees) {
            Element el = trees.getElement(TreePath.getPath(this.treePath, (Tree)id));
            if (el != null) {
                return el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.PARAMETER;
            }
            return false;
        }
    }
}

