/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Bundle;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationsManager;
import org.openide.util.WeakListeners;

public class ConfigurationsComboModel
extends AbstractListModel
implements ComboBoxModel,
ChangeListener {
    private New aNew = new New(Bundle.CTL_NewConfig(), Bundle.ConfigDefaultName());
    private Delete delete = new Delete();
    private New duplicate = new New(Bundle.CTL_Duplicate(), null);
    private Rename rename = new Rename();
    private Object selected = this.getSize() == 0 ? null : this.getElementAt(0);
    private Configuration lastSelected = (Configuration)this.selected;
    private boolean canModify;

    public ConfigurationsComboModel(boolean canModify) {
        this.canModify = canModify;
        ConfigurationsManager.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)ConfigurationsManager.getDefault()));
    }

    @Override
    public int getSize() {
        return ConfigurationsManager.getDefault().size() + (this.canModify ? 4 : 0);
    }

    @Override
    public Object getElementAt(int i) {
        if (this.canModify) {
            if (i == this.getSize() - 4) {
                return this.aNew;
            }
            if (i == this.getSize() - 3) {
                return this.duplicate;
            }
            if (i == this.getSize() - 2) {
                return this.rename;
            }
            if (i == this.getSize() - 1) {
                return this.delete;
            }
        }
        return ConfigurationsManager.getDefault().getConfiguration(i);
    }

    public boolean canModify() {
        return this.canModify;
    }

    @Override
    public void setSelectedItem(Object o) {
        this.setLastSelected(this.selected);
        this.selected = o;
        this.fireContentsChanged(this, -1, -1);
    }

    private void setLastSelected(Object o) {
        if (o instanceof Configuration) {
            this.lastSelected = (Configuration)o;
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.fireContentsChanged(this, -1, -1);
    }

    private class Delete
    implements ActionListener {
        private Delete() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ConfigurationsManager.getDefault().size() == 1) {
                ConfigurationsComboModel.this.setSelectedItem(ConfigurationsComboModel.this.getElementAt(0));
                return;
            }
            JComboBox combo = (JComboBox)ae.getSource();
            combo.setSelectedItem(ConfigurationsComboModel.this.lastSelected);
            combo.hidePopup();
            if (JOptionPane.showConfirmDialog(combo, Bundle.MSG_ReallyDeleteConfig(ConfigurationsComboModel.this.lastSelected), Bundle.DeleteConfigTitle(), 0) == 0) {
                ConfigurationsManager.getDefault().remove(ConfigurationsComboModel.this.lastSelected);
                ConfigurationsComboModel.this.setSelectedItem(ConfigurationsComboModel.this.getElementAt(0));
            }
        }

        public String toString() {
            return Bundle.CTL_Delete();
        }
    }

    private class Rename
    implements ActionListener,
    FocusListener,
    KeyListener,
    PopupMenuListener {
        private Rename() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JComboBox combo = (JComboBox)ae.getSource();
            combo.setEditable(true);
            JTextField editorComponent = (JTextField)combo.getEditor().getEditorComponent();
            editorComponent.addFocusListener(this);
            editorComponent.addKeyListener(this);
            combo.setSelectedItem(ConfigurationsComboModel.this.lastSelected);
            combo.addPopupMenuListener(this);
        }

        public String toString() {
            return Bundle.CTL_Rename();
        }

        @Override
        public void focusGained(FocusEvent fe) {
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.confirm(fe);
        }

        private void confirm(EventObject fe) {
            JTextField tf = (JTextField)fe.getSource();
            JComboBox combo = (JComboBox)tf.getParent();
            if (combo == null) {
                return;
            }
            if (fe instanceof FocusEvent) {
                combo.getEditor().getEditorComponent().removeFocusListener(this);
            } else {
                combo.getEditor().getEditorComponent().removeKeyListener(this);
            }
            Configuration config = ConfigurationsComboModel.this.lastSelected;
            config.setDisplayName(tf.getText());
            combo.setSelectedItem(config);
            combo.setEditable(false);
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyChar() == '\n' || ke.getKeyCode() == 27) {
                this.confirm(ke);
            }
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            this.confirm(new EventObject(combo.getEditor().getEditorComponent()));
            combo.removePopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class New
    implements ActionListener,
    FocusListener,
    KeyListener,
    PopupMenuListener {
        private final String actionName;
        private final String configName;

        public New(String actionName, String configName) {
            this.actionName = actionName;
            this.configName = configName;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JComboBox combo = (JComboBox)ae.getSource();
            combo.setEditable(true);
            combo.getEditor().getEditorComponent().addFocusListener(this);
            combo.getEditor().getEditorComponent().addKeyListener(this);
            combo.addPopupMenuListener(this);
            combo.setSelectedItem(this.configName == null ? ConfigurationsComboModel.this.lastSelected + "1" : this.configName);
        }

        public String toString() {
            return this.actionName;
        }

        @Override
        public void focusGained(FocusEvent fe) {
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.confirm(fe);
        }

        private void confirm(EventObject fe) {
            JTextField tf = (JTextField)fe.getSource();
            JComboBox combo = (JComboBox)tf.getParent();
            if (combo == null) {
                return;
            }
            if (fe instanceof FocusEvent) {
                combo.getEditor().getEditorComponent().removeFocusListener(this);
            } else {
                combo.getEditor().getEditorComponent().removeKeyListener(this);
            }
            Configuration config = this.configName == null ? ConfigurationsManager.getDefault().duplicate(ConfigurationsComboModel.this.lastSelected, tf.getText(), tf.getText()) : ConfigurationsManager.getDefault().create(tf.getText(), tf.getText());
            combo.setSelectedItem(config);
            combo.setEditable(false);
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10 || ke.getKeyCode() == 27) {
                this.confirm(ke);
            }
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            this.confirm(new EventObject(combo.getEditor().getEditorComponent()));
            combo.removePopupMenuListener(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

