/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.pdf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.netbeans.modules.pdf.PDFOpenSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkProcessor
implements InstanceCookie,
XMLDataObject.Processor,
ActionListener {
    public static final String PUBLIC_ID = "-//NetBeans//DTD PDF Document Menu Link 1.0//EN";
    public static final String PUBLIC_WWW = "http://www.netbeans.org/dtds/pdf_link-1_0.dtd";
    private XMLDataObject xmlDataObject;

    public void attachTo(XMLDataObject xmlDataObject) {
        this.xmlDataObject = xmlDataObject;
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return JMenuItem.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        String name = this.xmlDataObject.getNodeDelegate().getDisplayName();
        JMenuItem menuItem = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)menuItem, (String)name);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public String instanceName() {
        return this.xmlDataObject.getName();
    }

    private String getXMLFileName() {
        FileObject fileObject = this.xmlDataObject.getPrimaryFile();
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    private void notifyXMLFileBroken() {
        String msg = NbBundle.getMessage(LinkProcessor.class, (String)"EXC_file_not_matching_DTD", (Object)this.getXMLFileName());
        ErrorManager.getDefault().log(256, msg);
    }

    private void notifyBadFileSpec(String msgKey, String urlSpec, boolean isError) {
        String msg = NbBundle.getMessage(LinkProcessor.class, (String)msgKey, (Object)this.getXMLFileName(), (Object)urlSpec);
        ErrorManager.getDefault().log(isError ? 16 : 256, msg);
    }

    private void notifyFileDoesNotExist(String path) {
        String msg = NbBundle.getMessage(LinkProcessor.class, (String)"MSG_File_does_not_exist", (Object)path);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
    }

    private File grabFile(Element innerElement) {
        String linkType = innerElement.getTagName();
        if (linkType.equals("file")) {
            if (!innerElement.hasAttribute("path")) {
                this.notifyXMLFileBroken();
                return null;
            }
            return new File(innerElement.getAttribute("path"));
        }
        if (linkType.equals("idefile")) {
            if (!innerElement.hasAttribute("base")) {
                this.notifyXMLFileBroken();
                return null;
            }
            String base = innerElement.getAttribute("base");
            String path = base.replace('.', '/') + ".pdf";
            File file = InstalledFileLocator.getDefault().locate(path, null, true);
            if (file == null) {
                this.notifyFileDoesNotExist(path);
                return null;
            }
            return file;
        }
        if (linkType.equals("url")) {
            URL url;
            if (!innerElement.hasAttribute("name")) {
                this.notifyXMLFileBroken();
                return null;
            }
            String urlSpec = innerElement.getAttribute("name");
            try {
                url = new URL(urlSpec);
            }
            catch (MalformedURLException ex) {
                this.notifyBadFileSpec("MSG_Cannot_open_malformed_URL", urlSpec, true);
                return null;
            }
            if (!url.getProtocol().equals("file")) {
                this.notifyBadFileSpec("MSG_Cannot_open_unsupported_URL", urlSpec, false);
            }
            try {
                return new File(new URI("file://" + url.getPath()));
            }
            catch (URISyntaxException ex1) {
                ErrorManager.getDefault().notify((Throwable)ex1);
                return null;
            }
            catch (IllegalArgumentException ex2) {
                ErrorManager.getDefault().notify((Throwable)ex2);
                return null;
            }
        }
        this.notifyXMLFileBroken();
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            Document document = this.xmlDataObject.getDocument();
            Element pdfLinkElement = document.getDocumentElement();
            NodeList nodeList = pdfLinkElement.getChildNodes();
            int count = nodeList.getLength();
            Node node = null;
            for (int i = 0; i < count; ++i) {
                Node nextNode = nodeList.item(i);
                if (nextNode.getNodeType() != 1) continue;
                if (node == null) {
                    node = nextNode;
                    continue;
                }
                this.notifyXMLFileBroken();
                return;
            }
            if (node == null) {
                this.notifyXMLFileBroken();
                return;
            }
            Element innerElement = (Element)node;
            File file = this.grabFile(innerElement);
            if (file != null) {
                try {
                    new PDFOpenSupport(file).open();
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.notifyFileDoesNotExist(file.getPath());
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }
}

