/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.editor.ConsoleFoldsProvider;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldInfo;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConsoleFoldManager
implements FoldManager {
    private static final Logger LOG = Logger.getLogger(ConsoleFoldManager.class.getName());
    private static Map<DataObject, FoldTask> fileTaskMap = new WeakHashMap<DataObject, FoldTask>();
    private FoldTask parserTask;
    private FoldOperation operation;

    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        Object od = doc.getProperty("stream");
        if (od instanceof DataObject) {
            FileObject file = ((DataObject)od).getPrimaryFile();
            this.parserTask = FoldTask.getTask(file);
            this.parserTask.updateFoldManager(this, file);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.invalidate();
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.invalidate();
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
        if (this.parserTask != null) {
            this.parserTask.updateFoldManager(this, null);
        }
    }

    private void invalidate() {
        if (this.parserTask != null) {
            this.parserTask.invalidate();
        }
    }

    private void update(List<FoldInfo> infos) {
        FoldOperation op = this.operation;
        if (op == null) {
            return;
        }
        Document d = this.operation.getHierarchy().getComponent().getDocument();
        d.render(() -> {
            this.operation.getHierarchy().lock();
            try {
                op.update((Collection)infos, null, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.operation.getHierarchy().unlock();
            }
        });
    }

    public static class FoldTaskFactory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            FoldTask ft = FoldTask.getTask(snapshot.getSource().getFileObject());
            if (ft == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(ft);
        }
    }

    public static class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new ConsoleFoldManager();
        }
    }

    static final class FoldTask
    extends ParserResultTask<ConsoleContents> {
        private final AtomicInteger version = new AtomicInteger();
        private final List<Reference<ConsoleFoldManager>> managers = new ArrayList<Reference<ConsoleFoldManager>>();
        private static final ResourceBundle infoBundle = NbBundle.getBundle((String)"org/netbeans/modules/jshell/tool/Bundle");
        private static final Pattern SYSTEM_INFO_PATTERN = Pattern.compile("^.*" + Pattern.quote(infoBundle.getString("MSG_SystemInformation")), 8);
        private static final Pattern JAVA_RUNTIME_PATTERN;
        private static final Pattern CLASSPATH_PATTERN;
        private static final int CLASSPATH_ITEMS_THRESHOLD = 4;

        FoldTask() {
        }

        void updateFoldManager(ConsoleFoldManager mgr, FileObject f) {
            if (f == null) {
                Iterator<Reference<ConsoleFoldManager>> it = this.managers.iterator();
                while (it.hasNext()) {
                    Reference<ConsoleFoldManager> ref = it.next();
                    ConsoleFoldManager fm = ref.get();
                    if (fm != null && fm != mgr) continue;
                    it.remove();
                    break;
                }
            } else {
                this.managers.add(new WeakReference<ConsoleFoldManager>(mgr));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FoldTask getTask(FileObject f) {
            if (f == null) {
                return null;
            }
            try {
                DataObject d = DataObject.find((FileObject)f);
                Map map = fileTaskMap;
                synchronized (map) {
                    FoldTask ft = (FoldTask)((Object)fileTaskMap.get(d));
                    if (ft != null) {
                        return ft;
                    }
                    ft = new FoldTask();
                    fileTaskMap.put(d, ft);
                    return ft;
                }
            }
            catch (DataObjectNotFoundException ex) {
                return new FoldTask();
            }
        }

        private synchronized List<ConsoleFoldManager> findLiveManagers() {
            ArrayList<ConsoleFoldManager> result = new ArrayList<ConsoleFoldManager>();
            Iterator<Reference<ConsoleFoldManager>> it = this.managers.iterator();
            while (it.hasNext()) {
                Reference<ConsoleFoldManager> ref = it.next();
                ConsoleFoldManager fm = ref.get();
                if (fm == null) {
                    it.remove();
                    continue;
                }
                if (result == null) continue;
                result.add(fm);
            }
            return result;
        }

        void invalidate() {
            this.version.incrementAndGet();
        }

        public void run(ConsoleContents result, SchedulerEvent event) {
            Document d = result.getSnapshot().getSource().getDocument(false);
            if (d == null) {
                return;
            }
            ArrayList<FoldInfo> infos = new ArrayList<FoldInfo>();
            block4: for (ConsoleSection s : result.getSectionModel().getSections()) {
                if (s == result.getInputSection()) continue;
                int so = s.getStart();
                int eo = s.getEnd() - 1;
                switch (s.getType()) {
                    default: {
                        continue block4;
                    }
                    case MESSAGE: {
                        if (this.processMessageSection(s, d, infos)) continue block4;
                        infos.add(FoldInfo.range((int)so, (int)eo, (FoldType)ConsoleFoldsProvider.MESSAGE));
                        continue block4;
                    }
                    case OUTPUT: 
                }
                infos.add(FoldInfo.range((int)so, (int)eo, (FoldType)ConsoleFoldsProvider.OUTPUT));
            }
            for (ConsoleFoldManager mgr : this.findLiveManagers()) {
                mgr.update(infos);
            }
        }

        private boolean processMessageSection(ConsoleSection section, Document d, List<FoldInfo> infos) {
            String l;
            String l2;
            int end;
            if (d == null) {
                return true;
            }
            String contents = section.getContents(d);
            Matcher m = JAVA_RUNTIME_PATTERN.matcher(contents);
            if (!m.find()) {
                return false;
            }
            String desc = m.groupCount() > 0 ? Bundle.FoldDesc_SystemInfo_1(m.group(1)) : Bundle.FoldDesc_SystemInfo_2();
            FoldInfo initInfo = FoldInfo.range((int)section.getStart(), (int)(section.getEnd() - 1), (FoldType)ConsoleFoldsProvider.INITIAL_INFO);
            infos.add(initInfo.withDescription(desc));
            m = CLASSPATH_PATTERN.matcher(contents);
            if (!m.find()) {
                return true;
            }
            int start = end = m.end() + 1;
            String[] lines = contents.substring(end).split("\\n *");
            int lcount = 0;
            String[] stringArray = lines;
            int n = stringArray.length;
            for (int i = 0; i < n && !(l2 = (l = stringArray[i]).trim()).isEmpty(); ++i) {
                end += l.length() + 1;
                ++lcount;
            }
            if (lcount < 4) {
                return true;
            }
            infos.add(FoldInfo.range((int)section.offsetFromContents(start), (int)section.offsetFromContents(end - 1), (FoldType)ConsoleFoldsProvider.CLASSPATH_INFO));
            return true;
        }

        public int getPriority() {
            return 100;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
        }

        public void cancel() {
        }

        static {
            String s = infoBundle.getString("MSG_JavaVersion");
            int index = s.indexOf("{0}");
            s = index > 0 ? Pattern.quote(s.substring(0, index)) + "(.*)" + Pattern.quote(s.substring(index + 3)) : Pattern.quote(s);
            JAVA_RUNTIME_PATTERN = Pattern.compile("^.*" + s, 8);
            CLASSPATH_PATTERN = Pattern.compile("^.*" + Pattern.quote(infoBundle.getString("MSG_Classpath")) + ".*$", 8);
        }
    }
}

